#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/types.h>

#include "udm_utils.h"
#include "udm_common.h"
#include "udm_log.h"



__INDLIB__ int UdmSetRefProc(UDM_ENV * Conf,void (*_RefProc)(int code,const char *url, const char *ref)){
	Conf->RefInfo=_RefProc;
	return(0);
}

__INDLIB__ int UdmSetThreadProc(UDM_ENV * Conf,void (*_ThreadInfo)(int handle,const char *state, const char* str)){
	Conf->ThreadInfo=_ThreadInfo;
	return(0);
}

__INDLIB__ int UdmSetStatProc(UDM_ENV * Conf,void (*_StatInfo)(int handle,int code, int expired, int total, const char* str)){
	Conf->StatInfo=_StatInfo;
	return(0);
}

typedef struct _code {
        const char *c_name;
        int     c_val;
} CODE;

#ifdef HAVE_SYSLOG_H
static const CODE facilitynames[] ={
#ifdef LOG_AUTH
    {"auth",	LOG_AUTH},
#endif
#ifdef LOG_AUTHPRIV
    {"authpriv",LOG_AUTHPRIV},
#endif
#ifdef LOG_CRON
    {"cron", 	LOG_CRON},
#endif
#ifdef LOG_DAEMON
    {"daemon",	LOG_DAEMON},
#endif
#ifdef LOG_FTP
    {"ftp",	LOG_FTP},
#endif
#ifdef LOG_KERN
    {"kern",	LOG_KERN},
#endif
#ifdef LOG_LPR
    {"lpr",	LOG_LPR},
#endif
#ifdef LOG_MAIL
    {"mail",	LOG_MAIL},
#endif
#ifdef LOG_NEWS
    {"news",	LOG_NEWS},
#endif
#ifdef LOG_SYSLOG
    {"syslog",	LOG_SYSLOG},
#endif
#ifdef LOG_USER
    {"user",	LOG_USER},
#endif
#ifdef LOG_UUCP
    {"uucp",	LOG_UUCP},
#endif
#ifdef LOG_LOCAL0
    {"local0",	LOG_LOCAL0},
#endif
#ifdef LOG_LOCAL1
    {"local1",	LOG_LOCAL1},
#endif
#ifdef LOG_LOCAL2
    {"local2",	LOG_LOCAL2},
#endif
#ifdef LOG_LOCAL3
    {"local3",	LOG_LOCAL3},
#endif
#ifdef LOG_LOCAL4
    {"local4",	LOG_LOCAL4},
#endif
#ifdef LOG_LOCAL5
    {"local5",	LOG_LOCAL5},
#endif
#ifdef LOG_LOCAL6
    {"local6",	LOG_LOCAL6},
#endif
#ifdef LOG_LOCAL7
    {"local7",	LOG_LOCAL7},
#endif
    {NULL,		-1},
};
static int syslog_facility(const char *f){
	const CODE *fn;
	fn=facilitynames;
	while (fn->c_name!=NULL){
		if (strcasecmp(f, fn->c_name)==0)
			return fn->c_val;
		fn++;
	}
	fprintf(stderr, "Config file error: unknown facility given: %s\n\r", f);
	fprintf(stderr, "Will continue with default facility\n\r");
	return LOG_FACILITY;
}

#endif /* HAVE_SYSLOG_H */


__INDLIB__ void UdmSetLogLevel(UDM_ENV *Env, int level){
	Env->logLevel=level;
}

__INDLIB__ void UdmSetLogFacility(UDM_ENV *Env, const char * facility){
	if(!strcmp(facility,"")){
		Env->logFacility=LOG_FACILITY;
		return;
	}
#ifdef HAVE_SYSLOG_H
	Env->logFacility=syslog_facility(facility);
#endif
}



int UdmOpenLog(UDM_ENV *Env, int log2stderr){
#if defined HAVE_SYSLOG_H && defined USE_SYSLOG
/* LOG_PERROR supported by 4.3BSD Reno releases and later */
#ifdef LOG_PERROR
    openlog("Indexer",(log2stderr)?LOG_PERROR|LOG_PID:LOG_PID,Env->logFacility);
#else
    openlog("Indexer",LOG_PID,Env->logFacility);
    if (log2stderr)
	    Env->logFD=stderr;
#endif /* LOG_PERROR */
#else
    /* If syslog not found or not used, use stderr. */
    if (log2stderr)
	    Env->logFD=stderr;
#endif /* HAVE_SYSLOG_H */
    Env->is_log_open=1;
    return(0);
}

static int udm_logger(UDM_ENV *Env, int handle, int level, const char *fmt, va_list ap){
	char buf[UDM_LOG_BUF_LEN+1];
	int i=0;

	if (Env->logLevel < level)
		 return 0;

#if (WIN32|WINNT)
	_vsnprintf(buf,UDM_LOG_BUF_LEN,fmt,ap);
#ifdef _CONSOLE
	printf("%s\n",buf);
#else
	if(Env->ThreadInfo)Env->ThreadInfo(0,"",buf);
#endif
#else
	if (handle)
		i=udm_snprintf(buf,UDM_LOG_BUF_LEN,"[%d] ", handle);
	udm_vsnprintf(buf+i,(size_t)(UDM_LOG_BUF_LEN-i),fmt,ap);
#endif

#if defined HAVE_SYSLOG_H && defined USE_SYSLOG
	syslog((level!=UDM_LOG_ERROR)?LOG_INFO:LOG_ERR,"%s",buf);
#endif
	if (Env->logFD)
	     fprintf(Env->logFD,"%s\n",buf); 
	return 1;
}



void UdmLog(UDM_AGENT *Agent, int level, const char *fmt, ...){
	va_list ap;

	if (!Agent){
	    fprintf(stderr, "BUG IN LOG - blame Kir\n");
	    return;
	}

#if (WIN32|WINNT)
#else
	if(Agent->Conf->is_log_open){
#endif
		va_start(ap,fmt);
		udm_logger(Agent->Conf, Agent->handle,level,fmt,ap);
		va_end(ap);
#if (WIN32|WINNT)
#else
	}else
		fprintf(stderr,"Log has not been opened\n");
#endif
	return;
}

void UdmLog_noagent(UDM_ENV * Env, int level, const char *fmt, ...){
	va_list ap;

#if (WIN32|WINNT)
#else
	if(Env->is_log_open){
#endif
		va_start(ap,fmt);
		udm_logger(Env, 0, level, fmt, ap);
		va_end(ap);
#if (WIN32|WINNT)
#else
	}else
		fprintf(stderr,"Log has not been opened\n");
#endif
	return;
}
