#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "udm_config.h"
#include "udmsearch.h"

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif


static void usage(void){

	fprintf(stderr,
"\n\
splitter from %s\n\
http://search.mnogo.ru (C) 1998-2001, LavTech Corp.\n\
\n\
Usage: splitter [OPTIONS]\n\
\n\
Options are:\n\
  -p            prepare cachelogd logs for splitter\n\
  -f xxx        start at xxx.log, where xxx is a hex number \n\
  -t xxx        stop  at xxx.log, where xxx is a hex number\n\
  -h,-?         print this help page and exit\n\
\n\
Please mail bug reports and suggestions to <udmsearch@search.udm.net>.\n",UdmVersion());

	return;
}


int main(int argc,char **argv){
int ch,log;
int from=0;
int to=0xFFF;

	while ((ch = getopt(argc, argv, "pt:f:h?")) != -1){
		switch (ch) {
			case 'p':
				UdmPreSplitCacheLog();
				return 0;
				break;
			case 'f':
				sscanf(optarg,"%x",&from);
				if(from<0)from=0;
				if(from>0xFFF)from=0xFFF;
				break;	
			case 't': 
				sscanf(optarg,"%x",&to);
				if(to<0)to=0;
				if(to>0xFFF)to=0xFFF;
				break;
			case 'h':
			case '?':
			default:
				usage();
				return 1;
				break;
		}
	}
	argc -= optind;argv += optind;

	if(argc>0){
		usage();
		return 1;
	}

	for(log=from;log<=to;log++){
		UdmSplitCacheLog(log);
	}
	
	return 0;
}
