package applications.basics;


/** 

    t_connect is the connection-Object to the Database.


    Admin V1.1 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

import java.io.*;
import java.net.URL;
import java.sql.*;
import java.util.Properties;
import java.util.Vector;




public class t_connect {

public Statement stmt;
public Connection con;
public String excpt;



    /**
     * connect to the Database:
     * @host = a String that contains the DB-Server-hostname e.g. gotzenwil.eidberg.ch
     * @user = a String that represents the user as it is in the grant-table of the db
     * @password = a String that contains the users password: Attention: not encrypted,
     *             is going in plaintext over the network, (Yes, there is some room for improvement)
     * @database = the name of the database you want to connect to
     *
     * the JDBC-Driver stuff is in a property-file stored in the users -home-dir 
     * named: t_connect.props
     */
     

public t_connect (String host, String user, String password, String database) {

    Properties prop = new Properties();

    try {
	FileInputStream fip = new FileInputStream(System.getProperty("user.home")+File.separator+"t_connect.props");
	prop.load(fip);
    }
    catch (Exception ioex) {
       System.out.println("t_connect: can not load t_connect.props" + ioex + "\n using standard values");
       prop.put("JDBCdriver","org.gjt.mm.mysql.Driver");
       prop.put("JDBCurl","jdbc:mysql://");
       prop.put("DatabasePort","3306");
       prop.put("usePassword","yes");
    }

 excpt = null;
 String url = "";
 int po = 0; 
 try
 {

     Class.forName(prop.getProperty("JDBCdriver"));
     url    = prop.getProperty("JDBCurl") ;

     // For non networked stuff set Port to 0
     try {
	 po = Integer.parseInt(prop.getProperty("DatabasePort"));
     } catch (NumberFormatException nfe) { po = 0; }


     if (po > 0 ) {
	 url = url + host + ":" + prop.getProperty("DatabasePort") + "/" + database;
     } else {
	 url = url + database;
     }

     Properties p = new Properties();

     p.put("user",user);
     if ( prop.getProperty("usePassword").equalsIgnoreCase("yes") ) {
	 p.put("password", password);
     } 
     con = DriverManager.getConnection(url,p);
     
     stmt = con.createStatement();
  }
  catch (Exception e) {
  excpt = "Exception while opening "+ database + " on " + host + " : " + e.getMessage() + "\n" +
          "url: " + url;

  }
  
}

public void close() {

 excpt = null;
 try
 {
  stmt.close();
  con.close();
  }
  catch (Exception e) {
  excpt = "Exception while closing projects: " + e.getMessage().toString();
  }
}

public String getError() {

  return excpt;
 
}
}
