package mysqladmin;



/** 
    Tables lists the tables found in the Database.
    It is very often used inside Admin.

    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
import java.util.*;
import java.sql.*;

public class TableColumns {


    Vector  allCols;
    
    String Table;
    
    /**
       * Get the value of Table.
       * @return Value of Table.
       */
    public String getTable() {return Table;}
    
    /**
       * Set the value of Table.
       * @param v  Value to assign to Table.
       */
    public void setTable(String  v) {this.Table = v;}
    
    
    /**
       * Get the value of allCols.
       * @return Value of allCols.
       */
    public Vector  getAllCols() {return allCols;}
    
    

   /**
       * Get the value of host.
       * @return Value of host.
       */

    private String host;
    public String getHost() {return host;}
    
    /**
       * Set the value of host.
       * @param v  Value to assign to host.
       */
    public void setHost(String  v) {this.host = v;}
    

    /** to find out, when the user wants to close
     *  this application, set a listener onto (JButton)AutoForm.cancel 
     **/

    private String user;
    
    /**
       * Get the value of user.
       * @return Value of user.
       */
    public String getUser() {return user;}
    
    /**
       * Set the value of user.
       * @param v  Value to assign to user.
       */
    public void setUser(String  v) {this.user = v;}
    

    private String password;
    
    /**
       * Get the value of password.
       * @return Value of password.
       */
    public String getPassword() {return password;}
    
    /**
       * Set the value of password.
       * @param v  Value to assign to password.
       */
    public void setPassword(String  v) {this.password = v;}


    private String database;
    
    /**
       * Get the value of database.
       * @return Value of database.
       */
    public String getDatabase() {return database;}
    
    /**
       * Set the value of database.
       * @param v  Value to assign to database.
       */
    public void setDatabase(String  v) {this.database = v;}
    

    public TableColumns(String host, String user, String password, String database, String table) {

	setHost(host);
	setUser(user);
	setPassword(password);
	setDatabase(database);
	setTable(table);

	allCols = new Vector();

	t_connect con = new t_connect(getHost(), getUser(), getPassword(),getDatabase());
       if (con.getError() != null) {
           
       } else {
	   try {
	       DatabaseMetaData md = con.con.getMetaData();
	       ResultSet cols = md.getColumns(null,null,getTable(),"%");
	       int i = 0;
	       while (cols.next()) {
		   Columns col = new Columns(i,cols.getString(4),cols.getString(5),cols.getInt(7),getTable());
		   allCols.addElement(col);
		   i++;
	       }
	   } catch (Exception exception) {
	     System.out.println(exception.getMessage().toString());
	   }
	   con.close();
       }
    }
}
