package mysqladmin;


/** 
    sqlTable is the Grid you often meet in Admin, it was in fact the
    first stuff I wrote to learn more about meta-data.


    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.1.1
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.border.BevelBorder;
import javax.swing.JLabel;
import javax.swing.JPanel; 
import javax.swing.JFrame;
//import javax.swing.SwingUtilities;

import javax.swing.event.*;
//import java.awt.print.*;
import java.util.*;
import java.awt.Dimension;


public class sqlTable extends JInternalFrame implements WindowListener, ActionListener, ListSelectionListener {

private String host, user, password, query;
public JTable tableView;
public JScrollPane scrollpane;

public sqlTable (String host, String user, String password,String db, String query) {
  
 this.host = host;
 this.user = user;
 this.password = password;
 this.query = query;
 

 this.setClosable(true);
 this.setIconifiable(true);
 this.setResizable(true);
 this.setMaximizable(true);

 JDBCAdapter dt = new JDBCAdapter(host, user,password,db);
 dt.executeQuery(query);
 tableView = new JTable(dt);
 tableView.getSelectionModel().addListSelectionListener(this);
 tableView.getTableHeader().setReorderingAllowed(false);
 tableView.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
 scrollpane = new JScrollPane();
 scrollpane.getViewport().add(tableView);
  
  JPanel panel = new JPanel();
  BorderLayout layout = new BorderLayout();
  panel.setLayout(layout); 
  panel.add("Center",scrollpane);


  RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
  /**
  JPanel printPanel = new JPanel();
  printPanel.setLayout(new FlowLayout());
  JButton printButton = new JButton("Print");
  printButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

          PrinterJob pj=PrinterJob.getPrinterJob();
          pj.setPrintable(sqlTable.this);
          pj.printDialog();
          try{ 
            pj.print();
          }catch (Exception PrintException ) {System.out.println("PrintException: " +PrintException); }
	  }});
  
  printPanel.add(printButton);
  panel.add("South",printPanel);
  **/

  BorderLayout layout1 = new BorderLayout();
  this.getContentPane().setLayout(layout1);   
  this.getContentPane().add("Center",panel);

  // this.pack();
  //this.show();
 
}





  // this handles Window-Events
  public void windowClosing(WindowEvent evt) {
     this.dispose();
  }  
  public void windowActivated(WindowEvent evt) {;}  
  public void windowDeactivated(WindowEvent evt) {;}  
  public void windowIconified(WindowEvent evt) {;}  
  public void windowDeiconified(WindowEvent evt) {;}  
  public void windowOpened(WindowEvent evt) {;}  
  public void windowClosed(WindowEvent evt) {;}  
     
 

  //Handling List Events
  public void valueChanged(ListSelectionEvent e) {;}

  // handling AWT-Events
  public void actionPerformed(ActionEvent evt) {;}

  
  public static  void main(String args[]) {
    if (args.length != 5 ) {
     System.out.println("Syntax: java sqlTable host user password database query");
     }
  else {
    sqlTable f = new sqlTable(args[0], args[1], args[2], args[3], args[4]);
 
  }
}
}
