#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <mysql.h>
#include <qmainwindow.h>
#include <qtoolbar.h>
#include <qcombobox.h>
#include <qpopupmenu.h>
#include <qtabwidget.h>
#include <qsplitter.h>
#include <qtoolbutton.h>
#include <qapplication.h>
#include <qworkspace.h>

#include "treelistview.h"
#include "connect.h"
#include "mainwindowlog.h"
#include "popupcombobox.h"

class MainWindow: public QMainWindow
{
Q_OBJECT

public:
	MainWindow(QApplication *);
	~MainWindow();

private slots:
	void slot_connect();
	void slot_disconnect();
	void slot_exit();
	void slot_hide_toolbar();
	void slot_hide_statusbar();
	void slot_close_window();
	void slot_close_windows();
	void slot_windows();
	void slot_motif();
	void slot_motif_plus();
	void slot_cde();
	void slot_platinum();
	void slot_sgi();
	void slot_schema();
	void slot_user(int);
	void slot_table();
	void slot_query_window();
	void slot_process();
	void slot_xport();
	void slot_log();
	void slot_status();
	void slot_variable();
	void slot_password();
	void slot_ping();
	void slot_flush();
	void slot_flush_hosts();
	void slot_flush_logs();
	void slot_flush_privilages();
	void slot_flush_status();
	void slot_flush_tables();
	void slot_flush_threads();
	void slot_script_run();
	void slot_script_edit();
	void slot_terminal();
	void slot_history();
	void about();
	void aboutQt();
	void slot_log(bool, const QString &);
	void slot_error_log();
	void slot_error_log(const QString &, const QString &);
	void slot_fire();
	void slot_close();
	void slot_query();
	void slot_create_database(int);
	void slot_delete_database(int);
	void slot_create_table(int);
	void slot_delete_table(int);
	void slot_delete_field(int);
	void slot_delete_primary(int);
	void slot_delete_index(int);
	void slot_delete_unique(int);
	void slot_create_primary(int);
	void slot_create_unique(int);
	void slot_create_index(int);
	void slot_create_field(int);
	void slot_change_field(int);
	void slot_highlight(int);
	void slot_tree_clicked(QListViewItem *, const QPoint &, int);
	void slot_see_table(int);
	void slot_see_keys(int);
	void slot_see_fields(int);
	void slot_see_status(int);
	void slot_query(const QString &, const QString &);
	void slot_query(const QString &, const QString &, const QString &);
	void slot_tree();		// tree refresh slot	
	void slot_schema_refresh(int);

protected:
	virtual void closeEvent(QCloseEvent *);
	virtual void keyPressEvent(QKeyEvent *);
	
private:
	bool set_database();
	int get_level(QListViewItem *);
	void make_layout();
	void make_central_widget();
	void make_toolbar();
	void make_menubar();
	void make_statusbar();
	void set_base_color(QWidget *,QColor);
	void set_background_color(QWidget *,QColor);
	void signal_connect();
	void load_session();
	void save_session();
	void enable_menu();
	void disable_menu();
	void load_history();
	void save_history(const QString &);
	void clear_history();
	void load_server_list(Connect *);

private:
	bool flag;
	struct _log log;
	QToolBar *toolbar;
	QComboBox *database;
	PopupComboBox *query;
	QApplication *application;
	QWorkspace *work_space;
	MYSQL mysql;
	MYSQL_RES *result;
	MYSQL_ROW row; 
	MYSQL_FIELD *field;
	QString host;
	QString user;
	QLabel *status;
	Connect *dialog;
	QListViewItem *_si; // for internal use for delete table...

signals:
	void signal_tree();		// tree refresh signal
};

#endif 
