#include <qvbox.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qstatusbar.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "tree.h"
#include "resource.h"

MainWindow::MainWindow(QApplication *l) :
QMainWindow(0,QString::fromLocal8Bit("MySQL Navigator"),WDestructiveClose)
{
	application = l;	

	make_layout();

	signal_connect();

	flag = FALSE;

	mysql_init(&mysql);

	dialog = NULL;

	load_session();

	disable_menu();
}

MainWindow::~MainWindow()
{
}	

void MainWindow::set_base_color(QWidget *widget,QColor color)
{
	QPalette l(widget->palette());

	l.setColor(QColorGroup::Base,color);

	widget->setPalette(l);	
}

void MainWindow::set_background_color(QWidget *widget,QColor color)
{
	QPalette l(widget->palette());

	l.setColor(QColorGroup::Background,color);

	widget->setPalette(l);	
}

bool MainWindow::set_database()
{
	database->clear();

	result = mysql_list_dbs(&mysql, NULL);

	if(result == NULL)
	{
		return FALSE;
	}

	while((row = mysql_fetch_row(result)))
	{
		database->insertItem(row[0]);
	}

	mysql_free_result(result);

	return TRUE;
}

int MainWindow::get_level(QListViewItem *si)
{
	int level = 0;

	if(si->parent())
	{
		level++;
	}
	else
	{
		return level;
	}
	
	if(si->parent()->parent())
	{
		level++;
	}
	else
	{
		return level;
	}
	
	if(si->parent()->parent()->parent())
	{
		level++;
	}
	else
	{
		return level;
	}

	if(si->parent()->parent()->parent()->parent())
	{
		level++;
	}
	else
	{
		return level;
	}

	return -1;
}
