#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#include "process.h"

void Process::slot_kill(QListViewItem *process)
{
	if(process == NULL)
	{
		return;
	}
		
	QPopupMenu *l = new QPopupMenu(this);

	l->insertItem(tr("&Kill"), this, SLOT(slot_kill(int)), 0, (int)process);
	l->insertItem(tr("&Refresh"), this, SLOT(slot_refresh(int)), 0, (int)process);

	l->popup(QCursor::pos());
}

void Process::slot_close()
{
	parentWidget()->close();
}

void Process::slot_kill(int process)
{
	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to kill process ") + ((QListViewItem *)process)->text(0) + "?", tr("Yes"), tr("No"));

    if(l == 0)
    {
		if(mysql_kill(mysql,((QListViewItem *)process)->text(0).toInt()))
		{
			emit signal_error_log();
			QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
			return; 	 
		}
		else
		{
			this->process->clear();
			show_process();
		}
	}
	else
	{
	}
}

void Process::slot_refresh(int)
{
	this->process->clear();
	show_process();
}

void Process::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a process window."));
}

void Process::slot_kill()
{
	if(process->selectedItem() == NULL)
	{
		return;
	}

	slot_kill((int)(process->selectedItem()));
}

void Process::slot_refresh()
{
	slot_refresh(0);
}
