#include "xport.h"
#include <qfiledialog.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qmessagebox.h>

void Xport::slot_close()
{
	parentWidget()->close();
}

void Xport::slot_export()
{
	QString si = QFileDialog::getOpenFileName(QString::null, "*.*", this);

	if(!si.isEmpty())
	{
		export_file->setText(si);
	}
}

void Xport::slot_import()
{
	QString si = QFileDialog::getOpenFileName(QString::null, "*.*", this);

	if(!si.isEmpty())
	{
		import_file->setText(si);
	}
}

void Xport::slot_list_export_table(int si)
{
	MYSQL_RES *result;

    MYSQL_ROW row;

	export_table->clear();

	mysql_select_db(mysql, export_database->text(si).latin1());

	result = mysql_list_tables(mysql, NULL);

	if(result == NULL)
	{
		return;
	}

    export_table->insertItem("all");
	
	while((row = mysql_fetch_row(result)))
    {
        export_table->insertItem(row[0]);
	}

	mysql_free_result(result);
}

void Xport::slot_fire()
{
	if(import->isOn())
	{
		if(import_file->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter import file."));
			return;
		}
		xport_import();
	}
	else if(export_->isOn())
	{
		if(export_file->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter export file."));
			return;
		}
		xport_export();
	}
}
