import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class LoginDialog extends Dialog
{
    private TextField userWidget;
    private TextField passwordWidget;
    private TextField hostWidget;
    private TextField useWidget;
    private Button okButton;
    private Button resetButton;
    private Button exitButton;

    private String host = "";
    private String user = "";
    private String password = "";
    private String use = "";

    private static Vector userList = new Vector();
    private static Vector hostList = new Vector();
    private static Vector useList = new Vector();

    private int userIndex = userList.size();
    private int hostIndex = hostList.size();
    private int useIndex = useList.size();

    private SpecialKeyListener spKeyListener = new SpecialKeyListener();

    public LoginDialog (Frame parent, String text, boolean exit_button)
    {
	super (parent, "Login", true);

	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc = new GridBagConstraints();

	setLayout (gbl);

	int index = 0;
	if (text.length() != 0)
	    {
		Panel panel0 = new Panel();
		panel0.setLayout (gbl);

		addToContainer (panel0,
				gbl,
				gbc,
				new Label (text),
				0,
				0,
				1,
				1,
				GridBagConstraints.NONE,
				GridBagConstraints.NORTHWEST,
				0, 0);

		addToContainer (this,
				gbl,
				gbc,
				panel0,
				0,
				index++,
				1,
				1,
				GridBagConstraints.NONE,
				GridBagConstraints.NORTHWEST,
				0, 0);
	    }

	Panel panel1 = new Panel();
	panel1.setLayout (gbl);

	addToContainer (panel1,
			gbl,
			gbc,
			new Label ("User"),
			0,
			0,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);

	userWidget = new TextField (15);
	addToContainer (panel1,
			gbl,
			gbc,
			userWidget,
			1,
			0,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);
	userWidget.addKeyListener (spKeyListener);

	addToContainer (panel1,
			gbl,
			gbc,
			new Label ("Password"),
			0,
			1,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);

	passwordWidget = new TextField (15);
	passwordWidget.setEchoChar ('*');
	addToContainer (panel1,
			gbl,
			gbc,
			passwordWidget,
			1,
			1,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0,
			new Insets (5, 5, 0, 5));
	passwordWidget.addKeyListener (spKeyListener);

	addToContainer (panel1,
			gbl,
			gbc,
			new Label ("Host"),
			0,
			2,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);

	hostWidget = new TextField (15);
	addToContainer (panel1,
			gbl,
			gbc,
			hostWidget,
			1,
			2,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);
	hostWidget.addKeyListener (spKeyListener);

	addToContainer (panel1,
			gbl,
			gbc,
			new Label ("Use"),
			0,
			3,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);

	useWidget = new TextField (15);
	addToContainer (panel1,
			gbl,
			gbc,
			useWidget,
			1,
			3,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);
	useWidget.addKeyListener (spKeyListener);


	// add panel1 to the dialog box
	addToContainer (this,
			gbl,
			gbc,
			panel1,
			0,
			index++,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);

	Panel panel2 = new Panel();
	panel2.setLayout (gbl);
	
	okButton = new Button (" OK ");
	okButton.addActionListener (new OkListener());
	addToContainer (panel2,
			gbl,
			gbc,
			okButton,
			0,
			0,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.CENTER,
			0, 0);	
	okButton.addKeyListener (spKeyListener);

	resetButton = new Button (" Reset ");
	resetButton.addActionListener (new ResetListener());
	addToContainer (panel2,
			gbl,
			gbc,
			resetButton,
			1,
			0,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.CENTER,
			0, 0,
			new Insets (0, 10, 0, 0));

	if (exit_button == true)
	    {
		exitButton = new Button (" Exit ");
		exitButton.addActionListener (new ExitListener());
		addToContainer (panel2,
				gbl,
				gbc,
				exitButton,
				2,
				0,
				1,
				1,
				GridBagConstraints.NONE,
				GridBagConstraints.CENTER,
				0, 0,
				new Insets (0, 10, 0, 0));
	    }

	// add panel2 to the dialog box
	addToContainer (this,
			gbl,
			gbc,
			panel2,
			0,
			index++,
			1,
			1,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.NORTHWEST,
			0, 0,
			new Insets (5, 0, 5, 0));
	pack();
	Rectangle pbounds = parent.getBounds();
	Point mid = new Point (pbounds.x + (pbounds.width/2), pbounds.y + (pbounds.height/2));
	Rectangle bounds = getBounds();	
	int x = mid.x - (bounds.width/2);
	int y = mid.y - (bounds.height/2);	
	if (x < 0) x = pbounds.x;
	if (y < 0) y = pbounds.y;
	setBounds (x, y, bounds.width, bounds.height);

	show();
    }

    public LoginDialog (Frame parent)
    {
	this (parent, "", true);
    }

    public String getUser ()
    {
	return new String (user);
    }

    public String getPassword ()
    {
	return new String (password);
    }

    public String getHost ()
    {
	return new String (host);
    }

    public String getDb ()
    {
	return new String (use);
    }

    private void addToContainer (Container cont,
				 GridBagLayout gbl,
				 GridBagConstraints gbc,
				 Component comp,
				 int gridx,
				 int gridy,
				 int gridwidth,
				 int gridheight,
				 int fill,
				 int anchor,
				 int weightx,
				 int weighty,
				 Insets insets)
    {
	gbc.gridx = gridx;
	gbc.gridy = gridy;
	gbc.gridwidth = gridwidth;
	gbc.gridheight = gridheight;
	gbc.fill = fill;
	gbc.anchor = anchor;
	gbc.weightx = weightx;
	gbc.weighty = weighty;
	
	if (insets != null)
	    {
		gbc.insets = insets;
	    }
	
	gbl.setConstraints (comp, gbc);
	cont.add (comp);
    }

    private void addToContainer (Container cont,
				 GridBagLayout gbl,
				 GridBagConstraints gbc,
				 Component comp,
				 int gridx,
				 int gridy,
				 int gridwidth,
				 int gridheight,
				 int fill,
				 int anchor,
				 int weightx,
				 int weighty)
    {
	addToContainer (cont, gbl, gbc, comp, gridx, gridy, gridwidth, gridheight,
			fill, anchor, weightx, weighty, null);
    }

    private void reset ()
    {
	userWidget.setText ("");
	passwordWidget.setText ("");
	hostWidget.setText("");
	useWidget.setText("");
    }

    private void readFromWidgetsAndClose ()
    {
	user = userWidget.getText().trim();
	if ((user.length() > 0) && (userList.contains (user) == false))
	    {
		userList.addElement (user);
	    }

	password = passwordWidget.getText().trim();

	host = hostWidget.getText().trim();
	if ((host.length() > 0) && (hostList.contains (host) == false))
	    {
		hostList.addElement (host);
	    }

	use = useWidget.getText().trim();
	if ((use.length() > 0) && (useList.contains (use) == false))
	    {
		useList.addElement (use);
	    }

	// close
	dispose();
    }

    class SpecialKeyListener extends KeyAdapter
    {
	public void keyPressed (KeyEvent e)
	{
	    int key = e.getKeyCode();
	    Component parent = e.getComponent();

	    if (key == KeyEvent.VK_ENTER)
		{
		    if (parent == userWidget)
			{
			    passwordWidget.requestFocus();
			}
		    else if (parent == passwordWidget)
			{
			    hostWidget.requestFocus();
			}	
		    else if (parent == hostWidget)
			{
			    useWidget.requestFocus();
			}
		    else if (parent == useWidget)
			{
			    okButton.requestFocus();
			}
		    else if (parent == okButton)
			{
			    readFromWidgetsAndClose();
			}
    		}
	    else if (key == KeyEvent.VK_UP)
		{
		    if (parent == userWidget)
			{
			    userIndex--;

			    if (userIndex < 0)
				{
				    userIndex = 0;
				}

			    if (userList.size() > 0)
				{
				    userWidget.setText ((String)userList.elementAt(userIndex));
				}
			    else
				{
				    userWidget.setText ("");
				}

			}
		    else if (parent == hostWidget)
			{
			    hostIndex--;

			    if (hostIndex < 0)
				{
				    hostIndex = 0;
				}

			    if (hostList.size() > 0)
				{
				    hostWidget.setText ((String)hostList.elementAt(hostIndex));
				}
			    else
				{
				    hostWidget.setText ("");
				}

			}
		    else if (parent == useWidget)
			{
			    useIndex--;

			    if (useIndex < 0)
				{
				    useIndex = 0;
				}

			    if (useList.size() > 0)
				{
				    useWidget.setText ((String)useList.elementAt(useIndex));
				}
			    else
				{
				    useWidget.setText ("");
				}
			}
		}
	    else if (key == KeyEvent.VK_DOWN)
		{
		    if (parent == userWidget)
			{
			    userIndex++;

			    if (userIndex >= userList.size())
				{
				    userIndex = userList.size();
				    userWidget.setText ("");
				}
			    else
				{
				    if (userList.size() > 0)
					{
					    userWidget.setText ((String)userList.elementAt (userIndex));
					}
				    else
					{
					    userWidget.setText ("");
					}
				}
			}
		    else if (parent == hostWidget)
			{
			    hostIndex++;

			    if (hostIndex >= hostList.size())
				{
				    hostIndex = hostList.size();
				    hostWidget.setText ("");
				}
			    else
				{
				    if (hostList.size() > 0)
					{
					    hostWidget.setText ((String)hostList.elementAt (hostIndex));
					}
				    else
					{
					    hostWidget.setText ("");
					}
				}
			}
		    else if (parent == useWidget)
			{
			    useIndex++;

			    if (useIndex >= useList.size())
				{
				    useIndex = useList.size();
				    useWidget.setText ("");
				}
			    else
				{
				    if (useList.size() > 0)
					{
					    useWidget.setText ((String)useList.elementAt (useIndex));
					}
				    else
					{
					    useWidget.setText ("");
					}
				}
			}
		}
	}
    };

    class ResetListener implements ActionListener
    {
	public void actionPerformed (ActionEvent e)
	{
	    reset();
	}
    };

    class ExitListener implements ActionListener
    {
	public void actionPerformed (ActionEvent e)
	{
	    System.exit (0);
	}
    };

    class OkListener implements ActionListener
    {
	public void actionPerformed (ActionEvent e)
	{
	    readFromWidgetsAndClose();
	}
    };

    // Test program
    public static void main (String args[])
    {
	Frame frame = new Frame ("Test Frame");
	frame.setBounds ( 10, 100, 600, 400);
	frame.show();

	LoginDialog ld = new LoginDialog (frame);
	System.out.println ("User : " + ld.getUser());
	System.out.println ("Password : " + ld.getPassword());
	System.out.println ("Host : " + ld.getHost());
	System.out.println ("Use : " + ld.getDb());
	System.exit (0);
    }
}







