#!/bin/sh
# Access the "origins" table in the wines database. Not much more than
# tablescreen, just add a list window

# The following nonsense is required because mysqlwish dumps core when 
# SQLDBTYPE is ODBC, reason unknown.
# The following lines are executed by sh, not by wish because of the
# backslashes... Puke loudly
#\
case "A$SQLDBTYPE" in 
#\
  A|AMYSQL) exec /usr/local/bin/mysqlwish "$0" "$@";;
#\
*) exec wish "$0" "$@";; 
#\
esac

package require sqlsc

set username ""
set hostname ""
set password ""
catch {set username $env(SQLSCUSER)}
catch {set hostname $env(SQLSCHOST)}
catch {set password $env(SQLSCPASSWORD)}

set dbname "wines"
catch {unset env(CDKITDB)}

frame .f1 
button .f1.exit -text "Exit" -command "exit 0"
pack .f1.exit -side left -expand 1 -fill both
pack .f1 -side top -fill both

frame .f2 
pack .f2 -side top -fill both -expand 1
set origins(database) $dbname
set origins(table) origins
set origins(sqlschost) $hostname
set origins(sqlscuser) $username
set origins(sqlscpasswd) $password
set origins(window) .f2.origins
set origins(ordercols) {origin}
set origins(autopercentboth) {origin}
set origins(allowdelete) ""
toplevel .org
set origins(list_columns) {origid origin}
set origins(list_window) .org.orglist

sqlscreen origins

