/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// IndexNode.h: interface for the IndexNode class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INDEXNODE_H__F25B47A4_C0C8_11D4_98FC_0000C01D2301__INCLUDED_)
#define AFX_INDEXNODE_H__F25B47A4_C0C8_11D4_98FC_0000C01D2301__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <memory.h>
#include "Btn.h"

#define SHIFT(n)	(1 << n)

#define RECORD_NUMBER_LENGTH(recordNumber) ((recordNumber < 0) ? 1 :	\
			(recordNumber < SHIFT(6)) ? 1 :		\
			(recordNumber < SHIFT(13)) ? 2 :	\
			(recordNumber < SHIFT(20)) ? 3 :	\
			(recordNumber < SHIFT(27)) ? 4 : 5)
			
class IndexPage;

class IndexNode
{
public:
	inline void expandKey (IndexKey *indexKey);
	IndexNode();
	IndexNode(IndexPage *page);
	IndexNode (Btn *node);

	//void	setNumber (int32 number);
	Btn*	insert (Btn *where, int offst, int len, UCHAR *fullKey, int32 nmbr);
	void	printKey(char * msg, UCHAR * key, bool inversion);
	int		expandKey (UCHAR *keyPtr);
	Btn*	getNext();
	int32	getNumber();
	Btn*	parseNode (Btn *indexNode);

	inline int keyLength()
		{
		return offset + length;
		}

	inline static int nodeLength (int offset, int length, int32 number)
		{
		return ((offset >= 128) ? 2 : 1) + ((length >= 128) ? 2 : 1) + length + RECORD_NUMBER_LENGTH(number);
		}
	
	inline int getNumberLength()
		{
		//return sizeof(int32);
		return key[length -1 ] & 0x0f;
		}
		
	Btn		*node;
	Btn		*nextNode;
	uint	offset;
	uint	length;
	UCHAR	*key;
	int32	number;
};

inline Btn* IndexNode::parseNode(Btn *indexNode)
{
	node = indexNode;
	key = (UCHAR*) indexNode;
	
	if ( (offset = *key++) >= 128)
		offset = ((offset & 0x7f) << 8) | *key++;
	
	if ( (length = *key++) >= 128)
		length = ((length & 0x7f) << 8) | *key++;
	
	number = 0;
	
	if ((*key & 0xC0) == 0xC0)
		number = -(*key++ & 0x2f);
	else	
		for (;;)
			{
			UCHAR c = *key++;
			number = (number << 7) | (c & 0x7F);
			
			if (c & 0x80)
				break;
			}
			
	nextNode = (Btn*) (key + length);

	return nextNode;
}

inline int32 IndexNode::getNumber()
{
	return number;
}

inline Btn* IndexNode::getNext()
{
	return parseNode (nextNode);
}

inline int IndexNode::expandKey(UCHAR *keyPtr)
{
	ASSERT (offset + length <= MAX_INDEX_KEY_RUN_LENGTH);

	if (length)
		memcpy (keyPtr + offset, key, length);

	return offset + length;
}


inline void IndexNode::expandKey(IndexKey *indexKey)
{
	ASSERT (offset + length <= MAX_INDEX_KEY_RUN_LENGTH);

	if (length)
		memcpy (indexKey->key + offset, key, length);

	indexKey->keyLength = offset + length;
}

#endif // !defined(AFX_INDEXNODE_H__F25B47A4_C0C8_11D4_98FC_0000C01D2301__INCLUDED_)
