/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "Engine.h"
#include "MySQLCollation.h"
#include "IndexKey.h"
#include "Value.h"

MySQLCollation::MySQLCollation(JString collationName, void *arg)
{
	name = collationName;
	charset = arg;
	padChar = (char) falcon_pad_char(charset);
}

MySQLCollation::~MySQLCollation(void)
{
}

int MySQLCollation::compare (Value *value1, Value *value2)
{
	return falcon_strnncoll(charset,
							(const UCHAR*) value1->data.string.string, value1->data.string.length, 
							(const UCHAR*) value2->data.string.string, value2->data.string.length, 
							false);
}

int MySQLCollation::makeKey (Value *value, IndexKey *key, int partialKey)
{
	ASSERT(partialKey <= MAX_INDEX_KEY_LENGTH);
	char temp[MAX_INDEX_KEY_LENGTH];
	int srcLen;

	if (partialKey)
		{
		srcLen = value->getTruncatedString(partialKey, temp);
		srcLen = falcon_strntrunc(charset, partialKey, (unsigned char *) temp, srcLen);
		}
	else
		srcLen = value->getString (sizeof(temp), temp);

	if (name != "BINARY")
		srcLen = computeKeyLength(srcLen, temp);

	// Since some collations make dstLen > srcLen, be sure dstLen is < partialKey.

	int dstLen = falcon_strnxfrmlen(charset, (UCHAR*) temp, srcLen, partialKey, MAX_INDEX_KEY_LENGTH);
	int len = falcon_strnxfrm(charset, key->key, dstLen, (UCHAR*) temp, srcLen);
	key->keyLength = len;
	
	return len;
}

const char *MySQLCollation::getName ()
{
	return name;
}

bool MySQLCollation::starting (const char *string1, const char *string2)
{
	NOT_YET_IMPLEMENTED;
	return false;
}

bool MySQLCollation::like (const char *string, const char *pattern)
{
	NOT_YET_IMPLEMENTED;
	return false;
}

char MySQLCollation::getPadChar(void)
{
	return padChar;
}
