/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// RecordVersion.h: interface for the RecordVersion class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RECORDVERSION_H__84FD1965_A97F_11D2_AB5C_0000C01D2301__INCLUDED_)
#define AFX_RECORDVERSION_H__84FD1965_A97F_11D2_AB5C_0000C01D2301__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Record.h"

class Transaction;

class RecordVersion : public Record  
{
public:
	RecordVersion(Table *tbl, Format *fmt, Transaction *tran, Record *oldVersion);

	virtual bool		isSuperceded();
	virtual Transaction* getTransaction();
	virtual TransId		getTransactionId();
	virtual int			getSavePointId();
	virtual void		setSuperceded (bool flag);
	virtual Record*		getPriorVersion();
	virtual bool		scavenge(TransId oldestActive);
	virtual void		scavenge(TransId targetTransactionId, int oldestActiveSavePoint);
	virtual bool		isVersion();
	virtual Record*		rollback();
	virtual Record*		fetchVersion (Transaction *transaction);
	virtual Record*		releaseNonRecursive();
	virtual void		setPriorVersion (Record *oldVersion);

	void				commit();


protected:
	virtual ~RecordVersion();

public:
	Transaction		*transaction;
	TransId			transactionId;
	int				savePointId;
	Record			*priorVersion;
	RecordVersion	*next;
	bool			superceded;
};

#endif // !defined(AFX_RECORDVERSION_H__84FD1965_A97F_11D2_AB5C_0000C01D2301__INCLUDED_)
