// SRLIndexPage.cpp: implementation of the SRLIndexPage class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "Engine.h"
#include "SRLIndexPage.h"
#include "SerialLogControl.h"
#include "SerialLogTransaction.h"
#include "Dbb.h"
#include "IndexRootPage.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SRLIndexPage::SRLIndexPage()
{

}

SRLIndexPage::~SRLIndexPage()
{

}

void SRLIndexPage::append(TransId transId, int32 page, int32 lvl, int32 up, int32 left, int32 right, int length, const UCHAR *data)
{
	START_RECORD(srlIndexPage, "SRLIndexPage::append");
	
	if (transId)
		{
		SerialLogTransaction *trans = log->getTransaction(transId);

		if (trans)
			trans->setPhysicalBlock();
		}
		
	putInt(page);
	putInt(lvl);
	putInt(up);
	putInt(left);
	putInt(right);
	putInt(length);
	putData(length, data);
}

void SRLIndexPage::read()
{
	pageNumber = getInt();
	level = getInt();
	parent = getInt();
	prior = getInt();
	next = getInt();
	length = getInt();
	data = getData(length);

	if (log->tracePage && (log->tracePage == pageNumber ||
						   log->tracePage == prior ||
						   log->tracePage == next))
		print();
}

void SRLIndexPage::pass1()
{
	log->bumpPageIncarnation(pageNumber, objInUse);
}

void SRLIndexPage::pass2()
{
	if (log->bumpPageIncarnation(pageNumber, objInUse))
		{
		if (log->tracePage == pageNumber)
			print();

		IndexRootPage::redoIndexPage(log->dbb, pageNumber, parent, level, prior, next, length, data);
		}
}

void SRLIndexPage::print()
{
	logPrint("Index page %d level %d parent %d, prior %d next %d\n", pageNumber, level, parent, prior, next);
}

void SRLIndexPage::redo()
{
	log->bumpPageIncarnation(pageNumber, objInUse);
}
