/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include <stdio.h>
#include "Engine.h"
#include "SRLSectionPromotion.h"
#include "SerialLog.h"
#include "Section.h"
#include "Dbb.h"


SRLSectionPromotion::SRLSectionPromotion(void)
{
}

SRLSectionPromotion::~SRLSectionPromotion(void)
{
}


void SRLSectionPromotion::append(int id, int32 rootPage, int pageLength, const UCHAR* pageData, int32 page)
{
	START_RECORD(srlSectionPromotion, "SRLSectionPromotion::append");
	putInt(id);
	putInt(rootPage);
	putInt(page);
	putInt(pageLength);
	putData(pageLength, pageData);
	sync.unlock();
}

void SRLSectionPromotion::read(void)
{
	sectionId = getInt();
	rootPageNumber = getInt();
	pageNumber = getInt();
	length = getInt();
	data = getData(length);
	
	if (log->tracePage == pageNumber ||
		(log->tracePage && log->tracePage == rootPageNumber))
		print();
}

void SRLSectionPromotion::pass1(void)
{
	log->bumpPageIncarnation(pageNumber, objInUse);
}

void SRLSectionPromotion::pass2(void)
{
	log->bumpPageIncarnation(pageNumber, objInUse);
}

void SRLSectionPromotion::redo(void)
{
	if (!log->bumpPageIncarnation(pageNumber, objInUse))
		return;

	Section::redoSectionPromotion(log->dbb, sectionId, rootPageNumber, length, data, pageNumber);
}

void SRLSectionPromotion::print(void)
{
	logPrint("Section Promotion: section %d, pageNumber, root page %d\n",
			sectionId, pageNumber, rootPageNumber);
}
