/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _TRANSACTION_MANAGER_H_
#define _TRANSACTION_MANAGER_H_

#include "SyncObject.h"
#include "Queue.h"

class Transaction;
class Database;
class Connection;
class Table;

class TransactionManager
{
public:
	TransactionManager(Database *database);
	~TransactionManager(void);
	
	TransId			findOldestActive();
	Transaction*	startTransaction(Connection* connection);
	void			dropTable(Table* table, Transaction* transaction);
	bool			hasUncommittedRecords(Table* table, Transaction* transaction);
	void			scavengeRecords(int threshold);
	
	TransId			transactionSequence;
	Database		*database;
	SyncObject		syncObject;
	Queue<Transaction>	activeTransactions;
	Queue<Transaction>	committedTransactions;
	void commitByXid(int xidLength, const UCHAR* xid);
	void rollbackByXid(int xidLength, const UCHAR* xid);
};

#endif
