/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.ParameterImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.PropertyImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetweenPredicateImpl
extends PredicateImpl {
    protected ParameterImpl lower;
    protected ParameterImpl upper;
    protected PropertyImpl property;

    public BetweenPredicateImpl(QueryDomainTypeImpl<?> dobj, PropertyImpl property, ParameterImpl lower, ParameterImpl upper) {
        super(dobj);
        this.lower = lower;
        this.upper = upper;
        this.property = property;
        lower.setProperty(property);
        upper.setProperty(property);
    }

    @Override
    public void markParameters() {
        this.lower.mark();
        this.upper.mark();
    }

    @Override
    public void unmarkParameters() {
        this.lower.unmark();
        this.upper.unmark();
    }

    @Override
    public void markBoundsForCandidateIndices(QueryExecutionContext context, CandidateIndexImpl[] candidateIndices) {
        if (this.lower.getParameterValue(context) == null || this.upper.getParameterValue(context) == null) {
            return;
        }
        this.property.markLowerBound(candidateIndices, this, false);
        this.property.markUpperBound(candidateIndices, this, false);
    }

    @Override
    public void markBoundsForCandidateIndices(CandidateIndexImpl[] candidateIndices) {
        this.property.markLowerBound(candidateIndices, this, false);
        this.property.markUpperBound(candidateIndices, this, false);
    }

    @Override
    public int operationSetBounds(QueryExecutionContext context, IndexScanOperation op, boolean lastColumn) {
        int result = NO_BOUND_SET;
        Object lowerValue = this.lower.getParameterValue(context);
        Object upperValue = this.upper.getParameterValue(context);
        if (lowerValue != null) {
            this.property.operationSetBounds(lowerValue, IndexScanOperation.BoundType.BoundLE, op);
            result |= LOWER_BOUND_SET;
        }
        if (upperValue != null) {
            this.property.operationSetBounds(upperValue, IndexScanOperation.BoundType.BoundGE, op);
            result |= UPPER_BOUND_SET;
        }
        return result;
    }

    @Override
    public int operationSetUpperBound(QueryExecutionContext context, IndexScanOperation op, boolean lastColumn) {
        Object upperValue = this.upper.getParameterValue(context);
        if (upperValue != null) {
            this.property.operationSetBounds(upperValue, IndexScanOperation.BoundType.BoundGE, op);
            return UPPER_BOUND_SET;
        }
        return NO_BOUND_SET;
    }

    @Override
    public int operationSetLowerBound(QueryExecutionContext context, IndexScanOperation op, boolean lastColumn) {
        Object lowerValue = this.lower.getParameterValue(context);
        if (lowerValue != null) {
            this.property.operationSetBounds(lowerValue, IndexScanOperation.BoundType.BoundLE, op);
            return LOWER_BOUND_SET;
        }
        return NO_BOUND_SET;
    }

    @Override
    public void filterCmpValue(QueryExecutionContext context, ScanOperation op) {
        try {
            ScanFilter filter = op.getScanFilter(context);
            filter.begin();
            this.filterCmpValue(context, op, filter);
            filter.end();
        }
        catch (Exception ex) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), ex);
        }
    }

    @Override
    public void filterCmpValue(QueryExecutionContext context, ScanOperation op, ScanFilter filter) {
        this.property.filterCmpValue(this.lower.getParameterValue(context), ScanFilter.BinaryCondition.COND_GE, filter);
        this.property.filterCmpValue(this.upper.getParameterValue(context), ScanFilter.BinaryCondition.COND_LE, filter);
    }

    @Override
    public boolean isUsable(QueryExecutionContext context) {
        return this.lower.getParameterValue(context) != null && this.upper.getParameterValue(context) != null;
    }

    @Override
    protected PropertyImpl getProperty() {
        return this.property;
    }
}

