/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.Constants;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.core.SessionFactoryImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandlerFactory;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfiguration;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainTypeHandlerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.lib.conf.BooleanValue;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.IntValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NdbOpenJPAConfigurationImpl
extends JDBCConfigurationImpl
implements NdbOpenJPAConfiguration,
Constants,
DomainTypeHandlerFactory {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPAConfigurationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAConfigurationImpl.class);
    public StringValue connectString;
    public IntValue connectRetries;
    public IntValue connectDelay;
    public IntValue connectVerbose;
    public IntValue connectTimeoutBefore;
    public IntValue connectTimeoutAfter;
    public StringValue username;
    public StringValue password;
    public StringValue database;
    public IntValue maxTransactions;
    public BooleanValue failOnJDBCPath;
    public SessionFactoryImpl sessionFactory;
    private final Map<Class<?>, NdbOpenJPADomainTypeHandlerImpl<?>> domainTypeHandlerMap = new HashMap();
    private static Method intValueMethod;
    private static Method booleanValueMethod;

    int getIntValue(IntValue value) {
        try {
            return (Integer)intValueMethod.invoke((Object)value, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ClusterJFatalInternalException(e);
        }
        catch (IllegalAccessException e) {
            throw new ClusterJFatalInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClusterJFatalInternalException(e);
        }
    }

    boolean getBooleanValue(BooleanValue value) {
        try {
            return (Boolean)booleanValueMethod.invoke((Object)value, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ClusterJFatalInternalException(e);
        }
        catch (IllegalAccessException e) {
            throw new ClusterJFatalInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClusterJFatalInternalException(e);
        }
    }

    public NdbOpenJPAConfigurationImpl() {
        this(true);
    }

    public NdbOpenJPAConfigurationImpl(boolean loadGlobals) {
        this(true, loadGlobals);
    }

    public NdbOpenJPAConfigurationImpl(boolean derivations, boolean loadGlobals) {
        super(false, false);
        this.connectString = this.addString("ndb.connectString");
        this.connectRetries = this.addInt("ndb.connectRetries");
        this.connectRetries.set(4);
        this.connectDelay = this.addInt("ndb.connectDelay");
        this.connectDelay.set(5);
        this.connectVerbose = this.addInt("ndb.connectVerbose");
        this.connectVerbose.set(0);
        this.connectTimeoutBefore = this.addInt("ndb.connectTimeoutBefore");
        this.connectTimeoutBefore.set(30);
        this.connectTimeoutAfter = this.addInt("ndb.connectTimeoutAfter");
        this.connectTimeoutAfter.set(20);
        this.username = this.addString("ndb.username");
        this.password = this.addString("ndb.password");
        this.database = this.addString("ndb.database");
        this.database.set("test");
        this.maxTransactions = this.addInt("ndb.maxTransactions");
        this.maxTransactions.set(1024);
        this.failOnJDBCPath = this.addBoolean("ndb.failOnJDBCPath");
        this.failOnJDBCPath.set(false);
        this.sessionFactory = null;
        if (derivations) {
            ProductDerivations.beforeConfigurationLoad((Configuration)this);
        }
        if (loadGlobals) {
            this.loadGlobals();
        }
    }

    public NdbOpenJPAConfigurationImpl(NdbOpenJPAConfiguration conf) {
        this(true, false);
        if (conf != null) {
            this.fromProperties(conf.toProperties(false));
        }
    }

    @Override
    public String getConnectString() {
        return this.connectString.get();
    }

    @Override
    public void setConnectString(String value) {
        this.connectString.set(value);
    }

    @Override
    public int getConnectRetries() {
        return this.getIntValue(this.connectRetries);
    }

    @Override
    public void setConnectRetries(int value) {
        this.connectRetries.set(value);
    }

    @Override
    public int getConnectDelay() {
        return this.getIntValue(this.connectDelay);
    }

    @Override
    public void setConnectDelay(int value) {
        this.connectDelay.set(value);
    }

    @Override
    public int getConnectVerbose() {
        return this.getIntValue(this.connectVerbose);
    }

    @Override
    public void setConnectVerbose(int value) {
        this.connectVerbose.set(value);
    }

    @Override
    public int getConnectTimeoutBefore() {
        return this.getIntValue(this.connectTimeoutBefore);
    }

    @Override
    public void setConnectTimeoutBefore(int value) {
        this.connectTimeoutBefore.set(value);
    }

    @Override
    public int getConnectTimeoutAfter() {
        return this.getIntValue(this.connectTimeoutAfter);
    }

    @Override
    public void setConnectTimeoutAfter(int value) {
        this.connectTimeoutAfter.set(value);
    }

    @Override
    public String getUsername() {
        return this.username.getString();
    }

    @Override
    public void setUsername(String value) {
        this.username.setString(value);
    }

    @Override
    public String getPassword() {
        return this.password.getString();
    }

    @Override
    public void setPassword(String value) {
        this.password.setString(value);
    }

    @Override
    public String getDatabase() {
        return this.database.getString();
    }

    @Override
    public void setDatabase(String value) {
        this.database.setString(value);
    }

    @Override
    public int getMaxTransactions() {
        return this.getIntValue(this.maxTransactions);
    }

    @Override
    public void setMaxTransactions(int value) {
        this.maxTransactions.set(value);
    }

    @Override
    public boolean getFailOnJDBCPath() {
        return this.getBooleanValue(this.failOnJDBCPath);
    }

    @Override
    public void setFailOnJDBCPath(boolean value) {
        this.failOnJDBCPath.set(value);
    }

    @Override
    public SessionFactoryImpl getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        return this.sessionFactory;
    }

    @Override
    public void setSessionFactory(SessionFactory value) {
        this.sessionFactory = (SessionFactoryImpl)value;
    }

    public SessionFactoryImpl createSessionFactory() {
        if (this.connectString.get() == null) {
            throw new IllegalStateException(local.message("ERR_Missing_Connect_String"));
        }
        Properties props = new Properties();
        props.put("com.mysql.clusterj.connectstring", this.connectString.get());
        props.put("com.mysql.clusterj.connect.retries", this.connectRetries.getString());
        props.put("com.mysql.clusterj.connect.delay", this.connectDelay.getString());
        props.put("com.mysql.clusterj.connect.verbose", this.connectVerbose.getString());
        props.put("com.mysql.clusterj.connect.timeout.before", this.connectTimeoutBefore.getString());
        props.put("com.mysql.clusterj.connect.timeout.after", this.connectTimeoutAfter.getString());
        props.put("com.mysql.clusterj.database", this.database.getString());
        props.put("com.mysql.clusterj.max.transactions", this.maxTransactions.getString());
        SessionFactoryImpl factory = (SessionFactoryImpl)ClusterJHelper.getSessionFactory(props);
        factory.setDomainTypeHandlerFactory(this);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NdbOpenJPADomainTypeHandlerImpl<?> getDomainTypeHandler(ClassMapping cmd, Dictionary dictionary) {
        NdbOpenJPADomainTypeHandlerImpl<?> result;
        Class domainClass = cmd.getDescribedType();
        Map<Class<?>, NdbOpenJPADomainTypeHandlerImpl<?>> map = this.domainTypeHandlerMap;
        synchronized (map) {
            result = this.domainTypeHandlerMap.get(domainClass);
            if (result == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("domain class: " + domainClass.getName());
                }
                result = this.createDomainTypeHandler(cmd, dictionary);
                this.domainTypeHandlerMap.put(domainClass, result);
                result.initializeRelations();
                logger.info("New domain type " + result.getName() + (result.isSupportedType() ? " is supported." : " is not known to be supported because " + result.getReasons()));
            }
        }
        return result;
    }

    private NdbOpenJPADomainTypeHandlerImpl<?> createDomainTypeHandler(ClassMapping classMapping, Dictionary dictionary) {
        return new NdbOpenJPADomainTypeHandlerImpl(dictionary, classMapping, this);
    }

    protected void preClose() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
        super.preClose();
    }

    protected boolean isInvalidProperty(String propName) {
        if (super.isInvalidProperty(propName)) {
            return true;
        }
        String lowerCasePropName = propName.toLowerCase();
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            if (!lowerCasePropName.startsWith(prefixes[i] + ".ndb")) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> DomainTypeHandler<T> createDomainTypeHandler(Class<T> domainClass, Dictionary dictionary, ValueHandlerFactory valueHandlerFactory) {
        DomainTypeHandler result = this.domainTypeHandlerMap.get(domainClass);
        if (result == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Create_Domain_Type_Handler_First", (Object)domainClass.getName()));
        }
        return result;
    }

    static {
        try {
            intValueMethod = IntValue.class.getMethod("get", null);
            booleanValueMethod = BooleanValue.class.getMethod("get", null);
        }
        catch (SecurityException e) {
            throw new ClusterJFatalInternalException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClusterJFatalInternalException(e);
        }
    }
}

