/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import java.util.BitSet;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;

public class NdbOpenJPAUtility {
    protected static String[] javaTypeNames = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "Object", "String", "Number", "Array", "Collection", "Map", "java.util.Date", "PC", "Boolean", "Byte", "Character", "Double", "Float", "Integer", "Long", "Short", "BigDecimal", "BigInteger", "Locale", "PC Untyped", "Calendar", "OID", "InputStream", "InputReader"};

    public static String getJavaTypeName(int javaType) {
        if (javaType < javaTypeNames.length) {
            return javaTypeNames[javaType];
        }
        switch (javaType) {
            case 1007: {
                return "java.sql.Date";
            }
            case 1010: {
                return "java.sql.Time";
            }
            case 1011: {
                return "java.sql.Timestamp";
            }
        }
        return "unsupported";
    }

    public static String printBitSet(OpenJPAStateManager sm, BitSet fields) {
        ClassMetaData classMetaData = sm.getMetaData();
        FieldMetaData[] fieldMetaDatas = classMetaData.getFields();
        StringBuffer buffer = new StringBuffer("[");
        if (fields != null) {
            String separator = "";
            for (int i = 0; i < fields.size(); ++i) {
                if (!fields.get(i)) continue;
                buffer.append(separator);
                buffer.append(i);
                buffer.append(" ");
                buffer.append(fieldMetaDatas[i].getName());
                separator = ";";
            }
        }
        buffer.append("] ");
        return buffer.toString();
    }
}

