/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.AbstractJPABaseTest;
import com.mysql.clusterj.jpatest.model.BlobTypes;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class BlobTest
extends AbstractJPABaseTest {
    private static final int NUMBER_TO_INSERT = 16;
    protected List<BlobTypes> blobs = new ArrayList<BlobTypes>();

    protected boolean getDebug() {
        return false;
    }

    public void test() {
        this.createBlobInstances(16);
        this.remove();
        this.insert();
        this.update();
        this.failOnError();
    }

    protected void remove() {
        this.removeAll(BlobTypes.class);
    }

    protected void insert() {
        this.tx = this.em.getTransaction();
        this.tx.begin();
        int count = 0;
        for (int i = 0; i < 16; ++i) {
            this.em.persist((Object)this.blobs.get(i));
            ++count;
        }
        this.tx.commit();
    }

    protected void update() {
        byte[] bytes;
        int actualId;
        BlobTypes e;
        int i;
        this.tx.begin();
        for (i = 1; i < 16; ++i) {
            e = (BlobTypes)this.em.find(BlobTypes.class, (Object)i);
            actualId = e.getId();
            if (actualId != i) {
                this.error("Expected BlobTypes.id " + i + " but got " + actualId);
            }
            bytes = e.getBlobbytes();
            this.checkBlobbytes("before update", bytes, i, false);
            int position = this.getBlobSizeFor(i) / 2;
            if (bytes.length != position * 2) continue;
            bytes[position] = (byte)(position % 128);
            this.checkBlobbytes("after update", bytes, i, true);
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 1; i < 16; ++i) {
            e = (BlobTypes)this.em.find(BlobTypes.class, (Object)i);
            actualId = e.getId();
            if (actualId != i) {
                this.error("Expected BlobTypes.id " + i + " but got " + actualId);
            }
            bytes = e.getBlobbytes();
            this.checkBlobbytes("after commit", bytes, i, true);
        }
        this.tx.commit();
    }

    protected void createBlobInstances(int number) {
        for (int i = 0; i < number; ++i) {
            BlobTypes instance = new BlobTypes();
            instance.setId(i);
            int length = this.getBlobSizeFor(i);
            instance.setBlobbytes(this.getBlobbytes(length));
            this.blobs.add(instance);
        }
    }

    protected byte[] getBlobbytes(int size) {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(i % 256 - 128);
        }
        return result;
    }

    protected void checkBlobbytes(String where, byte[] bytes, int number, boolean updated) {
        int actualSize;
        int expectedSize;
        if (this.getDebug()) {
            this.dumpBlob(where, bytes);
        }
        if ((expectedSize = this.getBlobSizeFor(number)) != (actualSize = bytes.length)) {
            this.error("In " + where + " wrong size of byte[]; " + "expected: " + expectedSize + " actual: " + actualSize);
        }
        for (int i = 0; i < actualSize; ++i) {
            byte actual;
            int position = expectedSize / 2;
            byte expected = updated && i == position ? (byte)(position % 128) : (byte)(i % 256 - 128);
            if (expected == (actual = bytes[i])) continue;
            this.error("In " + where + " for size: " + actualSize + " mismatch in byte[] at position " + i + " expected: " + expected + " actual: " + actual);
        }
    }

    protected InputStream getBlobStream(final int i) {
        return new InputStream(){
            int size;
            int counter;
            {
                this.size = i;
                this.counter = 0;
            }

            public int read() throws IOException {
                if (this.counter >= i) {
                    return -1;
                }
                return this.counter++ % 256;
            }
        };
    }

    protected void dumpBlob(String where, byte[] blob) {
        System.out.println("In " + where + " dumpBlob of size: " + blob.length);
        for (byte b : blob) {
            System.out.print("[" + b + "]");
        }
        System.out.println();
    }

    protected int getBlobSizeFor(int i) {
        int length = (int)Math.pow(2.0, i);
        return length;
    }
}

