/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Ignore;
import testsuite.clusterj.AbstractClusterJTest;

@Ignore
public class CoordinatedTransactionIdVariableTest
extends AbstractClusterJTest {
    private String newId = "1:0:1:9000000000000099";
    private String badIdTooLong = "123456789012345678901234567890123456789012345";
    private String badIdTooShort = "1:1";
    private String sqlQuery = "select id from t_basic where id = 0";
    private String transactionIdVariableName = "@@ndb_transaction_id";
    private String joinTransactionIdVariableName = "@@ndb_join_transaction_id";

    protected void localSetUp() {
        this.createSessionFactory();
        this.closeConnection();
        this.getConnection();
        this.setAutoCommit(connection, false);
    }

    protected boolean getDebug() {
        return false;
    }

    public void checkTransactionIdInitialValue() {
        this.getConnection();
        String id = this.getJDBCTransactionId("checkTransactionIdInitialValue");
        this.errorIfNotEqual("Transaction id must default to null.", null, id);
    }

    public void checkJoinTransactionIdInitialValue() {
        this.getConnection();
        String id = this.getJDBCJoinTransactionId("checkJoinTransactionIdInitialValue");
        this.errorIfNotEqual("Join transaction id must default to null.", null, id);
    }

    public void checkSetTransactionId() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkSetTransactionId", this.transactionIdVariableName, this.newId, 1238);
        this.closeConnection();
    }

    public void checkNewIdResetWithNullString() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkNewIdResetWithNullString", this.joinTransactionIdVariableName, this.newId, 0);
        String id = this.getJDBCJoinTransactionId("checkNewIdResetWithNullString");
        this.errorIfNotEqual("failed to set coordinated transaction id.", this.newId, id);
        this.setJDBCVariable("checkNewIdResetWithNullString", this.joinTransactionIdVariableName, null, 0);
        id = this.getJDBCJoinTransactionId("checkNewIdResetWithNullString");
        this.errorIfNotEqual("failed to set coordinated transaction id to null.", null, id);
        this.closeConnection();
    }

    public void checkNewIdResetWithEmptyString() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkNewIdResetWithEmptyString", this.joinTransactionIdVariableName, this.newId, 0);
        String id = this.getJDBCJoinTransactionId("checkNewIdResetWithEmptyString");
        this.errorIfNotEqual("failed to set coordinated transaction id.", this.newId, id);
        this.setJDBCVariable("checkNewIdResetWithEmptyString", this.joinTransactionIdVariableName, "", 0);
        id = this.getJDBCJoinTransactionId("checkNewIdResetWithEmptyString");
        this.errorIfNotEqual("failed to set coordinated transaction id to null.", null, id);
        this.closeConnection();
    }

    public void checkBadIdTooLong() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkBadIdTooLong", this.joinTransactionIdVariableName, this.badIdTooLong, 1210);
        String id = this.getJDBCJoinTransactionId("checkBadIdTooLong");
        this.errorIfNotEqual("failed to set coordinated transaction id.", null, id);
        this.closeConnection();
    }

    public void checkBadIdTooShort() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkBadIdTooShort", this.joinTransactionIdVariableName, this.badIdTooShort, 1210);
        String id = this.getJDBCJoinTransactionId("checkBadIdTooShort");
        this.errorIfNotEqual("failed to set coordinated transaction id.", null, id);
        this.closeConnection();
    }

    public void checkIdAfterTransactionStartAndCommit() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.executeJDBCQuery("checkIdAfterTransactionStartAndCommit");
        String id = this.getJDBCTransactionId("checkIdAfterTransactionStartAndCommit");
        this.errorIfEqual("Transaction id must not be null after transaction start.", null, id);
        this.commitConnection();
        id = this.getJDBCTransactionId("checkIdAfterTransactionStartAndCommit");
        this.errorIfNotEqual("Transaction id must be null after commit.", null, id);
    }

    public void checkIdAfterTransactionStartAndRollback() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.executeJDBCQuery("checkIdAfterTransactionStartAndRollback");
        String id = this.getJDBCTransactionId("checkIdAfterTransactionStartAndRollback");
        this.errorIfEqual("Transaction must not be null after transaction start.", null, id);
        this.rollbackConnection();
        id = this.getJDBCTransactionId("checkIdAfterTransactionStartAndRollback");
        this.errorIfNotEqual("Transaction id must be null after rollback.", null, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJDBCQuery(String where) {
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(this.sqlQuery);
            rs = statement.executeQuery();
            boolean hasNext = rs.next();
            if (this.getDebug()) {
                System.out.println(where + " executeJDBCQuery rs.next() returned " + hasNext);
            }
        }
        catch (SQLException e) {
            this.error(where + " query threw exception ", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.error(where + " rs.close threw exception " + e.getMessage());
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.error(where + " statement.close threw exception ", e);
                }
            }
        }
    }

    protected void setJDBCVariable(String where, String variableName, String newId, int expectedErrorCode) {
        try {
            String setSql = "set " + variableName + " = ?";
            PreparedStatement setVariableStatement = connection.prepareStatement(setSql);
            if (newId == null) {
                setVariableStatement.setNull(1, 12);
            } else {
                setVariableStatement.setString(1, newId);
            }
            boolean resultNotUpdateCount = setVariableStatement.execute();
            this.errorIfNotEqual(where + " set join transaction id returned true.", false, resultNotUpdateCount);
            this.errorIfNotEqual(where + " set join transaction id failed to throw expected exception " + expectedErrorCode + " for " + newId, expectedErrorCode, 0);
        }
        catch (SQLException e) {
            int errorCode = e.getErrorCode();
            this.errorIfNotEqual(where + " caught wrong exception on set coordinated transaction id:" + " errorCode: " + errorCode + " SQLState: " + e.getSQLState(), expectedErrorCode, errorCode);
        }
    }

    protected String getJDBCJoinTransactionId(String where) {
        String getId = "select " + this.joinTransactionIdVariableName;
        String result = this.executeSelect(where, getId);
        return result;
    }

    protected String getJDBCTransactionId(String where) {
        String getId = "select " + this.transactionIdVariableName;
        String result = this.executeSelect(where, getId);
        return result;
    }

    private String executeSelect(String where, String getId) {
        String result = null;
        try {
            PreparedStatement getCoordinatedTransactionIdStatement = connection.prepareStatement(getId);
            ResultSet rs = getCoordinatedTransactionIdStatement.executeQuery();
            boolean hasResult = rs.next();
            this.errorIfNotEqual(where + " select " + getId + " returned false.", true, hasResult);
            result = rs.getString(1);
            if (this.getDebug()) {
                System.out.println(where + " " + getId + " returns " + result);
            }
        }
        catch (SQLException e) {
            this.error(where + " caught exception on select " + getId + ".", e);
        }
        return result;
    }

    protected void commitConnection() {
        try {
            connection.commit();
        }
        catch (SQLException e) {
            this.error("connection.commit threw exception: ", e);
        }
    }

    protected void rollbackConnection() {
        try {
            connection.rollback();
        }
        catch (SQLException e) {
            this.error("connection.rollback threw exception: ", e);
        }
    }
}

