/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.math.BigDecimal;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.DecimalTypes;
import testsuite.clusterj.model.IdBase;

public class QueryDecimalTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return DecimalTypes.class;
    }

    void createInstances(int number) {
        this.createAllDecimalTypesInstances(number);
    }

    public void test() {
        this.btreeIndexScanDecimal();
        this.hashIndexScanDecimal();
        this.bothIndexScanDecimal();
        this.noneIndexScanDecimal();
        this.failOnError();
    }

    public void btreeIndexScanDecimal() {
        this.equalQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(8), 8);
        this.greaterEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 5);
    }

    public void hashIndexScanDecimal() {
        this.equalQuery("decimal_null_hash", "idx_decimal_null_hash", this.getDecimal(8), 8);
        this.greaterEqualQuery("decimal_null_hash", "none", this.getDecimal(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_hash", "none", this.getDecimal(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_hash", "none", this.getDecimal(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_hash", "none", this.getDecimal(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 5);
    }

    public void bothIndexScanDecimal() {
        this.equalQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(8), 8);
        this.greaterEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 5);
    }

    public void noneIndexScanDecimal() {
        this.equalQuery("decimal_null_none", "none", this.getDecimal(8), 8);
        this.greaterEqualQuery("decimal_null_none", "none", this.getDecimal(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_none", "none", this.getDecimal(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_none", "none", this.getDecimal(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_none", "none", this.getDecimal(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 5);
    }

    private void createAllDecimalTypesInstances(int number) {
        for (int i = 0; i < number; ++i) {
            DecimalTypes instance = (DecimalTypes)this.session.newInstance(DecimalTypes.class);
            instance.setId(i);
            instance.setDecimal_null_hash(this.getDecimal(i));
            instance.setDecimal_null_btree(this.getDecimal(i));
            instance.setDecimal_null_both(this.getDecimal(i));
            instance.setDecimal_null_none(this.getDecimal(i));
            this.instances.add(instance);
        }
    }

    protected BigDecimal getDecimal(int number) {
        return BigDecimal.valueOf(number, 5);
    }

    protected void printResultInstance(IdBase instance) {
        if (instance instanceof DecimalTypes) {
            DecimalTypes decimalTypes = (DecimalTypes)instance;
        }
    }

    public static String toString(IdBase idBase) {
        DecimalTypes instance = (DecimalTypes)idBase;
        StringBuffer buffer = new StringBuffer("DecimalTypes id: ");
        buffer.append(instance.getId());
        buffer.append("; decimal_null_both: ");
        buffer.append(instance.getDecimal_null_both().toString());
        buffer.append("; decimal_null_btree: ");
        buffer.append(instance.getDecimal_null_btree().toString());
        buffer.append("; decimal_null_hash: ");
        buffer.append(instance.getDecimal_null_hash().toString());
        buffer.append("; decimal_null_none: ");
        buffer.append(instance.getDecimal_null_none().toString());
        return buffer.toString();
    }
}

