/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class SaveTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 4;

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(4);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.tx.begin();
        ArrayList insertedEmployees = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            if (i % 2 != 0) continue;
            insertedEmployees.add(this.employees.get(i));
        }
        this.session.makePersistentAll(insertedEmployees);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void testSave() {
        Employee e;
        int i;
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            if (e != null) {
                if (i % 2 != 0) {
                    this.error("Employee " + i + " should not exist.");
                }
                e.setAge(4 - i);
            } else if (i % 2 == 0) {
                this.error("Employee " + i + " should exist.");
            } else {
                e = (Employee)this.employees.get(i);
                e.setAge(4 - i);
            }
            this.session.savePersistent((Object)e);
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            if (e == null) {
                this.error("Failed save: employee " + i + " does not exist.");
                continue;
            }
            int expected = 4 - i;
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed save: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testSaveAll() {
        Employee e;
        int i;
        this.tx.begin();
        ArrayList<Employee> emps = new ArrayList<Employee>();
        ArrayList<Employee> expectedEmployees = new ArrayList<Employee>();
        for (int i2 = 0; i2 < 4; ++i2) {
            Employee e2 = (Employee)this.session.find(Employee.class, (Object)i2);
            if (e2 != null) {
                if (i2 % 2 != 0) {
                    this.error("Employee " + i2 + " should not exist.");
                }
                e2.setAge(4 - i2);
            } else if (i2 % 2 == 0) {
                this.error("Employee " + i2 + " should exist.");
            } else {
                e2 = (Employee)this.employees.get(i2);
                e2.setAge(4 - i2);
            }
            emps.add(e2);
            expectedEmployees.add(e2);
        }
        List savedEmployees = (List)this.session.savePersistentAll(emps);
        if (savedEmployees.size() != 4) {
            this.error("Wrong size for saved employees. Expected: 4 actual: " + savedEmployees.size());
        }
        for (i = 0; i < 4; ++i) {
            e = (Employee)expectedEmployees.get(i);
            Employee saved = (Employee)savedEmployees.get(i);
            if (saved == e) continue;
            this.error("Failed saveAll: employee " + i + " did not match savedEmployees. " + "Expected: " + e.toString() + " hashcode: " + e.hashCode() + " actual: " + saved.toString() + " hashcode: " + saved.hashCode());
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            if (e == null) {
                this.error("Failed saveAll: employee " + i + " does not exist.");
                continue;
            }
            int expected = 4 - i;
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed saveAll: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
        this.failOnError();
    }
}

