/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.SingleEMTestCase;
import com.mysql.clusterj.jpatest.model.Employee;
import com.mysql.clusterj.jpatest.model.IdBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJPABaseTest
extends SingleEMTestCase {
    protected static TimeZone localSystemTimeZone = TimeZone.getDefault();
    protected Connection connection;
    private ColumnDescriptor[] columnDescriptors = this.getColumnDescriptors();
    List<IdBase> instances = new ArrayList<IdBase>();
    private List<Object[]> expected = null;
    protected static boolean debug;

    public AbstractJPABaseTest() {
        debug = this.getDebug();
    }

    protected void getConnection() {
        this.connection = (Connection)((OpenJPAEntityManager)this.em).getConnection();
        this.setAutoCommit(this.connection, false);
    }

    protected void setAutoCommit(Connection connection, boolean b) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException("setAutoCommit failed", e);
        }
    }

    public void deleteAll() {
        this.em = this.emf.createEntityManager();
        this.begin();
        for (int i = 0; i < this.getNumberOfEmployees(); ++i) {
            Employee e = (Employee)this.em.find(Employee.class, (Object)i);
            if (e == null) continue;
            this.em.remove((Object)e);
        }
        this.commit();
        this.em.close();
    }

    public void verifyDeleteAll() {
        this.em = this.emf.createEntityManager();
        this.begin();
        for (int i = 0; i < this.getNumberOfEmployees(); ++i) {
            Employee e = (Employee)this.em.find(Employee.class, (Object)i);
            if (e == null) continue;
            this.error("Entity exists after being removed: " + i);
        }
        this.commit();
        this.failOnError();
        this.em.close();
    }

    public void createAll() {
        this.em = this.emf.createEntityManager();
        this.begin();
        for (int i = 0; i < this.getNumberOfEmployees(); ++i) {
            Employee e = new Employee();
            e.setId(i);
            e.setAge(i);
            e.setMagic(i);
            e.setName("Employee " + i);
            this.em.persist((Object)e);
        }
        this.commit();
        this.em.close();
    }

    public void findAll() {
        this.em = this.emf.createEntityManager();
        this.begin();
        for (int i = 0; i < this.getNumberOfEmployees(); ++i) {
            Employee e = (Employee)this.em.find(Employee.class, (Object)i);
            this.verifyEmployee(e, 0);
        }
        this.commit();
        this.em.close();
    }

    public void updateThenVerifyAll() {
        Employee e;
        int i;
        this.em = this.emf.createEntityManager();
        this.begin();
        for (i = 0; i < this.getNumberOfEmployees(); ++i) {
            e = (Employee)this.em.find(Employee.class, (Object)i);
            e.setAge(i + 1);
            this.verifyEmployee(e, 1);
        }
        this.commit();
        this.begin();
        for (i = 0; i < this.getNumberOfEmployees(); ++i) {
            e = (Employee)this.em.find(Employee.class, (Object)i);
            this.verifyEmployee(e, 1);
        }
        this.commit();
        this.em.close();
    }

    public void deleteThenVerifyAll() {
        Employee e;
        int i;
        this.em = this.emf.createEntityManager();
        this.begin();
        for (i = 0; i < this.getNumberOfEmployees(); ++i) {
            e = (Employee)this.em.find(Employee.class, (Object)i);
            this.verifyEmployee(e, 1);
            this.em.remove((Object)e);
        }
        this.commit();
        this.begin();
        for (i = 0; i < this.getNumberOfEmployees(); ++i) {
            e = (Employee)this.em.find(Employee.class, (Object)i);
            if (e == null) continue;
            this.error("Entity exists after being removed: " + i);
        }
        this.commit();
        this.em.close();
    }

    protected void verifyEmployee(Employee e, int updateOffset) {
        int i = e.getId();
        this.errorIfNotEqual("Error in age", i + updateOffset, (int)e.getAge());
        this.errorIfNotEqual("Error in magic", i, e.getMagic());
        this.errorIfNotEqual("Error in name", "Employee " + i, e.getName());
    }

    protected int getNumberOfEmployees() {
        return 1;
    }

    protected static long getMillisFor(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        long result = calendar.getTimeInMillis();
        return result;
    }

    protected static long getMillisFor(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long result = calendar.getTimeInMillis();
        return result;
    }

    protected static long getMillisFor(int days, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(5, days + 1);
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        long result = calendar.getTimeInMillis();
        return result;
    }

    protected static void resetLocalSystemDefaultTimeZone(Connection connection) {
        try {
            PreparedStatement statement = connection.prepareStatement("select @@global.time_zone, @@global.system_time_zone, @@session.time_zone");
            ResultSet rs = statement.executeQuery();
            rs.next();
            String globalTimeZone = rs.getString(1);
            String globalSystemTimeZone = rs.getString(2);
            String sessionTimeZone = rs.getString(3);
            if (debug) {
                System.out.println("Global time zone: " + globalTimeZone + " Global system time zone: " + globalSystemTimeZone + " Session time zone: " + sessionTimeZone);
            }
            connection.commit();
            globalTimeZone = "SYSTEM".equalsIgnoreCase(globalTimeZone) ? globalSystemTimeZone : "GMT" + globalTimeZone;
            localSystemTimeZone = TimeZone.getTimeZone(globalTimeZone);
            if (debug) {
                System.out.println("Local system time zone set to: " + globalTimeZone + "(" + localSystemTimeZone + ")");
            }
            TimeZone.setDefault(localSystemTimeZone);
            connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("setServerTimeZone failed", e);
        }
    }

    protected boolean getDebug() {
        return false;
    }

    protected List<Object[]> getExpected() {
        return this.expected;
    }

    protected String getTableName() {
        return null;
    }

    protected int getNumberOfInstances() {
        return 0;
    }

    protected ColumnDescriptor[] getColumnDescriptors() {
        return null;
    }

    protected IdBase getNewInstance(Class<? extends IdBase> modelClass) {
        return null;
    }

    protected Class<? extends IdBase> getModelClass() {
        return null;
    }

    protected Object getColumnValue(int i, int j) {
        return null;
    }

    protected void generateInstances(ColumnDescriptor[] columnDescriptors) {
        Class<? extends IdBase> modelClass = this.getModelClass();
        this.expected = new ArrayList<Object[]>();
        this.instances = new ArrayList<IdBase>();
        IdBase instance = null;
        int numberOfInstances = this.getNumberOfInstances();
        for (int i = 0; i < numberOfInstances; ++i) {
            instance = this.getNewInstance(modelClass);
            instance.setId(i);
            int j = 0;
            for (ColumnDescriptor columnDescriptor : columnDescriptors) {
                Object value = this.getColumnValue(i, j);
                columnDescriptor.setFieldValue(instance, value);
                if (debug) {
                    System.out.println("generateInstances set field " + columnDescriptor.getColumnName() + " to value " + value);
                }
                ++j;
            }
            this.instances.add(instance);
            Object[] expectedRow = this.createRow(columnDescriptors, instance);
            this.expected.add(expectedRow);
        }
        if (debug) {
            System.out.println("Created " + this.instances.size() + " instances.");
        }
    }

    protected void verify(String where, List<Object[]> expecteds, List<Object[]> actuals) {
        for (int i = 0; i < expecteds.size(); ++i) {
            Object[] expected = expecteds.get(i);
            Object[] actual = actuals.get(i);
            this.errorIfNotEqual(where + " got failure on id for row " + i, i, actual[0]);
            for (int j = 1; j < expected.length; ++j) {
                this.errorIfNotEqual(where + " got failure to match column data for row " + i + " column " + j, expected[j], actual[j]);
            }
        }
    }

    protected void removeAll(Class<?> modelClass) {
        Query query = this.em.createQuery("DELETE FROM " + modelClass.getSimpleName());
        this.em.getTransaction().begin();
        query.executeUpdate();
        this.em.getTransaction().commit();
    }

    private void removeAll(String tableName) {
        this.getConnection();
        try {
            PreparedStatement statement = this.connection.prepareStatement("DELETE FROM " + tableName);
            statement.execute();
            this.connection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void writeJDBCreadJPA() {
        this.generateInstances(this.columnDescriptors);
        this.removeAll(this.getTableName());
        List<Object[]> result = null;
        this.writeToJDBC(this.columnDescriptors, this.instances);
        result = this.readFromJPA(this.columnDescriptors);
        this.verify("writeJDBCreadJPA", this.getExpected(), result);
    }

    protected void writeJDBCreadJDBC() {
        this.generateInstances(this.columnDescriptors);
        this.removeAll(this.getTableName());
        List<Object[]> result = null;
        this.writeToJDBC(this.columnDescriptors, this.instances);
        result = this.readFromJDBC(this.columnDescriptors);
        this.verify("writeJDBCreadJDBC", this.getExpected(), result);
    }

    protected void writeJPAreadJPA() {
        this.generateInstances(this.columnDescriptors);
        this.removeAll(this.getModelClass());
        List<Object[]> result = null;
        this.writeToJPA(this.columnDescriptors, this.instances);
        result = this.readFromJPA(this.columnDescriptors);
        this.verify("writeJPAreadJPA", this.getExpected(), result);
    }

    protected void writeJPAreadJDBC() {
        this.generateInstances(this.columnDescriptors);
        this.removeAll(this.getTableName());
        List<Object[]> result = null;
        this.writeToJPA(this.columnDescriptors, this.instances);
        result = this.readFromJDBC(this.columnDescriptors);
        this.verify("writeJPAreadJDBC", this.getExpected(), result);
    }

    protected void writeToJPA(ColumnDescriptor[] columnDescriptors, List<IdBase> instances) {
        this.em.getTransaction().begin();
        for (IdBase instance : instances) {
            this.em.persist((Object)instance);
        }
        this.em.getTransaction().commit();
    }

    protected void writeToJDBC(ColumnDescriptor[] columnDescriptors, List<IdBase> instances) {
        String tableName = this.getTableName();
        StringBuffer buffer = new StringBuffer("INSERT INTO ");
        buffer.append(tableName);
        buffer.append(" (id");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            buffer.append(", ");
            buffer.append(columnDescriptor.getColumnName());
        }
        buffer.append(") VALUES (?");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            buffer.append(", ?");
        }
        buffer.append(")");
        String statement = buffer.toString();
        if (debug) {
            System.out.println(statement);
        }
        PreparedStatement preparedStatement = null;
        int i = 0;
        try {
            preparedStatement = this.connection.prepareStatement(statement);
            if (debug) {
                System.out.println(preparedStatement.toString());
            }
            for (i = 0; i < instances.size(); ++i) {
                IdBase instance = instances.get(i);
                preparedStatement.setInt(1, instance.getId());
                int j = 2;
                for (ColumnDescriptor columnDescriptor : columnDescriptors) {
                    Object value = columnDescriptor.getFieldValue(instance);
                    columnDescriptor.setPreparedStatementValue(preparedStatement, j++, value);
                    if (!debug) continue;
                    System.out.println("writeToJDBC set column: " + columnDescriptor.getColumnName() + " to value: " + value);
                }
                preparedStatement.execute();
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to insert " + tableName + " at instance " + i, e);
        }
    }

    protected List<Object[]> readFromJPA(ColumnDescriptor[] columnDescriptors) {
        Class<? extends IdBase> modelClass = this.getModelClass();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        this.em.getTransaction().begin();
        for (int i = 0; i < this.getNumberOfInstances(); ++i) {
            IdBase instance = (IdBase)this.em.find(modelClass, (Object)i);
            if (instance == null) continue;
            Object[] row = this.createRow(columnDescriptors, instance);
            result.add(row);
        }
        this.em.getTransaction().commit();
        if (debug) {
            System.out.println("readFromJPA: " + this.dump(result));
        }
        return result;
    }

    protected List<Object[]> readFromJDBC(ColumnDescriptor[] columnDescriptors) {
        String tableName = this.getTableName();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        StringBuffer buffer = new StringBuffer("SELECT id");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            buffer.append(", ");
            buffer.append(columnDescriptor.getColumnName());
        }
        buffer.append(" FROM ");
        buffer.append(tableName);
        buffer.append(" ORDER BY ID");
        String statement = buffer.toString();
        if (debug) {
            System.out.println(statement);
        }
        PreparedStatement preparedStatement = null;
        int i = 0;
        try {
            preparedStatement = this.connection.prepareStatement(statement);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                Object[] row = new Object[columnDescriptors.length + 1];
                int j = 1;
                row[0] = rs.getInt(1);
                for (ColumnDescriptor columnDescriptor : columnDescriptors) {
                    row[j] = columnDescriptor.getResultSetValue(rs, j + 1);
                    ++j;
                }
                ++i;
                result.add(row);
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to read " + tableName + " at instance " + i, e);
        }
        if (debug) {
            System.out.println("readFromJDBC: " + this.dump(result));
        }
        return result;
    }

    private Object[] createRow(ColumnDescriptor[] columnDescriptors, IdBase instance) {
        Object[] row = new Object[columnDescriptors.length + 1];
        row[0] = instance.getId();
        int j = 1;
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            row[j++] = columnDescriptor.getFieldValue(instance);
        }
        return row;
    }

    private String dump(List<Object[]> results) {
        StringBuffer result = new StringBuffer(results.size() + " rows\n");
        for (Object[] row : results) {
            result.append("Id: ");
            for (Object column : row) {
                result.append(column);
                result.append(' ');
            }
            result.append('\n');
        }
        return result.toString();
    }

    protected static interface InstanceHandler {
        public void setFieldValue(IdBase var1, Object var2);

        public Object getResultSetValue(ResultSet var1, int var2) throws SQLException;

        public Object getFieldValue(IdBase var1);

        public void setPreparedStatementValue(PreparedStatement var1, int var2, Object var3) throws SQLException;
    }

    protected static class ColumnDescriptor {
        private String columnName;
        protected InstanceHandler instanceHandler;

        public String getColumnName() {
            return this.columnName;
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            return this.instanceHandler.getResultSetValue(rs, j);
        }

        public Object getFieldValue(IdBase instance) {
            return this.instanceHandler.getFieldValue(instance);
        }

        public void setFieldValue(IdBase instance, Object value) {
            this.instanceHandler.setFieldValue(instance, value);
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            this.instanceHandler.setPreparedStatementValue(preparedStatement, j, value);
        }

        protected ColumnDescriptor(String name, InstanceHandler instanceHandler) {
            this.columnName = name;
            this.instanceHandler = instanceHandler;
        }
    }
}

