/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.AbstractResult;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NdbOpenJPAResult
extends AbstractResult
implements Result {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPAResult.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAResult.class);
    protected ResultData resultData;
    protected DomainTypeHandler<?> domainTypeHandler;
    protected BitSet fields;
    private Map<String, com.mysql.clusterj.core.store.Column> columnMap = new HashMap<String, com.mysql.clusterj.core.store.Column>();

    public NdbOpenJPAResult(ResultData resultData, DomainTypeHandler<?> domainTypeHandler, BitSet fields) {
        this.resultData = resultData;
        this.domainTypeHandler = domainTypeHandler;
        this.fields = fields;
        Set<com.mysql.clusterj.core.store.Column> storeColumns = domainTypeHandler.getStoreColumns(fields);
        for (com.mysql.clusterj.core.store.Column storeColumn : storeColumns) {
            this.columnMap.put(storeColumn.getName(), storeColumn);
        }
    }

    protected boolean nextInternal() throws SQLException {
        boolean result = this.resultData.next();
        if (logger.isDetailEnabled()) {
            logger.detail("returning: " + result);
        }
        return result;
    }

    protected boolean containsInternal(Object obj, Joins joins) throws SQLException {
        com.mysql.clusterj.core.store.Column storeColumn = this.resolve(obj);
        return storeColumn != null;
    }

    protected Object getObjectInternal(Object obj, int metaType, Object arg, Joins joins) throws SQLException {
        Object result = null;
        com.mysql.clusterj.core.store.Column columnName = this.resolve(obj);
        switch (metaType) {
            case 5: 
            case 21: {
                result = this.resultData.getInt(columnName);
                break;
            }
            case 3: 
            case 19: {
                result = this.resultData.getDouble(columnName);
                break;
            }
            case 4: 
            case 20: {
                result = Float.valueOf(this.resultData.getFloat(columnName));
                break;
            }
            case 9: {
                result = this.resultData.getString(columnName);
                break;
            }
            case 6: 
            case 22: {
                result = this.resultData.getLong(columnName);
                break;
            }
            case 24: {
                result = this.resultData.getDecimal(columnName);
                break;
            }
            case 25: {
                result = this.resultData.getBigInteger(columnName);
                break;
            }
            case 14: {
                result = new java.util.Date(this.resultData.getLong(columnName));
                break;
            }
            case 1010: {
                result = new Time(this.resultData.getLong(columnName));
                break;
            }
            case 1007: {
                result = new Date(this.resultData.getLong(columnName));
                break;
            }
            case 1011: {
                result = new Timestamp(this.resultData.getLong(columnName));
                break;
            }
            case 1004: {
                result = this.resultData.getBytes(columnName);
                break;
            }
            case 0: 
            case 16: {
                result = this.resultData.getObjectBoolean(columnName);
                break;
            }
            default: {
                Column col;
                if (obj instanceof Column && ((col = (Column)obj).getType() == 2004 || col.getType() == -3)) {
                    result = this.resultData.getBytes(columnName);
                }
                result = this.resultData.getInt(columnName);
            }
        }
        if (logger.isDetailEnabled()) {
            logger.detail("obj: " + obj + " arg: " + arg + " joins: " + joins + " metaType: " + metaType + " result: " + result);
        }
        return result;
    }

    protected Object getStreamInternal(JDBCStore store, Object obj, int metaType, Object arg, Joins joins) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int size() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected long getLongInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 6, null, joins));
        return val == null ? 0L : val.longValue();
    }

    protected com.mysql.clusterj.core.store.Column resolve(Object obj) {
        String key = null;
        com.mysql.clusterj.core.store.Column result = null;
        if (logger.isDetailEnabled()) {
            logger.detail("resolving object of type: " + obj.getClass().getName());
        }
        if (obj instanceof String) {
            key = (String)obj;
            result = this.columnMap.get(key);
        } else if (obj instanceof Column) {
            key = ((Column)obj).getName();
            result = this.columnMap.get(key);
        } else {
            throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Type_For_Resolve", (Object)obj.getClass().getName()));
        }
        if (logger.isDetailEnabled()) {
            logger.detail("key: " + key + " column: " + (result == null ? "<null>" : result.getName()));
        }
        return result;
    }

    public Set<String> getColumnNames() {
        return this.columnMap.keySet();
    }
}

