/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.HashSet;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class QueryTableScanTest
extends AbstractClusterJModelTest {
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.createEmployeeInstances(10);
        try {
            this.tx.begin();
            this.session.deletePersistentAll(Employee.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tx.begin();
        this.session.makePersistentAll((Iterable)this.employees);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void testTableScan() {
        this.tableScanEqualQuery();
        this.tableScanGreaterEqualQuery();
        this.tableScanGreaterThanQuery();
        this.tableScanLessEqualQuery();
        this.tableScanLessThanQuery();
        this.failOnError();
    }

    public void tableScanEqualQuery() {
        this.tx.begin();
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(Employee.class);
        PredicateOperand param = dobj.param("name");
        PredicateOperand column = dobj.get("name");
        Predicate compare = column.equal(param);
        dobj.where(compare);
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("name", (Object)"Employee number 8");
        List results = query.getResultList();
        this.consistencyCheck(results);
        this.errorIfNotEqual("Wrong employee id returned from equal query: ", 8, ((Employee)results.get(0)).getId());
        this.tx.commit();
    }

    public void tableScanGreaterThanQuery() {
        this.tx.begin();
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(Employee.class);
        PredicateOperand param = dobj.param("name");
        PredicateOperand column = dobj.get("name");
        Predicate compare = column.greaterThan(param);
        dobj.where(compare);
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("name", (Object)"Employee number 6");
        List results = query.getResultList();
        this.consistencyCheck(results);
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        HashSet<Integer> actual = new HashSet<Integer>();
        for (Employee emp : results) {
            actual.add(emp.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from greaterThan query: ", expected, actual);
        this.tx.commit();
    }

    public void tableScanGreaterEqualQuery() {
        this.tx.begin();
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(Employee.class);
        PredicateOperand param = dobj.param("name");
        PredicateOperand column = dobj.get("name");
        Predicate compare = column.greaterEqual(param);
        dobj.where(compare);
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("name", (Object)"Employee number 7");
        List results = query.getResultList();
        this.consistencyCheck(results);
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        HashSet<Integer> actual = new HashSet<Integer>();
        for (Employee emp : results) {
            actual.add(emp.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from greaterEqual query: ", expected, actual);
        this.tx.commit();
    }

    public void tableScanLessThanQuery() {
        this.tx.begin();
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(Employee.class);
        PredicateOperand param = dobj.param("name");
        PredicateOperand column = dobj.get("name");
        Predicate compare = column.lessThan(param);
        dobj.where(compare);
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("name", (Object)"Employee number 3");
        List results = query.getResultList();
        this.consistencyCheck(results);
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(0);
        expected.add(1);
        expected.add(2);
        HashSet<Integer> actual = new HashSet<Integer>();
        for (Employee emp : results) {
            actual.add(emp.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from lessThan query: ", expected, actual);
        this.tx.commit();
    }

    public void tableScanLessEqualQuery() {
        this.tx.begin();
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(Employee.class);
        PredicateOperand param = dobj.param("name");
        PredicateOperand column = dobj.get("name");
        Predicate compare = column.lessEqual(param);
        dobj.where(compare);
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("name", (Object)"Employee number 2");
        List results = query.getResultList();
        this.consistencyCheck(results);
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(0);
        expected.add(1);
        expected.add(2);
        HashSet<Integer> actual = new HashSet<Integer>();
        for (Employee emp : results) {
            actual.add(emp.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from lessEqual query: ", expected, actual);
        this.tx.commit();
    }
}

