/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfiguration;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfigurationImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCBrokerFactory;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;

public class NdbOpenJPABrokerFactory
extends JDBCBrokerFactory {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPABrokerFactory.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPABrokerFactory.class);

    public static NdbOpenJPABrokerFactory newInstance(ConfigurationProvider cp) {
        NdbOpenJPAConfigurationImpl conf = new NdbOpenJPAConfigurationImpl();
        cp.setInto((Configuration)conf);
        return new NdbOpenJPABrokerFactory(conf);
    }

    public static NdbOpenJPABrokerFactory getInstance(ConfigurationProvider cp) {
        Map props = cp.getProperties();
        Object key = NdbOpenJPABrokerFactory.toPoolKey((Map)props);
        NdbOpenJPABrokerFactory factory = (NdbOpenJPABrokerFactory)NdbOpenJPABrokerFactory.getPooledFactoryForKey((Object)key);
        if (factory != null) {
            return factory;
        }
        factory = NdbOpenJPABrokerFactory.newInstance(cp);
        NdbOpenJPABrokerFactory.pool((Object)key, (AbstractBrokerFactory)factory);
        return factory;
    }

    public NdbOpenJPABrokerFactory(NdbOpenJPAConfiguration conf) {
        super((JDBCConfiguration)conf);
        if (logger.isInfoEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("connectString: " + conf.getConnectString());
            buffer.append("; connectDelay: " + conf.getConnectDelay());
            buffer.append("; connectVerbose: " + conf.getConnectVerbose());
            buffer.append("; connectTimeoutBefore: " + conf.getConnectTimeoutBefore());
            buffer.append("; connectTimeoutAfter: " + conf.getConnectTimeoutAfter());
            buffer.append("; maxTransactions: " + conf.getMaxTransactions());
            buffer.append("; default database: " + conf.getDatabase());
            logger.info(buffer.toString());
        }
    }

    protected StoreManager newStoreManager() {
        return new NdbOpenJPAStoreManager();
    }
}

