/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionServiceImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbRecord;
import com.mysql.ndbjtie.ndbapi.NdbRecordConst;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class NdbRecordImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordImpl.class);
    protected static final int SIZEOF_RECORD_SPECIFICATION = ClusterConnectionServiceImpl.SIZEOF_RECORD_SPECIFICATION;
    private NdbRecord ndbRecord = null;
    protected Column[] storeColumns = null;
    private NdbDictionary.RecordSpecificationArray recordSpecificationArray;
    NdbDictionary.TableConst tableConst = null;
    NdbDictionary.IndexConst indexConst = null;
    protected int bufferSize;
    protected int maximumColumnId;
    protected int[] offsets;
    protected int[] lengths;
    protected static final byte[] BIT_IN_BYTE_MASK = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    protected static final byte[] RESET_BIT_IN_BYTE_MASK = new byte[]{-2, -3, -5, -9, -17, -33, -65, 127};
    protected int[] nullbitBitInByte = null;
    protected int[] nullbitByteOffset = null;
    protected int nullIndicatorSize;
    protected int maximumColumnLength;
    private NdbDictionary.Dictionary ndbDictionary;
    private int numberOfTableColumns;
    int offset = 0;
    int nullablePosition = 0;
    byte[] defaultValues;
    private int[] recordSpecificationIndexes = null;

    protected NdbRecordImpl(Table storeTable, NdbDictionary.Dictionary ndbDictionary) {
        this.ndbDictionary = ndbDictionary;
        this.tableConst = this.getNdbTable(storeTable.getName());
        this.numberOfTableColumns = this.tableConst.getNoOfColumns();
        this.recordSpecificationArray = NdbDictionary.RecordSpecificationArray.create(this.numberOfTableColumns);
        this.recordSpecificationIndexes = new int[this.numberOfTableColumns];
        this.offsets = new int[this.numberOfTableColumns];
        this.lengths = new int[this.numberOfTableColumns];
        this.nullbitBitInByte = new int[this.numberOfTableColumns];
        this.nullbitByteOffset = new int[this.numberOfTableColumns];
        this.storeColumns = new Column[this.numberOfTableColumns];
        this.ndbRecord = this.createNdbRecord(storeTable, ndbDictionary);
        if (logger.isDetailEnabled()) {
            logger.detail(storeTable.getName() + " " + this.dumpDefinition());
        }
        this.initializeDefaultBuffer();
    }

    protected NdbRecordImpl(Index storeIndex, Table storeTable, NdbDictionary.Dictionary ndbDictionary) {
        this.ndbDictionary = ndbDictionary;
        this.tableConst = this.getNdbTable(storeTable.getName());
        this.indexConst = this.getNdbIndex(storeIndex.getInternalName(), this.tableConst.getName());
        this.numberOfTableColumns = this.tableConst.getNoOfColumns();
        int numberOfIndexColumns = this.indexConst.getNoOfColumns();
        this.recordSpecificationArray = NdbDictionary.RecordSpecificationArray.create(numberOfIndexColumns);
        this.recordSpecificationIndexes = new int[this.numberOfTableColumns];
        this.offsets = new int[this.numberOfTableColumns];
        this.lengths = new int[this.numberOfTableColumns];
        this.nullbitBitInByte = new int[this.numberOfTableColumns];
        this.nullbitByteOffset = new int[this.numberOfTableColumns];
        this.storeColumns = new Column[this.numberOfTableColumns];
        this.ndbRecord = this.createNdbRecord(storeIndex, storeTable, ndbDictionary);
        if (logger.isDetailEnabled()) {
            logger.detail(storeIndex.getInternalName() + " " + this.dumpDefinition());
        }
        this.initializeDefaultBuffer();
    }

    private void initializeDefaultBuffer() {
        this.defaultValues = new byte[this.bufferSize];
        ByteBuffer zeros = ByteBuffer.allocateDirect(this.bufferSize);
        zeros.order(ByteOrder.nativeOrder());
        zeros.put(this.defaultValues);
        for (Column storeColumn : this.storeColumns) {
            if (storeColumn == null || !storeColumn.getNullable()) continue;
            this.setNull(zeros, storeColumn);
        }
        zeros.position(0);
        zeros.limit(this.bufferSize);
        zeros.get(this.defaultValues);
    }

    protected ByteBuffer newBuffer() {
        ByteBuffer result = ByteBuffer.allocateDirect(this.bufferSize);
        this.initializeBuffer(result);
        return result;
    }

    protected void initializeBuffer(ByteBuffer buffer) {
        buffer.order(ByteOrder.nativeOrder());
        buffer.limit(this.bufferSize);
        buffer.position(0);
        buffer.put(this.defaultValues);
        buffer.position(0);
    }

    public int setNull(ByteBuffer buffer, Column storeColumn) {
        int columnId = storeColumn.getColumnId();
        if (!storeColumn.getNullable()) {
            return columnId;
        }
        int index = this.nullbitByteOffset[columnId];
        byte mask = BIT_IN_BYTE_MASK[this.nullbitBitInByte[columnId]];
        byte nullbyte = buffer.get(index);
        buffer.put(index, (byte)(nullbyte | mask));
        return columnId;
    }

    public int resetNull(ByteBuffer buffer, Column storeColumn) {
        int columnId = storeColumn.getColumnId();
        if (!storeColumn.getNullable()) {
            return columnId;
        }
        int index = this.nullbitByteOffset[columnId];
        byte mask = RESET_BIT_IN_BYTE_MASK[this.nullbitBitInByte[columnId]];
        byte nullbyte = buffer.get(index);
        buffer.put(index, (byte)(nullbyte & mask));
        return columnId;
    }

    public int setBigInteger(ByteBuffer buffer, Column storeColumn, BigInteger value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        int newPosition = this.offsets[columnId];
        buffer.position(newPosition);
        ByteBuffer bigIntegerBuffer = Utility.convertValue(storeColumn, value);
        buffer.put(bigIntegerBuffer);
        buffer.limit(this.bufferSize);
        buffer.position(0);
        return columnId;
    }

    public int setByte(ByteBuffer buffer, Column storeColumn, byte value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        if (storeColumn.getType() == ColumnType.Bit) {
            buffer.putInt(this.offsets[columnId], value & 0xFF);
        } else {
            buffer.put(this.offsets[columnId], value);
        }
        buffer.limit(this.bufferSize);
        buffer.position(0);
        return columnId;
    }

    public int setBytes(ByteBuffer buffer, Column storeColumn, byte[] value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        int offset = this.offsets[columnId];
        int length = storeColumn.getLength();
        int prefixLength = storeColumn.getPrefixLength();
        if (length < value.length) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", storeColumn.getName(), length, value.length));
        }
        buffer.limit(offset + prefixLength + length);
        buffer.position(offset);
        Utility.convertValue(buffer, storeColumn, value);
        buffer.limit(this.bufferSize);
        buffer.position(0);
        return columnId;
    }

    public int setDecimal(ByteBuffer buffer, Column storeColumn, BigDecimal value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        int newPosition = this.offsets[columnId];
        buffer.position(newPosition);
        ByteBuffer decimalBuffer = Utility.convertValue(storeColumn, value);
        buffer.put(decimalBuffer);
        return columnId;
    }

    public int setDouble(ByteBuffer buffer, Column storeColumn, double value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        buffer.putDouble(this.offsets[columnId], value);
        return columnId;
    }

    public int setFloat(ByteBuffer buffer, Column storeColumn, float value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        buffer.putFloat(this.offsets[columnId], value);
        return columnId;
    }

    public int setInt(ByteBuffer buffer, Column storeColumn, int value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        int storageValue = Utility.convertIntValueForStorage(storeColumn, value);
        buffer.putInt(this.offsets[columnId], storageValue);
        return columnId;
    }

    public int setLong(ByteBuffer buffer, Column storeColumn, long value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        long storeValue = Utility.convertLongValueForStorage(storeColumn, value);
        buffer.putLong(this.offsets[columnId], storeValue);
        return columnId;
    }

    public int setShort(ByteBuffer buffer, Column storeColumn, short value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        if (storeColumn.getLength() == 4) {
            buffer.putInt(this.offsets[columnId], value & 0xFFFF);
        } else {
            buffer.putShort(this.offsets[columnId], value);
        }
        return columnId;
    }

    public int setString(ByteBuffer buffer, DbImpl.BufferManager bufferManager, Column storeColumn, String value) {
        this.resetNull(buffer, storeColumn);
        int columnId = storeColumn.getColumnId();
        int offset = this.offsets[columnId];
        int prefixLength = storeColumn.getPrefixLength();
        int length = storeColumn.getLength() + prefixLength;
        buffer.limit(offset + length);
        buffer.position(offset);
        ByteBuffer converted = Utility.encode(value, storeColumn, bufferManager);
        if (length < converted.remaining()) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", storeColumn.getName(), length - prefixLength, converted.remaining() - prefixLength));
        }
        buffer.put(converted);
        buffer.limit(this.bufferSize);
        buffer.position(0);
        return columnId;
    }

    public boolean getBoolean(ByteBuffer buffer, int columnId) {
        int value = buffer.getInt(this.offsets[columnId]);
        return Utility.getBoolean(this.storeColumns[columnId], value);
    }

    public byte getByte(ByteBuffer buffer, int columnId) {
        Column storeColumn = this.storeColumns[columnId];
        if (storeColumn.getType() == ColumnType.Bit) {
            return (byte)buffer.getInt(this.offsets[columnId]);
        }
        return buffer.get(this.offsets[columnId]);
    }

    public byte[] getBytes(ByteBuffer byteBuffer, int columnId) {
        return this.getBytes(byteBuffer, this.storeColumns[columnId]);
    }

    public byte[] getBytes(ByteBuffer byteBuffer, Column storeColumn) {
        int columnId = storeColumn.getColumnId();
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        int prefixLength = storeColumn.getPrefixLength();
        int actualLength = this.lengths[columnId];
        int offset = this.offsets[columnId];
        switch (prefixLength) {
            case 0: {
                break;
            }
            case 1: {
                actualLength = (byteBuffer.get(offset) + 256) % 256;
                ++offset;
                break;
            }
            case 2: {
                actualLength = (byteBuffer.get(offset) + 256) % 256;
                int length2 = (byteBuffer.get(offset + 1) + 256) % 256;
                actualLength += 256 * length2;
                offset += 2;
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Prefix_Length", prefixLength));
            }
        }
        byteBuffer.position(offset);
        byte[] result = new byte[actualLength];
        byteBuffer.get(result);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return result;
    }

    public double getDouble(ByteBuffer buffer, int columnId) {
        double result = buffer.getDouble(this.offsets[columnId]);
        return result;
    }

    public float getFloat(ByteBuffer buffer, int columnId) {
        float result = buffer.getFloat(this.offsets[columnId]);
        return result;
    }

    public int getInt(ByteBuffer buffer, int columnId) {
        int value = buffer.getInt(this.offsets[columnId]);
        return Utility.getInt(this.storeColumns[columnId], value);
    }

    public long getLong(ByteBuffer buffer, int columnId) {
        long value = buffer.getLong(this.offsets[columnId]);
        return Utility.getLong(this.storeColumns[columnId], value);
    }

    public short getShort(ByteBuffer buffer, int columnId) {
        Column storeColumn = this.storeColumns[columnId];
        if (storeColumn.getLength() == 4) {
            return (short)buffer.getInt(this.offsets[columnId]);
        }
        return buffer.getShort(this.offsets[columnId]);
    }

    public String getString(ByteBuffer byteBuffer, int columnId, DbImpl.BufferManager bufferManager) {
        int actualLength;
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        Column storeColumn = this.storeColumns[columnId];
        int prefixLength = storeColumn.getPrefixLength();
        int offset = this.offsets[columnId];
        byteBuffer.limit(byteBuffer.capacity());
        switch (prefixLength) {
            case 0: {
                actualLength = this.lengths[columnId];
                break;
            }
            case 1: {
                actualLength = (byteBuffer.get(offset) + 256) % 256;
                ++offset;
                break;
            }
            case 2: {
                actualLength = (byteBuffer.get(offset) + 256) % 256;
                int length2 = (byteBuffer.get(offset + 1) + 256) % 256;
                actualLength += 256 * length2;
                offset += 2;
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Prefix_Length", prefixLength));
            }
        }
        byteBuffer.position(offset);
        byteBuffer.limit(offset + actualLength);
        String result = Utility.decode(byteBuffer, storeColumn.getCharsetNumber(), bufferManager);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return result;
    }

    public BigInteger getBigInteger(ByteBuffer byteBuffer, int columnId) {
        Column storeColumn = this.storeColumns[columnId];
        int index = storeColumn.getColumnId();
        int offset = this.offsets[index];
        int precision = storeColumn.getPrecision();
        int scale = storeColumn.getScale();
        int length = Utility.getDecimalColumnSpace(precision, scale);
        byteBuffer.position(offset);
        BigInteger result = Utility.getBigInteger(byteBuffer, length, precision, scale);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return result;
    }

    public BigInteger getBigInteger(ByteBuffer byteBuffer, Column storeColumn) {
        int index = storeColumn.getColumnId();
        int offset = this.offsets[index];
        int precision = storeColumn.getPrecision();
        int scale = storeColumn.getScale();
        int length = Utility.getDecimalColumnSpace(precision, scale);
        byteBuffer.position(offset);
        BigInteger result = Utility.getBigInteger(byteBuffer, length, precision, scale);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return result;
    }

    public BigDecimal getDecimal(ByteBuffer byteBuffer, int columnId) {
        Column storeColumn = this.storeColumns[columnId];
        int index = storeColumn.getColumnId();
        int offset = this.offsets[index];
        int precision = storeColumn.getPrecision();
        int scale = storeColumn.getScale();
        int length = Utility.getDecimalColumnSpace(precision, scale);
        byteBuffer.position(offset);
        BigDecimal result = Utility.getDecimal(byteBuffer, length, precision, scale);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return result;
    }

    public BigDecimal getDecimal(ByteBuffer byteBuffer, Column storeColumn) {
        int index = storeColumn.getColumnId();
        int offset = this.offsets[index];
        int precision = storeColumn.getPrecision();
        int scale = storeColumn.getScale();
        int length = Utility.getDecimalColumnSpace(precision, scale);
        byteBuffer.position(offset);
        BigDecimal result = Utility.getDecimal(byteBuffer, length, precision, scale);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return result;
    }

    public Boolean getObjectBoolean(ByteBuffer byteBuffer, int columnId) {
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        return this.getBoolean(byteBuffer, columnId);
    }

    public Boolean getObjectBoolean(ByteBuffer byteBuffer, Column storeColumn) {
        return this.getObjectBoolean(byteBuffer, storeColumn.getColumnId());
    }

    public Byte getObjectByte(ByteBuffer byteBuffer, int columnId) {
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        return this.getByte(byteBuffer, columnId);
    }

    public Byte getObjectByte(ByteBuffer byteBuffer, Column storeColumn) {
        return this.getObjectByte(byteBuffer, storeColumn.getColumnId());
    }

    public Float getObjectFloat(ByteBuffer byteBuffer, int columnId) {
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        return Float.valueOf(this.getFloat(byteBuffer, columnId));
    }

    public Float getObjectFloat(ByteBuffer byteBuffer, Column storeColumn) {
        return this.getObjectFloat(byteBuffer, storeColumn.getColumnId());
    }

    public Double getObjectDouble(ByteBuffer byteBuffer, int columnId) {
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        return this.getDouble(byteBuffer, columnId);
    }

    public Double getObjectDouble(ByteBuffer byteBuffer, Column storeColumn) {
        return this.getObjectDouble(byteBuffer, storeColumn.getColumnId());
    }

    public Integer getObjectInteger(ByteBuffer byteBuffer, int columnId) {
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        return this.getInt(byteBuffer, columnId);
    }

    public Integer getObjectInteger(ByteBuffer byteBuffer, Column storeColumn) {
        return this.getObjectInteger(byteBuffer, storeColumn.getColumnId());
    }

    public Long getObjectLong(ByteBuffer byteBuffer, int columnId) {
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        return this.getLong(byteBuffer, columnId);
    }

    public Long getObjectLong(ByteBuffer byteBuffer, Column storeColumn) {
        return this.getObjectLong(byteBuffer, storeColumn.getColumnId());
    }

    public Short getObjectShort(ByteBuffer byteBuffer, int columnId) {
        if (this.isNull(byteBuffer, columnId)) {
            return null;
        }
        return this.getShort(byteBuffer, columnId);
    }

    public Short getObjectShort(ByteBuffer byteBuffer, Column storeColumn) {
        return this.getObjectShort(byteBuffer, storeColumn.getColumnId());
    }

    public boolean isNull(ByteBuffer buffer, int columnId) {
        if (!this.storeColumns[columnId].getNullable()) {
            return false;
        }
        byte nullbyte = buffer.get(this.nullbitByteOffset[columnId]);
        boolean result = this.isSet(nullbyte, this.nullbitBitInByte[columnId]);
        return result;
    }

    public boolean isPresent(byte[] mask, int columnId) {
        byte present = mask[columnId / 8];
        return this.isSet(present, columnId % 8);
    }

    public void markPresent(byte[] mask, int columnId) {
        int offset = columnId / 8;
        byte bitMask = BIT_IN_BYTE_MASK[columnId % 8];
        int n = offset;
        mask[n] = (byte)(mask[n] | (byte)bitMask);
    }

    protected boolean isSet(byte test, int bitInByte) {
        byte mask = BIT_IN_BYTE_MASK[bitInByte];
        boolean result = (test & mask) != 0;
        return result;
    }

    protected static void handleError(Object object, NdbDictionary.Dictionary ndbDictionary) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbDictionary.getNdbError());
    }

    protected NdbRecord createNdbRecord(Index storeIndex, Table storeTable, NdbDictionary.Dictionary ndbDictionary) {
        String[] columnNames = storeIndex.getColumnNames();
        this.analyzeColumns(storeTable, columnNames);
        NdbRecord result = ndbDictionary.createRecord(this.indexConst, this.tableConst, this.recordSpecificationArray, columnNames.length, SIZEOF_RECORD_SPECIFICATION, 0);
        NdbDictionary.RecordSpecificationArray.delete(this.recordSpecificationArray);
        NdbRecordImpl.handleError(result, ndbDictionary);
        return result;
    }

    protected NdbRecord createNdbRecord(Table storeTable, NdbDictionary.Dictionary ndbDictionary) {
        String[] columnNames = storeTable.getColumnNames();
        this.analyzeColumns(storeTable, columnNames);
        NdbRecord result = ndbDictionary.createRecord(this.tableConst, (NdbDictionary.RecordSpecificationConstArray)this.recordSpecificationArray, columnNames.length, SIZEOF_RECORD_SPECIFICATION, 0);
        NdbDictionary.RecordSpecificationArray.delete(this.recordSpecificationArray);
        NdbRecordImpl.handleError(result, ndbDictionary);
        return result;
    }

    private void analyzeColumns(Table storeTable, String[] columnNames) {
        ArrayList<Column> align8 = new ArrayList<Column>();
        ArrayList<Column> align4 = new ArrayList<Column>();
        ArrayList<Column> align2 = new ArrayList<Column>();
        ArrayList<Column> align1 = new ArrayList<Column>();
        ArrayList<Column> nullables = new ArrayList<Column>();
        int i = 0;
        for (String columnName : columnNames) {
            Column storeColumn = storeTable.getColumn(columnName);
            int columnId = storeColumn.getColumnId();
            this.recordSpecificationIndexes[columnId] = i;
            if (logger.isDetailEnabled()) {
                logger.detail("storeColumn: " + storeColumn.getName() + " id: " + storeColumn.getColumnId() + " index: " + i);
            }
            this.lengths[i] = storeColumn.getLength();
            this.storeColumns[i++] = storeColumn;
            switch (storeColumn.getType()) {
                case Bigint: 
                case Bigunsigned: 
                case Bit: 
                case Blob: 
                case Date: 
                case Datetime: 
                case Double: 
                case Text: 
                case Time: 
                case Timestamp: {
                    align8.add(storeColumn);
                    break;
                }
                case Binary: 
                case Char: 
                case Decimal: 
                case Decimalunsigned: 
                case Longvarbinary: 
                case Longvarchar: 
                case Olddecimal: 
                case Olddecimalunsigned: 
                case Tinyint: 
                case Tinyunsigned: 
                case Varbinary: 
                case Varchar: {
                    align1.add(storeColumn);
                    break;
                }
                case Float: 
                case Int: 
                case Mediumint: 
                case Mediumunsigned: 
                case Unsigned: {
                    align4.add(storeColumn);
                    break;
                }
                case Smallint: 
                case Smallunsigned: 
                case Year: {
                    align2.add(storeColumn);
                    break;
                }
                case Undefined: {
                    throw new ClusterJFatalUserException(local.message("ERR_Unknown_Column_Type", new Object[]{storeTable.getName(), columnName, storeColumn.getType()}));
                }
                default: {
                    throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Column_Type", new Object[]{storeTable.getName(), columnName, storeColumn.getType()}));
                }
            }
            if (!storeColumn.getNullable()) continue;
            nullables.add(storeColumn);
        }
        this.offset = nullables.size() + 0;
        this.nullIndicatorSize = this.offset = (7 + this.offset) / 8 * 8;
        for (Column storeColumn : align8) {
            this.analyzeColumn(8, storeColumn);
        }
        for (Column storeColumn : align4) {
            this.analyzeColumn(4, storeColumn);
        }
        for (Column storeColumn : align2) {
            this.analyzeColumn(2, storeColumn);
        }
        for (Column storeColumn : align1) {
            this.analyzeColumn(1, storeColumn);
        }
        this.bufferSize = this.offset;
        if (logger.isDebugEnabled()) {
            logger.debug(this.dumpDefinition());
        }
    }

    private void analyzeColumn(int alignment, Column storeColumn) {
        int columnId = storeColumn.getColumnId();
        int recordSpecificationIndex = this.recordSpecificationIndexes[columnId];
        NdbDictionary.RecordSpecification recordSpecification = this.recordSpecificationArray.at(recordSpecificationIndex);
        NdbDictionary.ColumnConst columnConst = this.tableConst.getColumn(columnId);
        recordSpecification.column(columnConst);
        recordSpecification.offset(this.offset);
        this.offsets[columnId] = this.offset;
        int columnSpace = storeColumn.getColumnSpace();
        this.offset += columnSpace == 0 ? alignment : columnSpace;
        if (storeColumn.getNullable()) {
            int nullbitBitInByteValue;
            int nullbitByteOffsetValue = this.nullablePosition / 8;
            this.nullbitBitInByte[columnId] = nullbitBitInByteValue = this.nullablePosition - this.nullablePosition / 8 * 8;
            this.nullbitByteOffset[columnId] = nullbitByteOffsetValue;
            recordSpecification.nullbit_byte_offset(nullbitByteOffsetValue);
            recordSpecification.nullbit_bit_in_byte(nullbitBitInByteValue);
            ++this.nullablePosition;
        } else {
            recordSpecification.nullbit_byte_offset(0);
            recordSpecification.nullbit_bit_in_byte(0);
        }
    }

    private String dumpDefinition() {
        StringBuilder builder = new StringBuilder(this.tableConst.getName());
        builder.append(" numberOfColumns: ");
        builder.append(this.numberOfTableColumns);
        builder.append('\n');
        for (int columnId = 0; columnId < this.numberOfTableColumns; ++columnId) {
            Column storeColumn = this.storeColumns[columnId];
            if (storeColumn == null) continue;
            builder.append(" column: ");
            builder.append(storeColumn.getName());
            builder.append(" offset: ");
            builder.append(this.offsets[columnId]);
            builder.append(" length: ");
            builder.append(this.lengths[columnId]);
            builder.append(" nullbitBitInByte: ");
            builder.append(this.nullbitBitInByte[columnId]);
            builder.append(" nullbitByteOffset: ");
            builder.append(this.nullbitByteOffset[columnId]);
            builder.append('\n');
        }
        return builder.toString();
    }

    public String dumpValues(ByteBuffer data, byte[] mask) {
        StringBuilder builder = new StringBuilder(this.tableConst.getName());
        builder.append(" numberOfColumns: ");
        builder.append(this.numberOfTableColumns);
        builder.append('\n');
        for (int columnId = 0; columnId < this.numberOfTableColumns; ++columnId) {
            Column storeColumn = this.storeColumns[columnId];
            if (storeColumn == null) continue;
            builder.append(" column: ");
            builder.append(storeColumn.getName());
            builder.append(" offset: ");
            builder.append(this.offsets[columnId]);
            builder.append(" length: ");
            builder.append(this.lengths[columnId]);
            builder.append(" nullbitBitInByte: ");
            int nullBitInByte = this.nullbitBitInByte[columnId];
            builder.append(nullBitInByte);
            builder.append(" nullbitByteOffset: ");
            int nullByteOffset = this.nullbitByteOffset[columnId];
            builder.append(nullByteOffset);
            builder.append(" data: ");
            int size = storeColumn.getColumnSpace() != 0 ? storeColumn.getColumnSpace() : storeColumn.getSize();
            int offset = this.offsets[columnId];
            data.limit(this.bufferSize);
            data.position(0);
            for (int index = offset; index < offset + size; ++index) {
                builder.append(String.format("%2x ", data.get(index)));
            }
            builder.append(" null: ");
            builder.append(this.isNull(data, columnId));
            if (mask != null) {
                builder.append(" present: ");
                builder.append(this.isPresent(mask, columnId));
            }
            builder.append('\n');
        }
        data.position(0);
        return builder.toString();
    }

    NdbDictionary.TableConst getNdbTable(String tableName) {
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(tableName);
        if (ndbTable == null) {
            ndbTable = this.ndbDictionary.getTable(tableName.toLowerCase());
        }
        if (ndbTable == null) {
            Utility.throwError(ndbTable, this.ndbDictionary.getNdbError(), tableName);
        }
        return ndbTable;
    }

    NdbDictionary.TableConst getNdbTable() {
        return this.tableConst;
    }

    NdbDictionary.IndexConst getNdbIndex(String indexName, String tableName) {
        NdbDictionary.IndexConst ndbIndex = this.ndbDictionary.getIndex(indexName, tableName);
        if (ndbIndex == null) {
            Utility.throwError(ndbIndex, this.ndbDictionary.getNdbError(), tableName + "+" + indexName);
        }
        return ndbIndex;
    }

    NdbDictionary.IndexConst getNdbIndex() {
        return this.indexConst;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public NdbRecordConst getNdbRecord() {
        return this.ndbRecord;
    }

    public int getNumberOfColumns() {
        return this.numberOfTableColumns;
    }

    protected void releaseNdbRecord() {
        if (this.ndbRecord != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Releasing NdbRecord for " + this.tableConst.getName());
            }
            this.ndbDictionary.releaseRecord(this.ndbRecord);
            this.ndbRecord = null;
        }
    }

    public int getNullIndicatorSize() {
        return this.nullIndicatorSize;
    }

    public boolean isLob(int columnId) {
        return this.storeColumns[columnId].isLob();
    }
}

