/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Constants;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.core.SessionImpl;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerFactoryImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandlerFactory;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.ClusterConnection;
import com.mysql.clusterj.core.store.ClusterConnectionService;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFactoryImpl
implements SessionFactory,
Constants {
    static final I18NHelper local = I18NHelper.getInstance(SessionFactoryImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(SessionFactoryImpl.class);
    protected Map<?, ?> props;
    String CLUSTER_CONNECTION_SERVICE;
    String CLUSTER_CONNECT_STRING;
    int CLUSTER_CONNECT_RETRIES;
    int CLUSTER_CONNECT_DELAY;
    int CLUSTER_CONNECT_VERBOSE;
    int CLUSTER_CONNECT_TIMEOUT_BEFORE;
    int CLUSTER_CONNECT_TIMEOUT_AFTER;
    String CLUSTER_DATABASE;
    int CLUSTER_MAX_TRANSACTIONS;
    List<Integer> nodeIds;
    int connectionPoolSize;
    private static Map<Class<?>, Class<?>> proxyClassToDomainClass = new HashMap();
    protected static final Map<Class<?>, DomainTypeHandler<?>> typeToHandlerMap = new HashMap();
    DomainTypeHandlerFactory domainTypeHandlerFactory;
    protected static final Map<String, SessionFactoryImpl> sessionFactoryMap = new HashMap<String, SessionFactoryImpl>();
    final String key;
    private List<ClusterConnection> pooledConnections;
    protected ValueHandlerFactory smartValueHandlerFactory;

    protected ClusterConnectionService getClusterConnectionService() {
        return ClusterJHelper.getServiceInstance(ClusterConnectionService.class, this.CLUSTER_CONNECTION_SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionFactoryImpl getSessionFactory(Map<?, ?> props) {
        int connectionPoolSize = SessionFactoryImpl.getIntProperty(props, "com.mysql.clusterj.connection.pool.size", 1);
        String sessionFactoryKey = SessionFactoryImpl.getSessionFactoryKey(props);
        SessionFactoryImpl result = null;
        if (connectionPoolSize != 0) {
            Map<String, SessionFactoryImpl> map = sessionFactoryMap;
            synchronized (map) {
                result = sessionFactoryMap.get(sessionFactoryKey);
                if (result == null) {
                    result = new SessionFactoryImpl(props);
                    sessionFactoryMap.put(sessionFactoryKey, result);
                }
            }
        } else {
            result = new SessionFactoryImpl(props);
        }
        return result;
    }

    private static String getSessionFactoryKey(Map<?, ?> props) {
        String clusterConnectString = SessionFactoryImpl.getRequiredStringProperty(props, "com.mysql.clusterj.connectstring");
        String clusterDatabase = SessionFactoryImpl.getStringProperty(props, "com.mysql.clusterj.database", "test");
        return clusterConnectString + "+" + clusterDatabase;
    }

    protected SessionFactoryImpl(Map<?, ?> props) {
        block2: {
            this.nodeIds = new ArrayList<Integer>();
            this.domainTypeHandlerFactory = new DomainTypeHandlerFactoryImpl();
            this.pooledConnections = new ArrayList<ClusterConnection>();
            this.props = props;
            this.key = SessionFactoryImpl.getSessionFactoryKey(props);
            this.connectionPoolSize = SessionFactoryImpl.getIntProperty(props, "com.mysql.clusterj.connection.pool.size", 1);
            this.CLUSTER_CONNECT_STRING = SessionFactoryImpl.getRequiredStringProperty(props, "com.mysql.clusterj.connectstring");
            this.CLUSTER_CONNECT_RETRIES = SessionFactoryImpl.getIntProperty(props, "com.mysql.clusterj.connect.retries", 4);
            this.CLUSTER_CONNECT_DELAY = SessionFactoryImpl.getIntProperty(props, "com.mysql.clusterj.connect.delay", 5);
            this.CLUSTER_CONNECT_VERBOSE = SessionFactoryImpl.getIntProperty(props, "com.mysql.clusterj.connect.verbose", 0);
            this.CLUSTER_CONNECT_TIMEOUT_BEFORE = SessionFactoryImpl.getIntProperty(props, "com.mysql.clusterj.connect.timeout.before", 30);
            this.CLUSTER_CONNECT_TIMEOUT_AFTER = SessionFactoryImpl.getIntProperty(props, "com.mysql.clusterj.connect.timeout.after", 20);
            this.CLUSTER_DATABASE = SessionFactoryImpl.getStringProperty(props, "com.mysql.clusterj.database", "test");
            this.CLUSTER_MAX_TRANSACTIONS = SessionFactoryImpl.getIntProperty(props, "com.mysql.clusterj.max.transactions", 4);
            this.CLUSTER_CONNECTION_SERVICE = SessionFactoryImpl.getStringProperty(props, "com.mysql.clusterj.connection.service");
            this.createClusterConnectionPool();
            try {
                Session session = this.getSession(null);
                session.currentTransaction().begin();
                session.currentTransaction().commit();
                session.close();
            }
            catch (Exception e) {
                if (!(e instanceof ClusterJException)) break block2;
                logger.warn(local.message("ERR_Session_Factory_Impl_Failed_To_Complete_Transaction"));
                throw (ClusterJException)e;
            }
        }
    }

    protected void createClusterConnectionPool() {
        String nodeIdsProperty = SessionFactoryImpl.getStringProperty(this.props, "com.mysql.clusterj.connection.pool.nodeids");
        if (nodeIdsProperty != null) {
            String[] nodeIdsStringArray;
            for (String nodeIdString : nodeIdsStringArray = nodeIdsProperty.split("[,; \t\n\r]+", 48)) {
                try {
                    int nodeId = Integer.parseInt(nodeIdString);
                    this.nodeIds.add(nodeId);
                }
                catch (NumberFormatException ex) {
                    throw new ClusterJFatalUserException(local.message("ERR_Node_Ids_Format", (Object)nodeIdsProperty), ex);
                }
            }
            if (this.connectionPoolSize != 1) {
                if (this.nodeIds.size() == 1) {
                    for (int i = 1; i < this.connectionPoolSize; ++i) {
                        this.nodeIds.add(this.nodeIds.get(i - 1) + 1);
                    }
                }
                if (this.connectionPoolSize != this.nodeIds.size()) {
                    throw new ClusterJFatalUserException(local.message("ERR_Node_Ids_Must_Match_Connection_Pool_Size", (Object)nodeIdsProperty, (Object)this.connectionPoolSize));
                }
            } else {
                this.connectionPoolSize = this.nodeIds.size();
            }
        }
        ClusterConnectionService service = this.getClusterConnectionService();
        if (this.nodeIds.size() == 0) {
            for (int i = 0; i < this.connectionPoolSize; ++i) {
                this.createClusterConnection(service, this.props, 0);
            }
        } else {
            for (int i = 0; i < this.connectionPoolSize; ++i) {
                this.createClusterConnection(service, this.props, this.nodeIds.get(i));
            }
        }
        if (this.pooledConnections.size() != 0) {
            this.smartValueHandlerFactory = this.pooledConnections.get(0).getSmartValueHandlerFactory();
        }
    }

    protected ClusterConnection createClusterConnection(ClusterConnectionService service, Map<?, ?> props, int nodeId) {
        ClusterConnection result = null;
        try {
            result = service.create(this.CLUSTER_CONNECT_STRING, nodeId);
            result.connect(this.CLUSTER_CONNECT_RETRIES, this.CLUSTER_CONNECT_DELAY, true);
            result.waitUntilReady(this.CLUSTER_CONNECT_TIMEOUT_BEFORE, this.CLUSTER_CONNECT_TIMEOUT_AFTER);
        }
        catch (Exception ex) {
            for (ClusterConnection connection : this.pooledConnections) {
                connection.close();
            }
            this.pooledConnections.clear();
            throw new ClusterJFatalUserException(local.message("ERR_Connecting", (Object)props), ex);
        }
        this.pooledConnections.add(result);
        return result;
    }

    @Override
    public Session getSession() {
        return this.getSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(Map properties) {
        ClusterConnection clusterConnection = this.getClusterConnectionFromPool();
        try {
            Db db = null;
            SessionFactoryImpl sessionFactoryImpl = this;
            synchronized (sessionFactoryImpl) {
                this.checkConnection(clusterConnection);
                db = clusterConnection.createDb(this.CLUSTER_DATABASE, this.CLUSTER_MAX_TRANSACTIONS);
            }
            Dictionary dictionary = db.getDictionary();
            return new SessionImpl(this, properties, db, dictionary);
        }
        catch (ClusterJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ClusterJFatalException(local.message("ERR_Create_Ndb"), ex);
        }
    }

    private ClusterConnection getClusterConnectionFromPool() {
        if (this.connectionPoolSize <= 1) {
            return this.pooledConnections.get(0);
        }
        ClusterConnection result = null;
        int bestCount = Integer.MAX_VALUE;
        for (ClusterConnection pooledConnection : this.pooledConnections) {
            int count = pooledConnection.dbCount();
            if (count >= bestCount) continue;
            bestCount = count;
            result = pooledConnection;
        }
        return result;
    }

    private void checkConnection(ClusterConnection clusterConnection) {
        if (clusterConnection == null) {
            throw new ClusterJUserException(local.message("ERR_Session_Factory_Closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> DomainTypeHandler<T> getDomainTypeHandler(Class<T> cls) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            DomainTypeHandler<?> domainTypeHandler = typeToHandlerMap.get(cls);
            return domainTypeHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DomainTypeHandler<T> getDomainTypeHandler(Class<T> cls, Dictionary dictionary) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            DomainTypeHandler<Object> domainTypeHandler = typeToHandlerMap.get(cls);
            if (logger.isDetailEnabled()) {
                logger.detail("DomainTypeToHandler for " + cls.getName() + "(" + cls + ") returned " + domainTypeHandler);
            }
            if (domainTypeHandler == null) {
                domainTypeHandler = this.domainTypeHandlerFactory.createDomainTypeHandler(cls, dictionary, this.smartValueHandlerFactory);
                if (logger.isDetailEnabled()) {
                    logger.detail("createDomainTypeHandler for " + cls.getName() + "(" + cls + ") returned " + domainTypeHandler);
                }
                typeToHandlerMap.put(cls, domainTypeHandler);
                Class<Object> proxyClass = domainTypeHandler.getProxyClass();
                if (proxyClass != null) {
                    proxyClassToDomainClass.put(proxyClass, cls);
                }
            }
            return domainTypeHandler;
        }
    }

    public <T> DomainTypeHandler<T> getDomainTypeHandler(T object, Dictionary dictionary) {
        Class<T> cls = SessionFactoryImpl.getClassForProxy(object);
        DomainTypeHandler<T> result = SessionFactoryImpl.getDomainTypeHandler(cls);
        if (result != null) {
            return result;
        }
        return this.getDomainTypeHandler((T)cls, dictionary);
    }

    protected static <T> Class<T> getClassForProxy(T object) {
        Class<?> cls = object.getClass();
        if (cls.getName().startsWith("$Proxy")) {
            cls = proxyClassToDomainClass.get(cls);
        }
        return cls;
    }

    public <T> T newInstance(Class<T> cls, Dictionary dictionary, Db db) {
        DomainTypeHandler<Class<T>> domainTypeHandler = this.getDomainTypeHandler((T)cls, dictionary);
        return (T)domainTypeHandler.newInstance(db);
    }

    public Table getTable(String tableName, Dictionary dictionary) {
        Table result;
        try {
            result = dictionary.getTable(tableName);
        }
        catch (Exception ex) {
            throw new ClusterJFatalInternalException(local.message("ERR_Get_Table"), ex);
        }
        return result;
    }

    protected static String getStringProperty(Map<?, ?> props, String propertyName) {
        return (String)props.get(propertyName);
    }

    protected static String getStringProperty(Map<?, ?> props, String propertyName, String defaultValue) {
        String result = (String)props.get(propertyName);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    protected static String getRequiredStringProperty(Map<?, ?> props, String propertyName) {
        String result = (String)props.get(propertyName);
        if (result == null) {
            throw new ClusterJFatalUserException(local.message("ERR_NullProperty", (Object)propertyName));
        }
        return result;
    }

    protected static int getIntProperty(Map<?, ?> props, String propertyName, int defaultValue) {
        Object property = props.get(propertyName);
        if (property == null) {
            return defaultValue;
        }
        if (Number.class.isAssignableFrom(property.getClass())) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            try {
                int result = Integer.parseInt((String)property);
                return result;
            }
            catch (NumberFormatException ex) {
                throw new ClusterJFatalUserException(local.message("ERR_NumericFormat", (Object)propertyName, property));
            }
        }
        throw new ClusterJUserException(local.message("ERR_NumericFormat", (Object)propertyName, property));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        for (ClusterConnection clusterConnection : this.pooledConnections) {
            clusterConnection.close();
        }
        this.pooledConnections.clear();
        Map<String, SessionFactoryImpl> map = sessionFactoryMap;
        synchronized (map) {
            sessionFactoryMap.remove(this.key);
        }
    }

    public void setDomainTypeHandlerFactory(DomainTypeHandlerFactory domainTypeHandlerFactory) {
        this.domainTypeHandlerFactory = domainTypeHandlerFactory;
    }

    public DomainTypeHandlerFactory getDomainTypeHandlerFactory() {
        return this.domainTypeHandlerFactory;
    }

    public List<Integer> getConnectionPoolSessionCounts() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (ClusterConnection connection : this.pooledConnections) {
            result.add(connection.dbCount());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unloadSchema(Class<?> cls, Dictionary dictionary) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            String tableName = null;
            DomainTypeHandler<?> domainTypeHandler = typeToHandlerMap.remove(cls);
            if (domainTypeHandler != null && (tableName = domainTypeHandler.getTableName()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing dictionary entry for table " + tableName + " for class " + cls.getName());
                }
                dictionary.removeCachedTable(tableName);
            }
            for (ClusterConnection clusterConnection : this.pooledConnections) {
                clusterConnection.unloadSchema(tableName);
            }
            return tableName;
        }
    }
}

