/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.BinaryPK;

public class BinaryPKTest
extends AbstractClusterJTest {
    protected int NUMBER_OF_INSTANCES = 15;
    protected List<BinaryPK> instances = new ArrayList<BinaryPK>();

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(BinaryPK.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createInstances();
        this.addTearDownClasses(BinaryPK.class);
    }

    public void test() {
        this.insert();
        this.find();
        this.update();
        this.delete();
        this.failOnError();
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            byte[] key = this.getStoragePK(i);
            BinaryPK result = (BinaryPK)this.session.find(BinaryPK.class, (Object)key);
            this.verifyResult("find ", result, i, false);
        }
    }

    protected void update() {
        int i;
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 4) continue;
            BinaryPK instance = this.createInstance(i);
            instance.setName(this.getValue(this.NUMBER_OF_INSTANCES - i));
            this.session.updatePersistent((Object)instance);
            this.verifyStorage("update ", instance, i, true);
        }
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 4) continue;
            byte[] key = this.getStoragePK(i);
            BinaryPK instance = (BinaryPK)this.session.find(BinaryPK.class, (Object)key);
            this.verifyResult("update verify ", instance, i, true);
        }
    }

    protected void delete() {
        int i;
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 5) continue;
            BinaryPK instance = this.createInstance(i);
            this.session.deletePersistent((Object)instance);
        }
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 5) continue;
            byte[] key = this.getStoragePK(i);
            BinaryPK instance = (BinaryPK)this.session.find(BinaryPK.class, (Object)key);
            this.errorIfNotEqual("Failed to delete instance: " + i, null, instance);
        }
    }

    protected void createInstances() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            BinaryPK instance = this.createInstance(i);
            if (this.getDebug()) {
                System.out.println(this.toString(instance));
            }
            this.instances.add(instance);
        }
    }

    protected BinaryPK createInstance(int index) {
        BinaryPK instance = (BinaryPK)this.session.newInstance(BinaryPK.class);
        instance.setId(this.getStoragePK(index));
        instance.setNumber(index);
        instance.setName(this.getValue(index));
        return instance;
    }

    protected String toString(BinaryPK instance) {
        StringBuffer result = new StringBuffer();
        result.append("BinaryPK[");
        result.append(this.toString(instance.getId()));
        result.append("]: ");
        result.append(instance.getNumber());
        result.append(", \"");
        result.append(instance.getName());
        result.append("\".");
        return result.toString();
    }

    protected byte[] getStoragePK(int index) {
        return new byte[]{0, (byte)(index / 256 + 65), (byte)(index % 256 + 65)};
    }

    protected byte[] getResultPK(int index) {
        byte[] result = new byte[255];
        result[1] = (byte)(index / 256 + 65);
        result[2] = (byte)(index % 256 + 65);
        return result;
    }

    protected String getValue(int index) {
        return "Value " + index;
    }

    protected void verifyStorage(String where, BinaryPK instance, int index, boolean updated) {
        this.errorIfNotEqual(where + "mismatch on number", index, instance.getNumber());
        if (updated) {
            this.errorIfNotEqual(where + "mismatch on name", this.getValue(this.NUMBER_OF_INSTANCES - index), instance.getName());
        } else {
            this.errorIfNotEqual(where + "mismatch on name", this.getValue(index), instance.getName());
        }
    }

    protected void verifyResult(String where, BinaryPK instance, int index, boolean updated) {
        this.errorIfNotEqual(where + "mismatch on id", this.toString(this.getResultPK(index)), this.toString(instance.getId()));
        this.errorIfNotEqual("mismatch on number", index, instance.getNumber());
        if (updated) {
            this.errorIfNotEqual(where + "mismatch on name", this.getValue(this.NUMBER_OF_INSTANCES - index), instance.getName());
        } else {
            this.errorIfNotEqual(where + "mismatch on name", this.getValue(index), instance.getName());
        }
    }

    private String toString(byte[] id) {
        if (id == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < id.length; ++i) {
            builder.append(String.valueOf(id[i]));
            builder.append('-');
        }
        return builder.toString();
    }
}

