/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.DynamicObject;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class LoadTest
extends AbstractClusterJModelTest {
    private static final String tablename = "t_basic";
    private static final int NUMBER_TO_INSERT = 3;
    List<DynamicEmployee> loaded = new ArrayList<DynamicEmployee>();

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(3);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(DynamicEmployee.class);
        this.tx.commit();
    }

    public void test() {
        this.foundIllegalType();
        this.foundNull();
        this.create();
        this.findFound();
        this.findFoundAutocommit();
        this.load();
        this.loadAutocommit();
        this.loadNoFlush();
        this.loadNotFound();
        this.loadFindNoFlush();
        this.failOnError();
    }

    private void create() {
        this.tx = this.session.currentTransaction();
        int count = 0;
        for (int i = 0; i < 3; ++i) {
            this.session.makePersistent(this.employees.get(i));
            ++count;
        }
    }

    private void load() {
        DynamicEmployee e;
        int i;
        this.loaded.clear();
        this.tx.begin();
        for (i = 0; i < 3; ++i) {
            e = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)i));
            this.errorIfNotEqual("load after create new employee id mismatch", i, e.getId());
            this.errorIfNotEqual("load before load found mismatch", null, this.session.found((Object)e));
            this.session.load((Object)e);
            this.errorIfNotEqual("load after load newInstance employee id mismatch", i, e.getId());
            this.errorIfNotEqual("load after load found mismatch", null, this.session.found((Object)e));
            this.loaded.add(e);
        }
        this.session.flush();
        for (i = 0; i < 3; ++i) {
            e = this.loaded.get(i);
            this.errorIfNotEqual("load after flush found mismatch", true, this.session.found((Object)e));
            this.errorIfNotEqual("load after flush employee id mismatch", i, e.getId());
            this.consistencyCheckDynamicEmployee("load after flush", e);
        }
        this.tx.commit();
    }

    private void loadFindNoFlush() {
        DynamicEmployee e;
        int i;
        this.loaded.clear();
        this.tx.begin();
        for (i = 0; i < 3; ++i) {
            e = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)i));
            this.errorIfNotEqual("loadFindNoFlush after newInstance employee id mismatch", i, e.getId());
            this.errorIfNotEqual("loadFindNoFlush after newInstance found mismatch", null, this.session.found((Object)e));
            this.session.load((Object)e);
            this.errorIfNotEqual("loadFindNoFlush after load employee id mismatch", i, e.getId());
            this.errorIfNotEqual("loadFindNoFlush after load found mismatch", null, this.session.found((Object)e));
            this.loaded.add(e);
        }
        this.session.find(Employee.class, (Object)0);
        for (i = 0; i < 3; ++i) {
            e = this.loaded.get(i);
            this.errorIfNotEqual("loadFindNoFlush after find found mismatch", true, this.session.found((Object)e));
            this.errorIfNotEqual("loadFindNoFlush after find employee id mismatch", i, e.getId());
            this.consistencyCheckDynamicEmployee("loadFindNoFlush", e);
        }
        this.tx.commit();
    }

    private void consistencyCheckDynamicEmployee(String where, DynamicEmployee e) {
        int id = e.getId();
        String name = e.getName();
        this.errorIfNotEqual(where + " consistencyCheckDynamicEmployee name mismatch", "Employee number " + id, name);
        this.errorIfNotEqual(where + " consistencyCheckDynamicEmployee age mismatch", id, e.getAge());
        this.errorIfNotEqual(where + " consistencyCheckDynamicEmployee magic mismatch", id, e.getMagic());
    }

    private void loadNoFlush() {
        this.loaded.clear();
        this.tx.begin();
        DynamicEmployee e = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)0));
        this.errorIfNotEqual("loadNoFlush after newInstance employee id mismatch", 0, e.getId());
        this.errorIfNotEqual("loadNoFlush after newInstance employee name mismatch", null, e.getName());
        this.session.load((Object)e);
        this.errorIfNotEqual("loadNoFlush after load employee id mismatch", 0, e.getId());
        this.errorIfNotEqual("loadNoFlush after load employee name mismatch", null, e.getName());
        this.tx.commit();
    }

    private void loadAutocommit() {
        DynamicEmployee e = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)0));
        try {
            this.session.load((Object)e);
            this.error("loadAutocommit expected exception not thrown: a transaction must be in progress for load.");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
    }

    private void loadNotFound() {
        this.tx.begin();
        DynamicEmployee e = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)10000));
        this.session.load((Object)e);
        this.errorIfNotEqual("loadNotFound dynamic after load found mismatch", null, this.session.found((Object)e));
        this.session.flush();
        this.errorIfNotEqual("loadNotFound dynamic after flush found mismatch", false, this.session.found((Object)e));
        this.tx.commit();
    }

    private void findFound() {
        this.tx.begin();
        DynamicEmployee e = (DynamicEmployee)((Object)this.session.find(DynamicEmployee.class, (Object)0));
        this.errorIfNotEqual("findFound dynamic existing found mismatch", true, this.session.found((Object)e));
        Employee emp = (Employee)this.session.find(Employee.class, (Object)0);
        this.errorIfNotEqual("findFound existing found mismatch", true, this.session.found((Object)emp));
        this.tx.commit();
    }

    private void findFoundAutocommit() {
        DynamicEmployee e = (DynamicEmployee)((Object)this.session.find(DynamicEmployee.class, (Object)0));
        this.errorIfNotEqual("findFoundAutocommit dynamic existing found mismatch", true, this.session.found((Object)e));
        Employee emp = (Employee)this.session.find(Employee.class, (Object)0);
        this.errorIfNotEqual("findFoundAutocommit existing found mismatch", true, this.session.found((Object)emp));
    }

    private void foundIllegalType() {
        try {
            this.session.found((Object)0);
            this.error("foundIllegalType expected exception not thrown: ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
    }

    private void foundNull() {
        this.errorIfNotEqual("foundNull found mismatch", null, this.session.found(null));
    }

    public static class DynamicEmployee
    extends DynamicObject {
        public String table() {
            return LoadTest.tablename;
        }

        public int getId() {
            return (Integer)this.get(0);
        }

        public String getName() {
            return (String)this.get(1);
        }

        public int getAge() {
            return (Integer)this.get(2);
        }

        public int getMagic() {
            return (Integer)this.get(3);
        }
    }
}

