/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.LockMode;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.IndexOperationImpl;
import com.mysql.clusterj.tie.IndexScanOperationImpl;
import com.mysql.clusterj.tie.NdbRecordDeleteOperationImpl;
import com.mysql.clusterj.tie.NdbRecordImpl;
import com.mysql.clusterj.tie.NdbRecordIndexScanOperationImpl;
import com.mysql.clusterj.tie.NdbRecordInsertOperationImpl;
import com.mysql.clusterj.tie.NdbRecordKeyOperationImpl;
import com.mysql.clusterj.tie.NdbRecordTableScanOperationImpl;
import com.mysql.clusterj.tie.NdbRecordUniqueKeyOperationImpl;
import com.mysql.clusterj.tie.OperationImpl;
import com.mysql.clusterj.tie.PartitionKeyImpl;
import com.mysql.clusterj.tie.ScanOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbIndexOperation;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import com.mysql.ndbjtie.ndbapi.NdbRecordConst;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class ClusterTransactionImpl
implements ClusterTransaction {
    static final I18NHelper local = I18NHelper.getInstance(ClusterTransactionImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ClusterTransactionImpl.class);
    protected static final String USE_NDBRECORD_NAME = "com.mysql.clusterj.UseNdbRecord";
    private static boolean USE_NDBRECORD = ClusterJHelper.getBooleanProperty("com.mysql.clusterj.UseNdbRecord", "true");
    protected NdbTransaction ndbTransaction;
    private List<Runnable> postExecuteCallbacks = new ArrayList<Runnable>();
    protected ClusterConnectionImpl clusterConnectionImpl;
    protected DbImpl db;
    protected PartitionKeyImpl partitionKey = PartitionKeyImpl.getInstance();
    private NdbDictionary.Dictionary ndbDictionary;
    private String coordinatedTransactionId = null;
    private static boolean supportsGetCoordinatedTransactionId = true;
    private int findLockMode = 2;
    private int lookupLockMode = 2;
    private int indexScanLockMode = 2;
    private int tableScanLockMode = 2;
    private boolean autocommit = false;
    private boolean autocommitted = false;
    private String joinTransactionId;
    private DbImpl.BufferManager bufferManager;
    private List<Operation> operationsToCheck = new ArrayList<Operation>();

    public ClusterTransactionImpl(ClusterConnectionImpl clusterConnectionImpl, DbImpl db, NdbDictionary.Dictionary ndbDictionary, String joinTransactionId) {
        this.db = db;
        this.clusterConnectionImpl = clusterConnectionImpl;
        this.ndbDictionary = ndbDictionary;
        this.joinTransactionId = joinTransactionId;
        this.bufferManager = db.getBufferManager();
    }

    public void close() {
        if (this.ndbTransaction != null) {
            this.ndbTransaction.close();
            this.ndbTransaction = null;
        }
    }

    public void executeCommit() {
        this.executeCommit(true, true);
    }

    public boolean isEnlisted() {
        return this.ndbTransaction != null;
    }

    private void enlist() {
        if (logger.isTraceEnabled()) {
            logger.trace("ndbTransaction: " + this.ndbTransaction + " with joinTransactionId: " + this.joinTransactionId);
        }
        if (this.ndbTransaction == null) {
            if (this.coordinatedTransactionId != null) {
                this.ndbTransaction = this.db.joinTransaction(this.coordinatedTransactionId);
            } else {
                this.ndbTransaction = this.partitionKey.enlist(this.db);
                this.getCoordinatedTransactionId(this.db);
            }
        }
    }

    public void executeCommit(boolean abort, boolean force) {
        if (logger.isTraceEnabled()) {
            logger.trace("");
        }
        if (this.isEnlisted() && !this.autocommitted) {
            this.handlePendingPostExecuteCallbacks();
            int abortOption = abort ? 0 : 2;
            int forceOption = force ? 1 : 0;
            int returnCode = this.ndbTransaction.execute(2, abortOption, forceOption);
            this.handleError(returnCode, this.ndbTransaction);
        }
        this.autocommitted = false;
        this.autocommit = false;
    }

    public void executeNoCommit() {
        this.executeNoCommit(true, true);
    }

    public void executeNoCommit(boolean abort, boolean force) {
        if (logger.isTraceEnabled()) {
            logger.trace("");
        }
        if (!this.isEnlisted()) {
            return;
        }
        if (this.autocommit && this.postExecuteCallbacks.size() == 0) {
            this.executeCommit(abort, force);
            this.autocommitted = true;
            return;
        }
        int abortOption = abort ? 0 : 2;
        int forceOption = force ? 1 : 0;
        int returnCode = this.ndbTransaction.execute(1, abortOption, forceOption);
        this.handleError(returnCode, this.ndbTransaction);
        this.performPostExecuteCallbacks();
    }

    public void executeRollback() {
        if (!this.isEnlisted()) {
            return;
        }
        int abortOption = 2;
        int forceOption = 1;
        int returnCode = this.ndbTransaction.execute(3, abortOption, forceOption);
        this.handleError(returnCode, this.ndbTransaction);
    }

    public Operation getDeleteOperation(Table storeTable) {
        this.enlist();
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName());
        }
        if (USE_NDBRECORD) {
            return new NdbRecordDeleteOperationImpl(this, storeTable);
        }
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(storeTable.getName());
        this.handleError((Object)ndbTable, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(ndbTable);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int returnCode = ndbOperation.deleteTuple();
        this.handleError(returnCode, this.ndbTransaction);
        return new OperationImpl(ndbOperation, this);
    }

    public Operation getInsertOperation(Table storeTable) {
        this.enlist();
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName());
        }
        if (USE_NDBRECORD) {
            return new NdbRecordInsertOperationImpl(this, storeTable);
        }
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(storeTable.getName());
        this.handleError((Object)ndbTable, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(ndbTable);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int returnCode = ndbOperation.insertTuple();
        this.handleError(returnCode, this.ndbTransaction);
        return new OperationImpl(ndbOperation, this);
    }

    public IndexScanOperation getIndexScanOperation(Index storeIndex, Table storeTable) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordIndexScanOperationImpl(this, storeIndex, storeTable, this.indexScanLockMode);
        }
        NdbDictionary.IndexConst ndbIndex = this.ndbDictionary.getIndex(storeIndex.getInternalName(), storeTable.getName());
        this.handleError((Object)ndbIndex, this.ndbDictionary);
        NdbIndexScanOperation ndbOperation = this.ndbTransaction.getNdbIndexScanOperation(ndbIndex);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int scanFlags = 0;
        int lockMode = this.indexScanLockMode;
        if (lockMode != 2) {
            scanFlags = 1;
        }
        int parallel = 0;
        int batch = 0;
        int returnCode = ndbOperation.readTuples(lockMode, scanFlags, parallel, batch);
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName() + " index: " + storeIndex.getName());
        }
        return new IndexScanOperationImpl(storeTable, ndbOperation, this);
    }

    public IndexScanOperation getIndexScanOperationMultiRange(Index storeIndex, Table storeTable) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordIndexScanOperationImpl(this, storeIndex, storeTable, true, this.indexScanLockMode);
        }
        NdbDictionary.IndexConst ndbIndex = this.ndbDictionary.getIndex(storeIndex.getInternalName(), storeTable.getName());
        this.handleError((Object)ndbIndex, this.ndbDictionary);
        NdbIndexScanOperation ndbOperation = this.ndbTransaction.getNdbIndexScanOperation(ndbIndex);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int scanFlags = 0x1000000;
        int lockMode = this.indexScanLockMode;
        if (lockMode != 2) {
            scanFlags |= 1;
        }
        int parallel = 0;
        int batch = 0;
        int returnCode = ndbOperation.readTuples(lockMode, scanFlags |= 0x8000000, parallel, batch);
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName() + " index: " + storeIndex.getName());
        }
        return new IndexScanOperationImpl(storeTable, ndbOperation, this);
    }

    public IndexScanOperation getIndexScanOperationLockModeExclusiveScanFlagKeyInfo(Index storeIndex, Table storeTable) {
        this.enlist();
        NdbDictionary.IndexConst ndbIndex = this.ndbDictionary.getIndex(storeIndex.getInternalName(), storeTable.getName());
        this.handleError((Object)ndbIndex, this.ndbDictionary);
        NdbIndexScanOperation ndbOperation = this.ndbTransaction.getNdbIndexScanOperation(ndbIndex);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int lockMode = 1;
        int scanFlags = 1;
        int parallel = 0;
        int batch = 0;
        int returnCode = ndbOperation.readTuples(lockMode, scanFlags, parallel, batch);
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName() + " index: " + storeIndex.getName());
        }
        return new IndexScanOperationImpl(storeTable, ndbOperation, this);
    }

    public Operation getSelectOperation(Table storeTable) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordKeyOperationImpl(this, storeTable);
        }
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(storeTable.getName());
        this.handleError((Object)ndbTable, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(ndbTable);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int lockMode = this.findLockMode;
        int returnCode = ndbOperation.readTuple(lockMode);
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName());
        }
        return new OperationImpl(storeTable, ndbOperation, this);
    }

    public ScanOperation getTableScanOperation(Table storeTable) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordTableScanOperationImpl(this, storeTable, this.tableScanLockMode);
        }
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(storeTable.getName());
        this.handleError((Object)ndbTable, this.ndbDictionary);
        NdbScanOperation ndbScanOperation = this.ndbTransaction.getNdbScanOperation(ndbTable);
        this.handleError((Object)ndbScanOperation, this.ndbTransaction);
        int lockMode = this.tableScanLockMode;
        int scanFlags = 0;
        if (lockMode != 2) {
            scanFlags = 1;
        }
        int parallel = 0;
        int batch = 0;
        int returnCode = ndbScanOperation.readTuples(lockMode, scanFlags, parallel, batch);
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName());
        }
        return new ScanOperationImpl(storeTable, ndbScanOperation, this);
    }

    public ScanOperation getTableScanOperationLockModeExclusiveScanFlagKeyInfo(Table storeTable) {
        this.enlist();
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(storeTable.getName());
        this.handleError((Object)ndbTable, this.ndbDictionary);
        NdbScanOperation ndbScanOperation = this.ndbTransaction.getNdbScanOperation(ndbTable);
        this.handleError((Object)ndbScanOperation, this.ndbTransaction);
        int lockMode = 1;
        int scanFlags = 1;
        int parallel = 0;
        int batch = 0;
        int returnCode = ndbScanOperation.readTuples(lockMode, scanFlags, parallel, batch);
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName());
        }
        return new ScanOperationImpl(storeTable, ndbScanOperation, this);
    }

    public IndexOperation getUniqueIndexOperation(Index storeIndex, Table storeTable) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordUniqueKeyOperationImpl(this, storeIndex, storeTable);
        }
        NdbDictionary.IndexConst ndbIndex = this.ndbDictionary.getIndex(storeIndex.getInternalName(), storeTable.getName());
        this.handleError((Object)ndbIndex, this.ndbDictionary);
        NdbIndexOperation ndbIndexOperation = this.ndbTransaction.getNdbIndexOperation(ndbIndex);
        this.handleError((Object)ndbIndexOperation, this.ndbTransaction);
        int lockMode = this.lookupLockMode;
        int returnCode = ndbIndexOperation.readTuple(lockMode);
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName() + " index: " + storeIndex.getName());
        }
        return new IndexOperationImpl(storeTable, ndbIndexOperation, this);
    }

    public IndexOperation getUniqueIndexDeleteOperation(Index storeIndex, Table storeTable) {
        this.enlist();
        NdbDictionary.IndexConst ndbIndex = this.ndbDictionary.getIndex(storeIndex.getInternalName(), storeTable.getName());
        this.handleError((Object)ndbIndex, this.ndbDictionary);
        NdbIndexOperation ndbIndexOperation = this.ndbTransaction.getNdbIndexOperation(ndbIndex);
        this.handleError((Object)ndbIndexOperation, this.ndbTransaction);
        int returnCode = ndbIndexOperation.deleteTuple();
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName() + " index: " + storeIndex.getName());
        }
        return new IndexOperationImpl(storeTable, ndbIndexOperation, this);
    }

    public Operation getUpdateOperation(Table storeTable) {
        this.enlist();
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(storeTable.getName());
        this.handleError((Object)ndbTable, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(ndbTable);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int returnCode = ndbOperation.updateTuple();
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName());
        }
        return new OperationImpl(storeTable, ndbOperation, this);
    }

    public IndexOperation getUniqueIndexUpdateOperation(Index storeIndex, Table storeTable) {
        this.enlist();
        NdbDictionary.IndexConst ndbIndex = this.ndbDictionary.getIndex(storeIndex.getInternalName(), storeTable.getName());
        this.handleError((Object)ndbIndex, this.ndbDictionary);
        NdbIndexOperation ndbIndexOperation = this.ndbTransaction.getNdbIndexOperation(ndbIndex);
        this.handleError((Object)ndbIndexOperation, this.ndbTransaction);
        int returnCode = ndbIndexOperation.updateTuple();
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName() + " index: " + storeIndex.getName());
        }
        return new IndexOperationImpl(storeTable, ndbIndexOperation, this);
    }

    public Operation getWriteOperation(Table storeTable) {
        this.enlist();
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(storeTable.getName());
        this.handleError((Object)ndbTable, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(ndbTable);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int returnCode = ndbOperation.writeTuple();
        this.handleError(returnCode, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + storeTable.getName());
        }
        return new OperationImpl(storeTable, ndbOperation, this);
    }

    public NdbOperationConst insertTuple(NdbRecordConst ndbRecord, ByteBuffer buffer, byte[] mask, NdbOperation.OperationOptionsConst options) {
        this.enlist();
        NdbOperationConst operation = this.ndbTransaction.insertTuple(ndbRecord, buffer, mask, options, 0);
        this.handleError((Object)operation, this.ndbTransaction);
        return operation;
    }

    public NdbScanOperation scanTable(NdbRecordConst ndbRecord, byte[] mask, NdbScanOperation.ScanOptionsConst options) {
        this.enlist();
        int lockMode = this.tableScanLockMode;
        NdbScanOperation operation = this.ndbTransaction.scanTable(ndbRecord, lockMode, mask, options, 0);
        this.handleError((Object)operation, this.ndbTransaction);
        return operation;
    }

    public NdbIndexScanOperation scanIndex(NdbRecordConst key_record, NdbRecordConst result_record, byte[] result_mask, NdbScanOperation.ScanOptions scanOptions) {
        return this.ndbTransaction.scanIndex(key_record, result_record, this.indexScanLockMode, result_mask, null, scanOptions, 0);
    }

    public NdbOperationConst deleteTuple(NdbRecordConst ndbRecord, ByteBuffer buffer, byte[] mask, NdbOperation.OperationOptionsConst options) {
        this.enlist();
        NdbOperationConst operation = this.ndbTransaction.deleteTuple(ndbRecord, buffer, ndbRecord, null, mask, options, 0);
        this.handleError((Object)operation, this.ndbTransaction);
        return operation;
    }

    public NdbOperationConst updateTuple(NdbRecordConst ndbRecord, ByteBuffer buffer, byte[] mask, NdbOperation.OperationOptionsConst options) {
        this.enlist();
        NdbOperationConst operation = this.ndbTransaction.updateTuple(ndbRecord, buffer, ndbRecord, buffer, mask, options, 0);
        this.handleError((Object)operation, this.ndbTransaction);
        return operation;
    }

    public NdbOperationConst writeTuple(NdbRecordConst ndbRecord, ByteBuffer buffer, byte[] mask, NdbOperation.OperationOptionsConst options) {
        this.enlist();
        NdbOperationConst operation = this.ndbTransaction.writeTuple(ndbRecord, buffer, ndbRecord, buffer, mask, options, 0);
        this.handleError((Object)operation, this.ndbTransaction);
        return operation;
    }

    public NdbOperationConst readTuple(NdbRecordConst ndbRecordKeys, ByteBuffer keyBuffer, NdbRecordConst ndbRecordValues, ByteBuffer valueBuffer, byte[] mask, NdbOperation.OperationOptionsConst options) {
        this.enlist();
        NdbOperationConst operation = this.ndbTransaction.readTuple(ndbRecordKeys, keyBuffer, ndbRecordValues, valueBuffer, this.findLockMode, mask, options, 0);
        this.handleError((Object)operation, this.ndbTransaction);
        return operation;
    }

    public void postExecuteCallback(Runnable callback) {
        this.postExecuteCallbacks.add(callback);
    }

    private void clearPostExecuteCallbacks() {
        this.postExecuteCallbacks.clear();
    }

    private void handlePendingPostExecuteCallbacks() {
        if (!this.postExecuteCallbacks.isEmpty()) {
            this.executeNoCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPostExecuteCallbacks() {
        StringBuilder exceptionMessages = new StringBuilder();
        for (Operation op : this.operationsToCheck) {
            int code = op.getErrorCode();
            if (code == 0) continue;
            int mysqlCode = op.getMysqlCode();
            int status = op.getStatus();
            int classification = op.getClassification();
            String message = local.message("ERR_Datastore", -1, code, mysqlCode, status, classification, op.toString());
            exceptionMessages.append(message);
            exceptionMessages.append('\n');
        }
        this.operationsToCheck.clear();
        try {
            for (Runnable runnable : this.postExecuteCallbacks) {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    exceptionMessages.append(t.getMessage());
                    exceptionMessages.append('\n');
                }
            }
        }
        finally {
            this.clearPostExecuteCallbacks();
        }
        if (exceptionMessages.length() > 0) {
            throw new ClusterJDatastoreException(exceptionMessages.toString());
        }
    }

    protected void handleError(int returnCode) {
        if (returnCode == -1) {
            NdbErrorConst ndbError = this.ndbTransaction.getNdbError();
            String detail = this.db.getNdbErrorDetail(ndbError);
            Utility.throwError(returnCode, ndbError, detail);
        }
    }

    protected void handleError(int returnCode, NdbTransaction ndbTransaction) {
        if (returnCode == 0) {
            return;
        }
        NdbErrorConst ndbError = ndbTransaction.getNdbError();
        if (ndbError.code() == 0) {
            return;
        }
        String detail = this.db.getNdbErrorDetail(ndbError);
        Utility.throwError(returnCode, ndbError, detail);
    }

    protected void handleError(Object object, NdbTransaction ndbTransaction) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbError = ndbTransaction.getNdbError();
        String detail = this.db.getNdbErrorDetail(ndbError);
        Utility.throwError(null, ndbError, detail);
    }

    protected void handleError(Object object, NdbDictionary.Dictionary ndbDictionary) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbError = ndbDictionary.getNdbError();
        String detail = this.db.getNdbErrorDetail(ndbError);
        Utility.throwError(null, ndbError, detail);
    }

    public void setPartitionKey(PartitionKey partitionKey) {
        if (partitionKey == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Partition_Key_Null"));
        }
        this.partitionKey = (PartitionKeyImpl)partitionKey;
    }

    public String getCoordinatedTransactionId() {
        return this.coordinatedTransactionId;
    }

    private void getCoordinatedTransactionId(DbImpl db) {
        try {
            if (supportsGetCoordinatedTransactionId) {
                if (logger.isDetailEnabled()) {
                    logger.detail("CoordinatedTransactionId: " + this.coordinatedTransactionId);
                }
                throw new ClusterJFatalInternalException("Not Implemented");
            }
        }
        catch (Throwable t) {
            supportsGetCoordinatedTransactionId = false;
        }
    }

    public void setCoordinatedTransactionId(String coordinatedTransactionId) {
        this.coordinatedTransactionId = coordinatedTransactionId;
    }

    public void setLockMode(LockMode lockmode) {
        this.lookupLockMode = this.findLockMode = this.translateLockMode(lockmode);
        this.indexScanLockMode = this.findLockMode;
        this.tableScanLockMode = this.findLockMode;
    }

    private int translateLockMode(LockMode lockmode) {
        switch (lockmode) {
            case READ_COMMITTED: {
                return 2;
            }
            case SHARED: {
                return 0;
            }
            case EXCLUSIVE: {
                return 1;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Lock_Mode", (Object)lockmode));
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public DbImpl.BufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected NdbRecordImpl getCachedNdbRecordImpl(Table storeTable) {
        return this.clusterConnectionImpl.getCachedNdbRecordImpl(storeTable);
    }

    protected NdbRecordImpl getCachedNdbRecordImpl(Index storeIndex, Table storeTable) {
        return this.clusterConnectionImpl.getCachedNdbRecordImpl(storeIndex, storeTable);
    }

    public void addOperationToCheck(Operation op) {
        this.operationsToCheck.add(op);
    }
}

