/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public abstract class TestCase
implements Test {
    public String name;
    public Method method;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TestResult result) {
        TestListener listener = result.listener;
        listener.startTest(this);
        try {
            this.setUp();
            try {
                this.method.invoke((Object)this, new Object[0]);
                result.successes.add(this.name);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof AssertionFailedError) {
                    result.failures.add(this.name);
                    listener.addFailure(this, (AssertionFailedError)((Object)t));
                } else {
                    result.throwables.add(t);
                    listener.addError(this, t);
                }
            }
            finally {
                this.tearDown();
            }
        }
        catch (Throwable t) {
            result.throwables.add(t);
            listener.addError(this, t);
        }
        listener.endTest(this);
    }

    public static void fail(String message) {
        throw new AssertionFailedError(message);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public int countTestCases() {
        return 0;
    }

    public String toString() {
        return this.method.getDeclaringClass().getPackage().getName() + "." + this.name;
    }
}

