/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionServiceImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.ndbjtie.mysql.CharsetMap;
import com.mysql.ndbjtie.mysql.Utils;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbRecAttr;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Utility {
    static final I18NHelper local;
    static final Logger logger;
    static CharsetEncoder charsetEncoder;
    static CharsetDecoder charsetDecoder;
    static final long ooooooooooooooff = 255L;
    static final long ooooooooooooffoo = 65280L;
    static final long ooooooooooffoooo = 0xFF0000L;
    static final long ooooooooffoooooo = 0xFF000000L;
    static final long ooooooffoooooooo = 0xFF00000000L;
    static final long ooooffoooooooooo = 0xFF0000000000L;
    static final long ooffoooooooooooo = 0xFF000000000000L;
    static final long ffoooooooooooooo = -72057594037927936L;
    static final long ooooooooffffffff = 0xFFFFFFFFL;
    static final int ooooooff = 255;
    static final int ooooffff = 65535;
    static final int ooooffoo = 65280;
    static final int ooffoooo = 0xFF0000;
    static final int ooffffff = 0xFFFFFF;
    static final char[] SPACE_PAD;
    static final byte[] ZERO_PAD;
    static final byte[] BLANK_PAD;
    static final byte[] EMPTY_BYTE_ARRAY;
    private static Set<Integer> NonSevereErrorCodes;
    public static final int SET_NOT_NULL_TO_NULL = 4203;
    public static final int INDEX_NOT_FOUND = 4243;
    public static final int ROW_NOT_FOUND = 626;
    static Class<?> charsetMapClass;
    static CharsetMap charsetMap;
    static int MAXIMUM_MYSQL_COLLATION_NUMBER;
    static int collationLatin1;
    protected static final int collationUTF16;
    private static Map<String, int[]> collationPeersMap;
    private static CharsetConverter charsetConverterMultibyte;
    private static CharsetConverter[] charsetConverters;
    private static final EndianManager endianManager;
    static int[] howManyBytesNeeded;

    static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ClusterJUserException(local.message("ERR_Loading_Native_Class", (Object)className), e);
        }
    }

    static CharsetMap createCharsetMap() {
        StringBuilder builder = new StringBuilder();
        CharsetMap result = null;
        try {
            return CharsetMap.create();
        }
        catch (Throwable t1) {
            builder.append("CharsetMap.create() threw " + t1.getClass().getName() + ":" + t1.getMessage());
            try {
                Method charsetMapCreateMethod = charsetMapClass.getMethod("create", null);
                result = (CharsetMap)charsetMapCreateMethod.invoke(null, (Object[])null);
                builder.append("charsetMapCreateMethod.invoke() succeeded:" + result);
            }
            catch (Throwable t2) {
                builder.append("charsetMapCreateMethod.invoke() threw " + t2.getClass().getName() + ":" + t2.getMessage());
            }
            throw new ClusterJUserException(builder.toString());
        }
    }

    public static CharsetMap getCharsetMap() {
        return charsetMap;
    }

    public static boolean isRetriable(ClusterJDatastoreException ex) {
        return 1 == ex.getStatus();
    }

    protected static short swap(short value) {
        return (short)(0xFF & value >>> 8 | 0xFF00 & value << 8);
    }

    protected static int swap(int value) {
        return 0xFF & value >>> 24 | 0xFF00 & value >>> 8 | 0xFF0000 & value << 8 | 0xFF000000 & value << 24;
    }

    protected static long swap(long value) {
        return 0xFFL & value >>> 56 | 0xFF00L & value >>> 40 | 0xFF0000L & value >>> 24 | 0xFF000000L & value >>> 8 | 0xFF00000000L & value << 8 | 0xFF0000000000L & value << 24 | 0xFF000000000000L & value << 40 | 0xFF00000000000000L & value << 56;
    }

    protected static void throwError(Object returnCode, NdbErrorConst ndbError) {
        Utility.throwError(returnCode, ndbError, "");
    }

    protected static void throwError(Object returnCode, NdbErrorConst ndbError, String extra) {
        String message = ndbError.message();
        int code = ndbError.code();
        int mysqlCode = ndbError.mysql_code();
        int status = ndbError.status();
        int classification = ndbError.classification();
        String msg = local.message("ERR_NdbJTie", returnCode, code, mysqlCode, status, classification, message, extra);
        if (!NonSevereErrorCodes.contains(code)) {
            logger.error(msg);
        }
        throw new ClusterJDatastoreException(msg, code, mysqlCode, status, classification);
    }

    public static ByteBuffer convertValue(Column storeColumn, byte[] value) {
        int requiredLength = storeColumn.getColumnSpace();
        ByteBuffer result = ByteBuffer.allocateDirect(requiredLength);
        Utility.convertValue(result, storeColumn, value);
        result.flip();
        return result;
    }

    public static void convertValue(ByteBuffer buffer, Column storeColumn, byte[] value) {
        int dataLength = value.length;
        int maximumLength = storeColumn.getLength();
        if (dataLength > maximumLength) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", storeColumn.getName(), maximumLength, dataLength));
        }
        int prefixLength = storeColumn.getPrefixLength();
        switch (prefixLength) {
            case 0: {
                buffer.put(value);
                if (dataLength >= maximumLength) break;
                buffer.put(ZERO_PAD, 0, maximumLength - dataLength);
                break;
            }
            case 1: {
                buffer.put((byte)dataLength);
                buffer.put(value);
                break;
            }
            case 2: {
                buffer.put((byte)(dataLength % 256));
                buffer.put((byte)(dataLength / 256));
                buffer.put(value);
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Prefix_Length", (Object)prefixLength, (Object)storeColumn.getName()));
            }
        }
    }

    public static ByteBuffer convertValue(Column storeColumn, BigDecimal value) {
        int precision = storeColumn.getPrecision();
        int scale = storeColumn.getScale();
        int bytesNeeded = Utility.getDecimalColumnSpace(precision, scale);
        ByteBuffer result = ByteBuffer.allocateDirect(bytesNeeded);
        BigDecimal scaledValue = value.setScale(scale, RoundingMode.HALF_UP);
        String stringRepresentation = scaledValue.toPlainString();
        int length = stringRepresentation.length();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(length);
        CharBuffer charBuffer = CharBuffer.wrap(stringRepresentation);
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        byteBuffer.flip();
        int returnCode = Utils.decimal_str2bin(byteBuffer, length, precision, scale, result, bytesNeeded);
        byteBuffer.flip();
        if (returnCode != 0) {
            throw new ClusterJUserException(local.message("ERR_String_To_Binary_Decimal", returnCode, scaledValue, storeColumn.getName(), precision, scale));
        }
        return result;
    }

    public static ByteBuffer convertValue(Column storeColumn, BigInteger value) {
        int precision = storeColumn.getPrecision();
        int scale = storeColumn.getScale();
        int bytesNeeded = Utility.getDecimalColumnSpace(precision, scale);
        ByteBuffer result = ByteBuffer.allocateDirect(bytesNeeded);
        String stringRepresentation = value.toString();
        int length = stringRepresentation.length();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(length);
        CharBuffer charBuffer = CharBuffer.wrap(stringRepresentation);
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        byteBuffer.flip();
        int returnCode = Utils.decimal_str2bin(byteBuffer, length, precision, scale, result, bytesNeeded);
        byteBuffer.flip();
        if (returnCode != 0) {
            throw new ClusterJUserException(local.message("ERR_String_To_Binary_Decimal", returnCode, stringRepresentation, storeColumn.getName(), precision, scale));
        }
        return result;
    }

    public static ByteBuffer convertValue(Column storeColumn, double value) {
        ByteBuffer result = ByteBuffer.allocateDirect(8);
        result.order(ByteOrder.nativeOrder());
        result.putDouble(value);
        result.flip();
        return result;
    }

    public static ByteBuffer convertValue(Column storeColumn, float value) {
        ByteBuffer result = ByteBuffer.allocateDirect(4);
        result.order(ByteOrder.nativeOrder());
        result.putFloat(value);
        result.flip();
        return result;
    }

    public static ByteBuffer convertValue(Column storeColumn, byte value) {
        return endianManager.convertValue(storeColumn, value);
    }

    public static ByteBuffer convertValue(Column storeColumn, short value) {
        return endianManager.convertValue(storeColumn, value);
    }

    public static ByteBuffer convertValue(Column storeColumn, int value) {
        return endianManager.convertValue(storeColumn, value);
    }

    public static ByteBuffer convertValue(Column storeColumn, long value) {
        return endianManager.convertValue(storeColumn, value);
    }

    protected static ByteBuffer convertValue(Column storeColumn, String value) {
        if (value == null) {
            value = "";
        }
        CharSequence chars = value;
        int offset = storeColumn.getPrefixLength();
        if (offset == 0) {
            chars = Utility.padString(value, storeColumn);
        }
        ByteBuffer byteBuffer = Utility.encodeToByteBuffer(chars, storeColumn.getCharsetNumber(), offset);
        Utility.fixBufferPrefixLength(storeColumn.getName(), byteBuffer, offset);
        if (logger.isDetailEnabled()) {
            Utility.dumpBytesToLog(byteBuffer, byteBuffer.limit());
        }
        return byteBuffer;
    }

    protected static ByteBuffer convertValueForLikeFilter(Column storeColumn, String value) {
        if (value == null) {
            value = "";
        }
        String chars = value;
        ByteBuffer byteBuffer = Utility.encodeToByteBuffer(chars, storeColumn.getCharsetNumber(), 0);
        if (logger.isDetailEnabled()) {
            Utility.dumpBytesToLog(byteBuffer, byteBuffer.limit());
        }
        return byteBuffer;
    }

    protected static ByteBuffer convertValueForLikeFilter(Column storeColumn, byte[] value) {
        if (value == null) {
            value = EMPTY_BYTE_ARRAY;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(value.length);
        byteBuffer.put(value);
        byteBuffer.flip();
        if (logger.isDetailEnabled()) {
            Utility.dumpBytesToLog(byteBuffer, byteBuffer.limit());
        }
        return byteBuffer;
    }

    private static CharSequence padString(CharSequence value, Column storeColumn) {
        int requiredLength;
        CharSequence chars = value;
        int suppliedLength = value.length();
        if (suppliedLength > (requiredLength = storeColumn.getColumnSpace())) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", storeColumn.getName(), requiredLength, suppliedLength));
        }
        if (suppliedLength < requiredLength) {
            StringBuilder buffer = new StringBuilder(requiredLength);
            buffer.append(value);
            buffer.append(SPACE_PAD, 0, requiredLength - suppliedLength);
            chars = buffer;
        }
        return chars;
    }

    private static ByteBuffer padString(ByteBuffer buffer, Column storeColumn) {
        int requiredLength;
        int suppliedLength = buffer.limit();
        if (suppliedLength > (requiredLength = storeColumn.getColumnSpace())) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", storeColumn.getName(), requiredLength, suppliedLength));
        }
        if (suppliedLength < requiredLength) {
            buffer.limit(requiredLength);
            buffer.position(suppliedLength);
            buffer.put(BLANK_PAD, 0, requiredLength - suppliedLength);
            buffer.position(0);
        }
        return buffer;
    }

    public static void fixBufferPrefixLength(String columnName, ByteBuffer byteBuffer, int offset) {
        int limit = byteBuffer.limit();
        int length = limit - offset;
        byteBuffer.position(0);
        switch (offset) {
            case 0: {
                break;
            }
            case 1: {
                byteBuffer.put((byte)(length % 256));
                break;
            }
            case 2: {
                byteBuffer.put((byte)(length % 256));
                byteBuffer.put((byte)(length / 256));
            }
        }
        byteBuffer.position(0);
        byteBuffer.limit(limit);
    }

    private static int packDate(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(millis);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int date = year * 512 + (month + 1) * 32 + day;
        return date;
    }

    private static int packTime(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(millis);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hour = calendar.get(10);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if (month != 0) {
            throw new ClusterJUserException(local.message("ERR_Write_Time_Domain", new Time(millis), millis, year, month, day, hour, minute, second));
        }
        int time = (day - 1) * 240000 + hour * 10000 + minute * 100 + second;
        return time;
    }

    protected static long packDatetime(long value) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(value);
        long year = calendar.get(1);
        long month = calendar.get(2) + 1;
        long day = calendar.get(5);
        long hour = calendar.get(10);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long packedDatetime = year * 10000000000L + month * 100000000L + day * 1000000L + hour * 10000L + minute * 100L + second;
        return packedDatetime;
    }

    protected static long packDatetime2(int precision, long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(millis);
        long year = calendar.get(1);
        long month = calendar.get(2);
        long day = calendar.get(5);
        long hour = calendar.get(10);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long milliseconds = calendar.get(14);
        long packedMillis = Utility.packFractionalSeconds(precision, milliseconds);
        long result = Long.MIN_VALUE + year * 0x3400000000000L + (month + 1L) * 0x400000000000L + day * 0x20000000000L + hour * 0x1000000000L + minute * 0x40000000L + second * 0x1000000L + packedMillis;
        return result;
    }

    protected static long unpackDatetime2(int precision, long packedDatetime2) {
        int yearMonth = (int)((packedDatetime2 & 0x7FFFC00000000000L) >>> 46);
        int year = yearMonth / 13;
        int month = yearMonth % 13 - 1;
        int day = (int)((packedDatetime2 & 0x3E0000000000L) >>> 41);
        int hour = (int)((packedDatetime2 & 0x1F000000000L) >>> 36);
        int minute = (int)((packedDatetime2 & 0xFC0000000L) >>> 30);
        int second = (int)((packedDatetime2 & 0x3F000000L) >>> 24);
        int milliseconds = Utility.unpackFractionalSeconds(precision, (int)(packedDatetime2 & 0xFFFFFFL));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliseconds);
        return calendar.getTimeInMillis();
    }

    protected static long packFractionalSeconds(int precision, long milliseconds) {
        switch (precision) {
            case 0: {
                if (milliseconds > 0L) {
                    Utility.throwOnTruncation();
                }
                return 0L;
            }
            case 1: {
                if (milliseconds % 100L != 0L) {
                    Utility.throwOnTruncation();
                }
                return milliseconds / 10L * 65536L;
            }
            case 2: {
                if (milliseconds % 10L != 0L) {
                    Utility.throwOnTruncation();
                }
                return milliseconds / 10L * 65536L;
            }
            case 3: 
            case 4: {
                return milliseconds * 2560L;
            }
            case 5: 
            case 6: {
                return milliseconds * 1000L;
            }
        }
        return 0L;
    }

    protected static int unpackFractionalSeconds(int precision, int fraction) {
        switch (precision) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return ((fraction & 0xFF0000) >> 16) * 10;
            }
            case 3: 
            case 4: {
                return ((fraction & 0xFFFF00) >> 8) / 10;
            }
            case 5: 
            case 6: {
                return fraction / 1000;
            }
        }
        return 0;
    }

    protected static void throwOnTruncation() {
    }

    protected static long packTime2(int precision, long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(millis);
        long hour = calendar.get(10);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long milliseconds = calendar.get(14);
        long packedMillis = Utility.packFractionalSeconds(precision, milliseconds);
        long result = Long.MIN_VALUE | hour * 0x10000000000000L | minute * 0x400000000000L | second * 0x10000000000L | packedMillis << 16;
        return result;
    }

    protected static long unpackTime2(int precision, long value) {
        int hour = (int)((value & 0x3FF0000000000000L) >>> 52);
        int minute = (int)((value & 0xFC00000000000L) >>> 46);
        int second = (int)((value & 0x3F0000000000L) >>> 40);
        int fraction = (int)((value & 0xFFFFFF0000L) >>> 16);
        int milliseconds = Utility.unpackFractionalSeconds(precision, fraction);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliseconds);
        return calendar.getTimeInMillis();
    }

    protected static long packTimestamp2(int precision, long millis) {
        long milliseconds = millis % 1000L;
        long seconds = millis / 1000L;
        long packedMillis = Utility.packFractionalSeconds(precision, milliseconds);
        long result = (seconds << 32) + (packedMillis << 8);
        return result;
    }

    protected static long unpackTimestamp2(int precision, long value) {
        long result = (value >>> 32) * 1000L + (long)Utility.unpackFractionalSeconds(precision, (int)value >>> 8);
        return result;
    }

    public static String dumpBytes(byte[] bytes) {
        StringBuffer buffer = new StringBuffer("byte[");
        buffer.append(bytes.length);
        buffer.append("]: [");
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(bytes[i]);
            buffer.append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String dumpBytes(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int length = byteBuffer.limit() - byteBuffer.position();
        byte[] dst = new byte[length];
        byteBuffer.get(dst);
        byteBuffer.reset();
        return Utility.dumpBytes(dst);
    }

    private static void dumpBytesToLog(ByteBuffer byteBuffer, int limit) {
        StringBuffer message = new StringBuffer("String position is: ");
        message.append(byteBuffer.position());
        message.append(" limit: ");
        message.append(byteBuffer.limit());
        message.append(" data [");
        while (byteBuffer.hasRemaining()) {
            message.append(byteBuffer.get());
            message.append(" ");
        }
        message.append("]");
        logger.detail(message.toString());
        byteBuffer.position(0);
        byteBuffer.limit(limit);
    }

    public static BigDecimal getDecimal(ByteBuffer byteBuffer, int length, int precision, int scale) {
        String decimal = null;
        try {
            decimal = Utility.getDecimalString(byteBuffer, length, precision, scale);
            return new BigDecimal(decimal);
        }
        catch (NumberFormatException nfe) {
            throw new ClusterJUserException(local.message("ERR_Number_Format", (Object)decimal, (Object)Utility.dump(decimal)));
        }
    }

    public static BigInteger getBigInteger(ByteBuffer byteBuffer, int length, int precision, int scale) {
        String decimal = null;
        try {
            decimal = Utility.getDecimalString(byteBuffer, length, precision, scale);
            return new BigInteger(decimal);
        }
        catch (NumberFormatException nfe) {
            throw new ClusterJUserException(local.message("ERR_Number_Format", (Object)decimal, (Object)Utility.dump(decimal)));
        }
    }

    public static String getDecimalString(ByteBuffer byteBuffer, int length, int precision, int scale) {
        int capacity = precision + 3;
        ByteBuffer digits = ByteBuffer.allocateDirect(capacity);
        int returnCode = Utils.decimal_bin2str(byteBuffer, length, precision, scale, digits, capacity);
        if (returnCode != 0) {
            throw new ClusterJUserException(local.message("ERR_Binary_Decimal_To_String", returnCode, precision, scale, Utility.dumpBytes(byteBuffer)));
        }
        String string = null;
        for (int i = 0; i < digits.limit(); ++i) {
            if (digits.get(i) != 0) continue;
            digits.limit(i);
            break;
        }
        try {
            CharBuffer charBuffer = charsetDecoder.decode(digits);
            string = charBuffer.toString();
            return string;
        }
        catch (CharacterCodingException e) {
            throw new ClusterJFatalInternalException(local.message("ERR_Character_Encoding", (Object)string));
        }
    }

    public static long unpackDate(int packedDate) {
        int date = packedDate & 0x1F;
        int month = ((packedDate >>>= 5) & 0xF) - 1;
        int year = packedDate >>> 4;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month, date);
        return calendar.getTimeInMillis();
    }

    public static long unpackTime(int packedTime) {
        int second = packedTime % 100;
        int minute = (packedTime /= 100) % 100;
        int hour = (packedTime /= 100) % 24;
        int date = packedTime / 24 + 1;
        if (date > 31) {
            throw new ClusterJUserException(local.message("ERR_Read_Time_Domain", packedTime, date, hour, minute, second));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(5, date);
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    protected static long unpackDatetime(long packedDatetime) {
        int second = (int)(packedDatetime % 100L);
        int minute = (int)((packedDatetime /= 100L) % 100L);
        int hour = (int)((packedDatetime /= 100L) % 100L);
        int day = (int)((packedDatetime /= 100L) % 100L);
        int month = (int)((packedDatetime /= 100L) % 100L) - 1;
        int year = (int)(packedDatetime / 100L);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static String decode(byte[] array, int collation) {
        if (array == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(array.length);
        byteBuffer.put(array);
        byteBuffer.flip();
        int inputLength = array.length;
        int outputLength = inputLength * 4;
        ByteBuffer outputByteBuffer = ByteBuffer.allocateDirect(outputLength);
        int[] lengths = new int[]{inputLength, outputLength};
        int returnCode = charsetMap.recode(lengths, collation, collationUTF16, byteBuffer, outputByteBuffer);
        switch (returnCode) {
            case 0: {
                outputByteBuffer.limit(lengths[1]);
                CharBuffer charBuffer = outputByteBuffer.asCharBuffer();
                return charBuffer.toString();
            }
            case 1: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Charset", collation));
            }
            case 2: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Source", (Object)collation, (Object)lengths[0]));
            }
            case 3: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Buffer_Too_Small", collation, inputLength, outputLength, lengths[0], lengths[1]));
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Return_Code", returnCode));
    }

    protected static String decode(ByteBuffer inputByteBuffer, int collation) {
        int inputLength = inputByteBuffer.limit() - inputByteBuffer.position();
        int outputLength = inputLength * 2;
        ByteBuffer outputByteBuffer = ByteBuffer.allocateDirect(outputLength);
        int[] lengths = new int[]{inputLength, outputLength};
        int returnCode = charsetMap.recode(lengths, collation, collationUTF16, inputByteBuffer, outputByteBuffer);
        switch (returnCode) {
            case 0: {
                outputByteBuffer.limit(lengths[1]);
                CharBuffer charBuffer = outputByteBuffer.asCharBuffer();
                return charBuffer.toString();
            }
            case 1: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Charset", collation));
            }
            case 2: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Source", (Object)collation, (Object)lengths[0]));
            }
            case 3: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Buffer_Too_Small", collation, inputLength, outputLength, lengths[0], lengths[1]));
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Return_Code", returnCode));
    }

    public static byte[] encode(String string, int collation) {
        ByteBuffer encoded = Utility.encodeToByteBuffer(string, collation, 0);
        int length = encoded.limit();
        byte[] result = new byte[length];
        encoded.get(result);
        return result;
    }

    public static ByteBuffer encodeToByteBuffer(CharSequence string, int collation, int prefixLength) {
        if (string == null) {
            return null;
        }
        int inputLength = string.length() * 2;
        ByteBuffer inputByteBuffer = ByteBuffer.allocateDirect(inputLength);
        CharBuffer charBuffer = inputByteBuffer.asCharBuffer();
        charBuffer.append(string);
        int outputLength = 2 * inputLength + prefixLength;
        ByteBuffer outputByteBuffer = ByteBuffer.allocateDirect(outputLength);
        outputByteBuffer.position(prefixLength);
        int[] lengths = new int[]{inputLength, outputLength - prefixLength};
        int returnCode = charsetMap.recode(lengths, collationUTF16, collation, inputByteBuffer, outputByteBuffer);
        switch (returnCode) {
            case 0: {
                outputByteBuffer.limit(prefixLength + lengths[1]);
                return outputByteBuffer;
            }
            case 1: {
                throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Charset", collation));
            }
            case 2: {
                throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Source", (Object)collation, (Object)lengths[0]));
            }
            case 3: {
                throw new ClusterJFatalInternalException(local.message("ERR_Encode_Buffer_Too_Small", collation, inputLength, outputLength, lengths[0], lengths[1]));
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Return_Code", returnCode));
    }

    public static ByteBuffer encode(String input, Column storeColumn, DbImpl.BufferManager bufferManager) {
        int collation = storeColumn.getCharsetNumber();
        CharsetConverter charsetConverter = Utility.getCharsetConverter(collation);
        String chars = input;
        int prefixLength = storeColumn.getPrefixLength();
        ByteBuffer byteBuffer = charsetConverter.encode(storeColumn.getName(), chars, collation, prefixLength, bufferManager);
        if (prefixLength == 0) {
            Utility.padString(byteBuffer, storeColumn);
        }
        return byteBuffer;
    }

    public static String decode(ByteBuffer inputByteBuffer, int collation, DbImpl.BufferManager bufferManager) {
        CharsetConverter charsetConverter = Utility.getCharsetConverter(collation);
        return charsetConverter.decode(inputByteBuffer, collation, bufferManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharsetConverter getCharsetConverter(int collation) {
        CharsetConverter[] charsetConverterArray = charsetConverters;
        synchronized (charsetConverters) {
            if (collation + 1 > charsetConverters.length) {
                String charsetName = charsetMap.getName(collation);
                logger.warn(local.message("ERR_Charset_Number_Too_Big", collation, charsetName, MAXIMUM_MYSQL_COLLATION_NUMBER));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return charsetConverterMultibyte;
            }
            CharsetConverter result = charsetConverters[collation];
            if (result == null) {
                result = Utility.addCollation(collation);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static CharsetConverter addCollation(int collation) {
        if (Utility.isMultibyteCollation(collation).booleanValue()) {
            Utility.charsetConverters[collation] = charsetConverterMultibyte;
            return Utility.charsetConverters[collation];
        }
        String charsetName = charsetMap.getMysqlName(collation);
        SingleByteCharsetConverter charsetConverter = new SingleByteCharsetConverter(collation);
        int[] collations = collationPeersMap.get(charsetName);
        if (collations == null) {
            collations = new int[]{collation};
            collationPeersMap.put(charsetName, collations);
            logger.warn(local.message("WARN_Unknown_Collation", (Object)collation, (Object)charsetName));
            return charsetConverter;
        }
        for (int peer : collations) {
            logger.info("Adding charset converter " + charsetName + " for collation " + peer);
            Utility.charsetConverters[peer] = charsetConverter;
        }
        return charsetConverter;
    }

    private static Boolean isMultibyteCollation(int collation) {
        boolean[] multibyte = charsetMap.isMultibyte(collation);
        return multibyte == null ? null : Boolean.valueOf(multibyte[0]);
    }

    private static String dump(String string) {
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < string.length(); ++i) {
            char theCharacter = string.charAt(i);
            buffer.append((int)theCharacter);
            buffer.append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static int getDecimalColumnSpace(int precision, int scale) {
        int howManyBytesNeededForIntegral = howManyBytesNeeded[precision - scale];
        int howManyBytesNeededForFraction = howManyBytesNeeded[scale];
        int result = howManyBytesNeededForIntegral + howManyBytesNeededForFraction;
        return result;
    }

    public static boolean getBoolean(Column storeColumn, NdbRecAttr ndbRecAttr) {
        return endianManager.getBoolean(storeColumn, ndbRecAttr);
    }

    public static boolean getBoolean(Column storeColumn, int value) {
        return endianManager.getBoolean(storeColumn, value);
    }

    public static byte getByte(Column storeColumn, NdbRecAttr ndbRecAttr) {
        return endianManager.getByte(storeColumn, ndbRecAttr);
    }

    public static short getShort(Column storeColumn, NdbRecAttr ndbRecAttr) {
        return endianManager.getShort(storeColumn, ndbRecAttr);
    }

    public static int getInt(Column storeColumn, NdbRecAttr ndbRecAttr) {
        return endianManager.getInt(storeColumn, ndbRecAttr);
    }

    public static int getInt(Column storeColumn, int value) {
        return endianManager.getInt(storeColumn, value);
    }

    public static long getLong(Column storeColumn, long value) {
        return endianManager.getLong(storeColumn, value);
    }

    public static long convertLongValueForStorage(Column storeColumn, long value) {
        return endianManager.convertLongValueForStorage(storeColumn, value);
    }

    public static int convertByteValueForStorage(Column storeColumn, byte value) {
        return endianManager.convertByteValueForStorage(storeColumn, value);
    }

    public static int convertShortValueForStorage(Column storeColumn, short value) {
        return endianManager.convertShortValueForStorage(storeColumn, value);
    }

    public static int convertIntValueForStorage(Column storeColumn, int value) {
        return endianManager.convertIntValueForStorage(storeColumn, value);
    }

    static {
        int i;
        local = I18NHelper.getInstance(Utility.class);
        logger = LoggerFactoryService.getFactory().getInstance(Utility.class);
        charsetEncoder = Charset.forName("windows-1252").newEncoder();
        charsetDecoder = Charset.forName("windows-1252").newDecoder();
        SPACE_PAD = new char[255];
        for (i = 0; i < 255; ++i) {
            Utility.SPACE_PAD[i] = 32;
        }
        ZERO_PAD = new byte[255];
        for (i = 0; i < 255; ++i) {
            Utility.ZERO_PAD[i] = 0;
        }
        BLANK_PAD = new byte[255];
        for (i = 0; i < 255; ++i) {
            Utility.BLANK_PAD[i] = 32;
        }
        EMPTY_BYTE_ARRAY = new byte[0];
        NonSevereErrorCodes = new HashSet<Integer>();
        NonSevereErrorCodes.add(4203);
        NonSevereErrorCodes.add(4243);
        NonSevereErrorCodes.add(626);
        ClusterConnectionServiceImpl.loadSystemLibrary("ndbclient");
        charsetMapClass = Utility.loadClass("com.mysql.ndbjtie.mysql.CharsetMap");
        charsetMap = Utility.createCharsetMap();
        MAXIMUM_MYSQL_COLLATION_NUMBER = 256;
        collationLatin1 = charsetMap.getCharsetNumber("latin1");
        collationUTF16 = charsetMap.getUTF16CharsetNumber();
        collationPeersMap = new TreeMap<String, int[]>();
        charsetConverterMultibyte = new MultiByteCharsetConverter();
        charsetConverters = new CharsetConverter[MAXIMUM_MYSQL_COLLATION_NUMBER + 1];
        TreeMap<String, ArrayList<Integer>> workingCollationPeersMap = new TreeMap<String, ArrayList<Integer>>();
        for (int collation = 1; collation <= MAXIMUM_MYSQL_COLLATION_NUMBER; ++collation) {
            String string = charsetMap.getMysqlName(collation);
            if (string == null) continue;
            if (Utility.isMultibyteCollation(collation).booleanValue()) {
                Utility.charsetConverters[collation] = charsetConverterMultibyte;
                continue;
            }
            ArrayList<Integer> collations = (ArrayList<Integer>)workingCollationPeersMap.get(string);
            if (collations == null) {
                collations = new ArrayList<Integer>(8);
                collations.add(collation);
                workingCollationPeersMap.put(string, collations);
                continue;
            }
            collations.add(collation);
        }
        for (Map.Entry entry : workingCollationPeersMap.entrySet()) {
            String mysqlName = (String)entry.getKey();
            List collations = (List)entry.getValue();
            int[] collationArray = new int[collations.size()];
            int i2 = 0;
            for (Integer collation : collations) {
                collationArray[i2++] = collation;
            }
            collationPeersMap.put(mysqlName, collationArray);
        }
        if (logger.isDetailEnabled()) {
            for (Map.Entry<Object, Object> entry : collationPeersMap.entrySet()) {
                logger.detail("Utility collationMap " + (String)entry.getKey() + " collations : " + Arrays.toString((int[])entry.getValue()));
            }
        }
        Utility.addCollation(collationLatin1);
        endianManager = ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder()) ? new EndianManager(){

            @Override
            public boolean getBoolean(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        return ndbRecAttr.int32_value() == 1;
                    }
                    case Tinyint: {
                        return ndbRecAttr.int8_value() == 1;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"boolean"));
            }

            @Override
            public boolean getBoolean(Column storeColumn, int value) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        return value == 1;
                    }
                    case Tinyint: {
                        return value >>> 24 == 1;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"boolean"));
            }

            @Override
            public byte getByte(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        return (byte)ndbRecAttr.int32_value();
                    }
                    case Tinyint: 
                    case Year: {
                        return ndbRecAttr.int8_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"byte"));
            }

            @Override
            public short getShort(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        return (short)ndbRecAttr.int32_value();
                    }
                    case Smallint: {
                        return ndbRecAttr.short_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"short"));
            }

            @Override
            public int getInt(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Int: 
                    case Timestamp: {
                        return ndbRecAttr.int32_value();
                    }
                    case Date: {
                        return ndbRecAttr.u_medium_value();
                    }
                    case Time: {
                        return ndbRecAttr.medium_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"int"));
            }

            @Override
            public int getInt(Column storeColumn, int value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Int: 
                    case Timestamp: {
                        return value;
                    }
                    case Date: {
                        return value >>> 8;
                    }
                    case Time: {
                        return value >> 8;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"int"));
            }

            @Override
            public long getLong(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        long rawValue = ndbRecAttr.int64_value();
                        return rawValue >>> 32 | rawValue << 32;
                    }
                    case Bigint: 
                    case Bigunsigned: {
                        return ndbRecAttr.int64_value();
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(ndbRecAttr.int64_value());
                    }
                    case Timestamp: {
                        return ((long)ndbRecAttr.int32_value() & 0xFFFFFFFFL) * 1000L;
                    }
                    case Date: {
                        return Utility.unpackDate(ndbRecAttr.u_medium_value());
                    }
                    case Time: {
                        return Utility.unpackTime(ndbRecAttr.medium_value());
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }

            @Override
            public long getLong(Column storeColumn, long value) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        return value >>> 32 | value << 32;
                    }
                    case Bigint: 
                    case Bigunsigned: {
                        return value;
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(value);
                    }
                    case Timestamp: {
                        return (value >> 32) * 1000L;
                    }
                    case Date: {
                        long packedDate = 0L;
                        packedDate |= (value & 0xFF00000000000000L) >>> 56;
                        packedDate |= (value & 0xFF000000000000L) >>> 40;
                        return Utility.unpackDate((int)(packedDate |= (value & 0xFF0000000000L) << 16 >> 40));
                    }
                    case Time: {
                        long packedTime = 0L;
                        packedTime |= (value & 0xFF00000000000000L) >>> 56;
                        packedTime |= (value & 0xFF000000000000L) >>> 40;
                        return Utility.unpackTime((int)(packedTime |= (value & 0xFF0000000000L) << 16 >> 40));
                    }
                    case Datetime2: {
                        return Utility.unpackDatetime2(storeColumn.getPrecision(), value);
                    }
                    case Timestamp2: {
                        return Utility.unpackTimestamp2(storeColumn.getPrecision(), value);
                    }
                    case Time2: {
                        return Utility.unpackTime2(storeColumn.getPrecision(), value);
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }

            @Override
            public void put3byteInt(ByteBuffer byteBuffer, int value) {
                byteBuffer.put((byte)value);
                byteBuffer.put((byte)(value >> 8));
                byteBuffer.put((byte)(value >> 16));
            }

            @Override
            public ByteBuffer convertValue(Column storeColumn, byte value) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        ByteBuffer result = ByteBuffer.allocateDirect(4);
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putInt(value & 0xFF);
                        result.flip();
                        return result;
                    }
                    case Tinyint: 
                    case Year: {
                        ByteBuffer result = ByteBuffer.allocateDirect(1);
                        result.put(value);
                        result.flip();
                        return result;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"byte"));
            }

            @Override
            public ByteBuffer convertValue(Column storeColumn, short value) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        ByteBuffer result = ByteBuffer.allocateDirect(4);
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putInt(value & 0xFFFF);
                        result.flip();
                        return result;
                    }
                    case Smallint: {
                        ByteBuffer result = ByteBuffer.allocateDirect(2);
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putShort(value);
                        result.flip();
                        return result;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"short"));
            }

            @Override
            public ByteBuffer convertValue(Column storeColumn, int value) {
                ByteBuffer result = ByteBuffer.allocateDirect(4);
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Int: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        break;
                    }
                    default: {
                        throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"int"));
                    }
                }
                result.putInt(value);
                result.flip();
                return result;
            }

            @Override
            public int convertIntValueForStorage(Column storeColumn, int value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Int: {
                        return value;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"int"));
            }

            @Override
            public ByteBuffer convertValue(Column storeColumn, long value) {
                ByteBuffer result = ByteBuffer.allocateDirect(8);
                return this.convertValue(storeColumn, value, result);
            }

            public ByteBuffer convertValue(Column storeColumn, long value, ByteBuffer result) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putInt((int)value);
                        result.putInt((int)(value >>> 32));
                        result.flip();
                        return result;
                    }
                    case Bigint: 
                    case Bigunsigned: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putLong(value);
                        result.flip();
                        return result;
                    }
                    case Date: {
                        result.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(result, Utility.packDate(value));
                        result.flip();
                        return result;
                    }
                    case Datetime: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putLong(Utility.packDatetime(value));
                        result.flip();
                        return result;
                    }
                    case Time: {
                        result.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(result, Utility.packTime(value));
                        result.flip();
                        return result;
                    }
                    case Timestamp: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putInt((int)(value / 1000L));
                        result.flip();
                        return result;
                    }
                    case Datetime2: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putLong(Utility.packDatetime2(storeColumn.getPrecision(), value));
                        result.flip();
                        return result;
                    }
                    case Time2: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putLong(Utility.packTime2(storeColumn.getPrecision(), value));
                        result.flip();
                        return result;
                    }
                    case Timestamp2: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putLong(Utility.packTimestamp2(storeColumn.getPrecision(), value));
                        result.flip();
                        return result;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }

            @Override
            public long convertLongValueForStorage(Column storeColumn, long value) {
                long result = 0L;
                switch (storeColumn.getType()) {
                    case Bit: {
                        result |= value >>> 32;
                        return result |= value << 32;
                    }
                    case Bigint: 
                    case Bigunsigned: {
                        return value;
                    }
                    case Date: {
                        long packDate = Utility.packDate(value);
                        result |= (packDate & 0xFFL) << 56;
                        result |= (packDate & 0xFF00L) << 40;
                        return result |= (packDate & 0xFF0000L) << 24;
                    }
                    case Datetime: {
                        return Utility.packDatetime(value);
                    }
                    case Time: {
                        long packTime = Utility.packTime(value);
                        result |= (packTime & 0xFFL) << 56;
                        result |= (packTime & 0xFF00L) << 40;
                        return result |= (packTime & 0xFF0000L) << 24;
                    }
                    case Timestamp: {
                        return value / 1000L << 32;
                    }
                    case Datetime2: {
                        return Utility.packDatetime2(storeColumn.getPrecision(), value);
                    }
                    case Time2: {
                        return Utility.packTime2(storeColumn.getPrecision(), value);
                    }
                    case Timestamp2: {
                        return Utility.packTimestamp2(storeColumn.getPrecision(), value);
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }

            @Override
            public int convertByteValueForStorage(Column storeColumn, byte value) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        return value & 0xFF;
                    }
                    case Tinyint: 
                    case Year: {
                        return value << 24;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"byte"));
            }

            @Override
            public int convertShortValueForStorage(Column storeColumn, short value) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        return value & 0xFFFF;
                    }
                    case Smallint: {
                        return value << 16;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"short"));
            }

            @Override
            public long convertLongValueFromStorage(Column storeColumn, long fromStorage) {
                return 0L;
            }
        } : new EndianManager(){

            @Override
            public boolean getBoolean(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        return ndbRecAttr.int32_value() == 1;
                    }
                    case Tinyint: {
                        return ndbRecAttr.int8_value() == 1;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"boolean"));
            }

            @Override
            public boolean getBoolean(Column storeColumn, int value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Tinyint: {
                        return value == 1;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"boolean"));
            }

            @Override
            public byte getByte(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Tinyint: 
                    case Year: {
                        return ndbRecAttr.int8_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"byte"));
            }

            @Override
            public short getShort(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Smallint: {
                        return ndbRecAttr.short_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"short"));
            }

            @Override
            public int getInt(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Int: 
                    case Timestamp: {
                        return ndbRecAttr.int32_value();
                    }
                    case Date: {
                        return ndbRecAttr.u_medium_value();
                    }
                    case Time: {
                        return ndbRecAttr.medium_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"int"));
            }

            @Override
            public int getInt(Column storeColumn, int value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Int: 
                    case Timestamp: {
                        return value;
                    }
                    case Date: {
                        return value & 0xFFFFFF;
                    }
                    case Time: {
                        return value << 8 >> 8;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"int"));
            }

            @Override
            public long getLong(Column storeColumn, NdbRecAttr ndbRecAttr) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Bigint: 
                    case Bigunsigned: {
                        return ndbRecAttr.int64_value();
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(ndbRecAttr.int64_value());
                    }
                    case Timestamp: {
                        return (long)ndbRecAttr.int32_value() * 1000L;
                    }
                    case Date: {
                        return Utility.unpackDate(ndbRecAttr.int32_value());
                    }
                    case Time: {
                        return Utility.unpackTime(ndbRecAttr.int32_value());
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }

            @Override
            public long getLong(Column storeColumn, long value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Bigint: 
                    case Bigunsigned: {
                        return value;
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(value);
                    }
                    case Timestamp: {
                        return value * 1000L;
                    }
                    case Date: {
                        return Utility.unpackDate((int)value);
                    }
                    case Time: {
                        return Utility.unpackTime((int)value);
                    }
                    case Datetime2: {
                        return Utility.unpackDatetime2(storeColumn.getPrecision(), Utility.swap(value));
                    }
                    case Timestamp2: {
                        return Utility.unpackTimestamp2(storeColumn.getPrecision(), Utility.swap(value));
                    }
                    case Time2: {
                        return Utility.unpackTime2(storeColumn.getPrecision(), Utility.swap(value));
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }

            @Override
            public void put3byteInt(ByteBuffer byteBuffer, int value) {
                byteBuffer.putInt(value);
                byteBuffer.limit(3);
            }

            @Override
            public ByteBuffer convertValue(Column storeColumn, byte value) {
                switch (storeColumn.getType()) {
                    case Bit: {
                        ByteBuffer result = ByteBuffer.allocateDirect(4);
                        result.order(ByteOrder.nativeOrder());
                        result.putInt(value & 0xFF);
                        result.flip();
                        return result;
                    }
                    case Tinyint: 
                    case Year: {
                        ByteBuffer result = ByteBuffer.allocateDirect(1);
                        result.order(ByteOrder.nativeOrder());
                        result.put(value);
                        result.flip();
                        return result;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"short"));
            }

            @Override
            public ByteBuffer convertValue(Column storeColumn, short value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Smallint: {
                        ByteBuffer result = ByteBuffer.allocateDirect(2);
                        result.order(ByteOrder.nativeOrder());
                        result.putShort(value);
                        result.flip();
                        return result;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"short"));
            }

            @Override
            public ByteBuffer convertValue(Column storeColumn, int value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Int: {
                        ByteBuffer result = ByteBuffer.allocateDirect(4);
                        result.order(ByteOrder.nativeOrder());
                        result.putInt(value);
                        result.flip();
                        return result;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"int"));
            }

            @Override
            public int convertIntValueForStorage(Column storeColumn, int value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Int: {
                        return value;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"int"));
            }

            @Override
            public ByteBuffer convertValue(Column storeColumn, long value) {
                ByteBuffer result = ByteBuffer.allocateDirect(8);
                return this.convertValue(storeColumn, value, result);
            }

            public ByteBuffer convertValue(Column storeColumn, long value, ByteBuffer result) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Bigint: 
                    case Bigunsigned: {
                        result.order(ByteOrder.LITTLE_ENDIAN);
                        result.putLong(value);
                        result.flip();
                        return result;
                    }
                    case Datetime: {
                        result.order(ByteOrder.LITTLE_ENDIAN);
                        result.putLong(Utility.packDatetime(value));
                        result.flip();
                        return result;
                    }
                    case Timestamp: {
                        result.order(ByteOrder.LITTLE_ENDIAN);
                        result.putInt((int)(value / 1000L));
                        result.flip();
                        return result;
                    }
                    case Date: {
                        result.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(result, Utility.packDate(value));
                        result.flip();
                        return result;
                    }
                    case Time: {
                        result.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(result, Utility.packTime(value));
                        result.flip();
                        return result;
                    }
                    case Datetime2: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putLong(Utility.packDatetime2(storeColumn.getPrecision(), value));
                        result.flip();
                        return result;
                    }
                    case Time2: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putLong(Utility.packTime2(storeColumn.getPrecision(), value));
                        result.flip();
                        return result;
                    }
                    case Timestamp2: {
                        result.order(ByteOrder.BIG_ENDIAN);
                        result.putLong(Utility.packTimestamp2(storeColumn.getPrecision(), value));
                        result.flip();
                        return result;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }

            @Override
            public long convertLongValueForStorage(Column storeColumn, long value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Bigint: 
                    case Bigunsigned: {
                        return value;
                    }
                    case Datetime: {
                        return Utility.packDatetime(value);
                    }
                    case Timestamp: {
                        return value / 1000L;
                    }
                    case Date: {
                        return Utility.packDate(value);
                    }
                    case Time: {
                        return Utility.packTime(value);
                    }
                    case Datetime2: {
                        return Utility.swap(Utility.packDatetime2(storeColumn.getPrecision(), value));
                    }
                    case Time2: {
                        return Utility.swap(Utility.packTime2(storeColumn.getPrecision(), value));
                    }
                    case Timestamp2: {
                        return Utility.swap(Utility.packTimestamp2(storeColumn.getPrecision(), value));
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }

            @Override
            public int convertByteValueForStorage(Column storeColumn, byte value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Tinyint: 
                    case Year: {
                        return value & 0xFF;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"byte"));
            }

            @Override
            public int convertShortValueForStorage(Column storeColumn, short value) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Smallint: {
                        return value & 0xFFFF;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"short"));
            }

            @Override
            public long convertLongValueFromStorage(Column storeColumn, long fromStorage) {
                switch (storeColumn.getType()) {
                    case Bit: 
                    case Bigint: 
                    case Bigunsigned: {
                        return fromStorage;
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(fromStorage);
                    }
                    case Timestamp: {
                        return fromStorage * 1000L;
                    }
                    case Date: {
                        return Utility.unpackDate((int)fromStorage);
                    }
                    case Time: {
                        return Utility.unpackTime((int)fromStorage);
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)storeColumn.getType(), (Object)"long"));
            }
        };
        howManyBytesNeeded = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 28, 29, 29};
    }

    protected static class SingleByteCharsetConverter
    implements CharsetConverter {
        private static final int BYTE_RANGE = 256;
        private static byte[] allBytes;
        private static byte[] unknownCharsMap;
        private char[] byteToChars = new char[256];
        private byte[] charToBytes = new byte[65536];

        public SingleByteCharsetConverter(int collation) {
            ByteBuffer allBytesByteBuffer = ByteBuffer.allocateDirect(256);
            allBytesByteBuffer.put(allBytes);
            allBytesByteBuffer.flip();
            String allBytesString = Utility.decode(allBytesByteBuffer, collation);
            if (allBytesString.length() != 256) {
                String charsetName = charsetMap.getName(collation);
                throw new ClusterJFatalInternalException(local.message("ERR_Bad_Charset_Decode_All_Chars", collation, charsetName, allBytesString.length()));
            }
            int allBytesLen = allBytesString.length();
            System.arraycopy(unknownCharsMap, 0, this.charToBytes, 0, this.charToBytes.length);
            for (int i = 0; i < 256 && i < allBytesLen; ++i) {
                char c;
                this.byteToChars[i] = c = allBytesString.charAt(i);
                this.charToBytes[c] = allBytes[i];
            }
        }

        @Override
        public ByteBuffer encode(String columnName, CharSequence input, int collation, int prefixLength, DbImpl.BufferManager bufferManager) {
            int length = input.length();
            byte[] outputBytes = new byte[length];
            for (int position = 0; position < length; ++position) {
                outputBytes[position] = this.charToBytes[input.charAt(position)];
            }
            ByteBuffer outputByteBuffer = bufferManager.getStringStorageBuffer(length + prefixLength);
            outputByteBuffer.position(prefixLength);
            outputByteBuffer.put(outputBytes);
            outputByteBuffer.flip();
            Utility.fixBufferPrefixLength(columnName, outputByteBuffer, prefixLength);
            return outputByteBuffer;
        }

        @Override
        public String decode(ByteBuffer inputByteBuffer, int collation, DbImpl.BufferManager bufferManager) {
            int inputLimit = inputByteBuffer.limit();
            int inputPosition = inputByteBuffer.position();
            int inputSize = inputLimit - inputPosition;
            byte[] inputBytes = new byte[inputSize];
            inputByteBuffer.get(inputBytes);
            char[] outputChars = new char[inputSize];
            for (int position = 0; position < inputSize; ++position) {
                outputChars[position] = this.byteToChars[inputBytes[position] - -128];
            }
            String result = new String(outputChars);
            return result;
        }

        static {
            int i;
            allBytes = new byte[256];
            unknownCharsMap = new byte[65536];
            for (i = -128; i <= 127; ++i) {
                SingleByteCharsetConverter.allBytes[i - -128] = (byte)i;
            }
            for (i = 0; i < unknownCharsMap.length; ++i) {
                SingleByteCharsetConverter.unknownCharsMap[i] = 63;
            }
        }
    }

    protected static class MultiByteCharsetConverter
    implements CharsetConverter {
        protected MultiByteCharsetConverter() {
        }

        @Override
        public ByteBuffer encode(String columnName, CharSequence input, int collation, int prefixLength, DbImpl.BufferManager bufferManager) {
            int inputLength = input.length() * 2;
            ByteBuffer inputByteBuffer = bufferManager.copyStringToByteBuffer(input);
            boolean done = false;
            int sizeNeeded = inputLength;
            block6: while (!done) {
                ByteBuffer outputByteBuffer = bufferManager.getStringStorageBuffer(sizeNeeded);
                int outputLength = outputByteBuffer.limit();
                outputByteBuffer.position(prefixLength);
                int[] lengths = new int[]{inputLength, outputLength - prefixLength};
                int returnCode = charsetMap.recode(lengths, collationUTF16, collation, inputByteBuffer, outputByteBuffer);
                switch (returnCode) {
                    case 0: {
                        outputByteBuffer.limit(prefixLength + lengths[1]);
                        outputByteBuffer.position(0);
                        Utility.fixBufferPrefixLength(columnName, outputByteBuffer, prefixLength);
                        return outputByteBuffer;
                    }
                    case 1: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Charset", collation));
                    }
                    case 2: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Source", (Object)collation, (Object)lengths[0]));
                    }
                    case 3: {
                        sizeNeeded = sizeNeeded * 3 / 2;
                        continue block6;
                    }
                }
                throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Return_Code", returnCode));
            }
            return null;
        }

        @Override
        public String decode(ByteBuffer inputByteBuffer, int collation, DbImpl.BufferManager bufferManager) {
            int inputLength = inputByteBuffer.limit() - inputByteBuffer.position();
            int sizeNeeded = inputLength * 4;
            boolean done = false;
            block6: while (!done) {
                ByteBuffer outputByteBuffer = bufferManager.getStringByteBuffer(sizeNeeded);
                CharBuffer outputCharBuffer = bufferManager.getStringCharBuffer();
                int outputLength = outputByteBuffer.capacity();
                outputByteBuffer.position(0);
                outputByteBuffer.limit(outputLength);
                int[] lengths = new int[]{inputLength, outputLength};
                int returnCode = charsetMap.recode(lengths, collation, collationUTF16, inputByteBuffer, outputByteBuffer);
                switch (returnCode) {
                    case 0: {
                        outputCharBuffer.position(0);
                        outputCharBuffer.limit(lengths[1] / 2);
                        return outputCharBuffer.toString();
                    }
                    case 1: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Charset", collation));
                    }
                    case 2: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Source", (Object)collation, (Object)lengths[0]));
                    }
                    case 3: {
                        sizeNeeded = sizeNeeded * 3 / 2;
                        continue block6;
                    }
                }
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Return_Code", returnCode));
            }
            return null;
        }
    }

    protected static interface CharsetConverter {
        public ByteBuffer encode(String var1, CharSequence var2, int var3, int var4, DbImpl.BufferManager var5);

        public String decode(ByteBuffer var1, int var2, DbImpl.BufferManager var3);
    }

    protected static interface EndianManager {
        public void put3byteInt(ByteBuffer var1, int var2);

        public int getInt(Column var1, int var2);

        public int getInt(Column var1, NdbRecAttr var2);

        public short getShort(Column var1, NdbRecAttr var2);

        public long getLong(Column var1, NdbRecAttr var2);

        public long getLong(Column var1, long var2);

        public byte getByte(Column var1, NdbRecAttr var2);

        public ByteBuffer convertValue(Column var1, byte var2);

        public ByteBuffer convertValue(Column var1, short var2);

        public ByteBuffer convertValue(Column var1, int var2);

        public ByteBuffer convertValue(Column var1, long var2);

        public boolean getBoolean(Column var1, NdbRecAttr var2);

        public boolean getBoolean(Column var1, int var2);

        public int convertIntValueForStorage(Column var1, int var2);

        public long convertLongValueForStorage(Column var1, long var2);

        public long convertLongValueFromStorage(Column var1, long var2);

        public int convertByteValueForStorage(Column var1, byte var2);

        public int convertShortValueForStorage(Column var1, short var2);
    }
}

