/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfigurationImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainTypeHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAResult;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import com.mysql.clusterj.openjpa.NdbOpenJPAUtility;
import com.mysql.clusterj.openjpa.NdbOpenJPAValueHandler;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryDomainType;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.RelationFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.StringId;

public class NdbOpenJPADomainFieldHandlerImpl
extends AbstractDomainFieldHandlerImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPADomainFieldHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPADomainFieldHandlerImpl.class);
    private static com.mysql.clusterj.core.store.Column[] emptyStoreColumns = new com.mysql.clusterj.core.store.Column[0];
    private FieldMapping fieldMapping;
    private Column column;
    private int javaType;
    private Field oidField;
    private String javaTypeName;
    private boolean isRelation = false;
    private boolean isMappedBy = false;
    private boolean isToOne = false;
    private boolean isEmbedded;
    private ClassMapping relatedTypeMapping = null;
    private NdbOpenJPADomainTypeHandlerImpl<?> relatedDomainTypeHandler = null;
    private FieldMapping relatedFieldMapping;
    private FieldMapping mappedByMapping;
    private Class<?> relatedType = null;
    private String relatedTypeName = null;
    private Column[] columns;
    private com.mysql.clusterj.core.store.Column[] storeColumns = emptyStoreColumns;
    private String relatedFieldName;
    private boolean supported = true;
    private String reason = "";
    private RelatedFieldLoadManager relatedFieldLoadManager;
    public AbstractDomainFieldHandlerImpl.ObjectOperationHandler[] objectOperationHandlers = new AbstractDomainFieldHandlerImpl.ObjectOperationHandler[]{objectOperationHandlerBoolean, objectOperationHandlerByte, objectOperationHandlerUnsupportedType, objectOperationHandlerDouble, objectOperationHandlerFloat, objectOperationHandlerInt, objectOperationHandlerLong, objectOperationHandlerShort, objectOperationHandlerUnsupportedType, objectOperationHandlerString, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerJavaUtilDate, objectOperationHandlerUnsupportedType, objectOperationHandlerObjectBoolean, objectOperationHandlerObjectByte, objectOperationHandlerUnsupportedType, objectOperationHandlerObjectDouble, objectOperationHandlerObjectFloat, objectOperationHandlerObjectInteger, objectOperationHandlerObjectLong, objectOperationHandlerObjectShort, objectOperationHandlerDecimal, objectOperationHandlerBigInteger, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType};
    static AbstractDomainFieldHandlerImpl.ObjectOperationHandler objectOperationHandlerRelationIntField = new ObjectOperationHandlerRelationField(){

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            OpenJPAStateManager rel = this.getRelatedStateManager(handler, fmd);
            if (rel == null) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object is null");
                }
                op.setNull(fmd.getStoreColumn());
            } else {
                Object objid = rel.getObjectId();
                if (objid == null) {
                    op.setNull(fmd.getStoreColumn());
                    if (logger.isDetailEnabled()) {
                        logger.detail("Related object class: " + rel.getMetaData().getTypeAlias() + " object id: " + objid);
                    }
                } else {
                    int oid = this.getInt(objid);
                    if (logger.isDetailEnabled()) {
                        logger.detail("Related object class: " + rel.getMetaData().getTypeAlias() + " key: " + oid);
                    }
                    op.setInt(fmd.getStoreColumn(), oid);
                }
            }
        }

        @Override
        public String handler() {
            return "Object ToOne Int key.";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (value == null) {
                op.setNull(fmd.getStoreColumn());
            } else {
                op.setInt(fmd.getStoreColumn(), (Integer)value);
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object oid, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            Field field = ((NdbOpenJPADomainFieldHandlerImpl)fmd).getOidField();
            Object value = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, oid);
            if (logger.isDetailEnabled()) {
                logger.detail("For column: " + fmd.getColumnName() + " oid: " + oid + " value: " + value);
            }
            filter.cmpInt(condition, fmd.getStoreColumn(), (Integer)value);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundInt(fmd.getStoreColumn(), type, (Integer)value);
        }
    };
    static AbstractDomainFieldHandlerImpl.ObjectOperationHandler objectOperationHandlerRelationLongField = new ObjectOperationHandlerRelationField(){

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            OpenJPAStateManager rel = this.getRelatedStateManager(handler, fmd);
            if (rel == null) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object is null");
                }
                op.setNull(fmd.getStoreColumn());
            } else {
                long oid = this.getLong(rel.getObjectId());
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object class: " + rel.getMetaData().getTypeAlias() + " key: " + oid);
                }
                op.setLong(fmd.getStoreColumn(), oid);
            }
        }

        @Override
        public String handler() {
            return "Object ToOne Long key.";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (value == null) {
                op.setNull(fmd.getStoreColumn());
            } else {
                op.setLong(fmd.getStoreColumn(), (Long)value);
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object oid, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            Field field = ((NdbOpenJPADomainFieldHandlerImpl)fmd).getOidField();
            Object value = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, oid);
            if (logger.isDetailEnabled()) {
                logger.detail("For column: " + fmd.getColumnName() + " oid: " + oid + " value: " + value);
            }
            filter.cmpLong(condition, fmd.getStoreColumn(), (Long)value);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundLong(fmd.getStoreColumn(), type, (Long)value);
        }
    };
    static AbstractDomainFieldHandlerImpl.ObjectOperationHandler objectOperationHandlerRelationStringField = new ObjectOperationHandlerRelationField(){

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            OpenJPAStateManager rel = this.getRelatedStateManager(handler, fmd);
            if (rel == null) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object is null");
                }
                op.setNull(fmd.getStoreColumn());
            } else {
                String oid = this.getString(rel.getObjectId());
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object class: " + rel.getMetaData().getTypeAlias() + " key: " + oid);
                }
                op.setString(fmd.getStoreColumn(), oid);
            }
        }

        @Override
        public String handler() {
            return "Object ToOne String key.";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (value == null) {
                op.setNull(fmd.getStoreColumn());
            } else {
                op.setString(fmd.getStoreColumn(), (String)value);
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object oid, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            Field field = ((NdbOpenJPADomainFieldHandlerImpl)fmd).getOidField();
            Object value = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, oid);
            if (logger.isDetailEnabled()) {
                logger.detail("For column: " + fmd.getColumnName() + " oid: " + oid + " filter.cmpString: " + value);
            }
            filter.cmpString(condition, fmd.getStoreColumn(), (String)value);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundString(fmd.getStoreColumn(), type, (String)value);
        }
    };
    static ObjectOperationHandlerRelationField objectOperationHandlerRelationCompositeField = new ObjectOperationHandlerRelationField(){

        @Override
        public String handler() {
            return "Composite key.";
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            for (AbstractDomainFieldHandlerImpl localHandler : fmd.compositeDomainFieldHandlers) {
                localHandler.operationGetValue(op);
            }
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            if (!ScanFilter.BinaryCondition.COND_EQ.equals((Object)condition)) {
                throw new ClusterJFatalInternalException(local.message("ERR_Illegal_Filter_Condition", (Object)condition));
            }
            filter.begin();
            for (AbstractDomainFieldHandlerImpl localHandler : fmd.compositeDomainFieldHandlers) {
                if (value != null) {
                    localHandler.filterCompareValue(value, condition, filter);
                    continue;
                }
                localHandler.filterCompareValue(null, condition, filter);
            }
            filter.end();
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            OpenJPAStateManager rel = this.getRelatedStateManager(handler, fmd);
            OpenJPAId openJPAId = null;
            Object oid = null;
            if (rel == null) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object is null");
                }
            } else {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object class: " + rel.getMetaData().getTypeAlias() + " key: " + openJPAId);
                }
                openJPAId = (OpenJPAId)rel.getObjectId();
                oid = openJPAId.getIdObject();
            }
            for (AbstractDomainFieldHandlerImpl localHandler : fmd.compositeDomainFieldHandlers) {
                Object value = null;
                if (rel != null) {
                    Field field = ((NdbOpenJPADomainFieldHandlerImpl)localHandler).getOidField();
                    value = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, oid);
                    localHandler.operationSetValue(value, op);
                    continue;
                }
                localHandler.operationSetValue((Object)null, op);
            }
        }

        @Override
        public Map<String, Object> createParameterMap(NdbOpenJPADomainFieldHandlerImpl domainFieldHandler, QueryDomainType<?> queryDomainObject, Object oid) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Predicate predicate = null;
            for (AbstractDomainFieldHandlerImpl localHandler : domainFieldHandler.compositeDomainFieldHandlers) {
                String name = localHandler.getColumnName();
                PredicateOperand parameter = queryDomainObject.param(name);
                PredicateOperand field = queryDomainObject.get(name);
                if (predicate == null) {
                    predicate = field.equal(parameter);
                } else {
                    predicate.and(field.equal(parameter));
                }
                Object value = domainFieldHandler.getKeyValue(oid);
                result.put(name, value);
                if (!logger.isDetailEnabled()) continue;
                logger.detail("Map.Entry key: " + name + ", value: " + value);
            }
            queryDomainObject.where(predicate);
            return result;
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object oid, IndexScanOperation.BoundType type, IndexScanOperation op) {
            for (AbstractDomainFieldHandlerImpl localHandler : fmd.compositeDomainFieldHandlers) {
                Field field = ((NdbOpenJPADomainFieldHandlerImpl)localHandler).getOidField();
                Object columnData = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, oid);
                localHandler.operationSetBounds(columnData, type, op);
            }
        }
    };

    public FieldMapping getFieldMapping() {
        return this.fieldMapping;
    }

    public NdbOpenJPADomainFieldHandlerImpl(Dictionary dictionary, NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler, NdbOpenJPAConfigurationImpl domainTypeHandlerFactory, FieldMapping fieldMapping) {
        Index index;
        Table table;
        String message = null;
        this.fieldMapping = fieldMapping;
        this.domainTypeHandler = domainTypeHandler;
        this.name = fieldMapping.getName();
        this.fieldNumber = fieldMapping.getIndex();
        this.primaryKey = fieldMapping.isPrimaryKey();
        this.columns = fieldMapping.getColumns();
        this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
        this.mappedByMapping = fieldMapping.getMappedByMapping();
        this.isMappedBy = this.mappedByMapping != null;
        this.isToOne = fieldMapping.getStrategy() instanceof RelationFieldStrategy;
        if (this.isMappedBy) {
            this.relatedType = this.mappedByMapping.getDeclaringType();
            this.relatedFieldMapping = fieldMapping.getMappedByMapping();
        }
        this.relatedTypeMapping = fieldMapping.getDeclaredTypeMapping();
        if (this.relatedTypeMapping != null) {
            this.relatedType = this.relatedTypeMapping.getDescribedType();
        }
        if (this.relatedType != null) {
            this.relatedTypeName = this.relatedType.getName();
        }
        this.isRelation = fieldMapping.getStrategy().getClass().getName().contains("Relation");
        this.isEmbedded = fieldMapping.getStrategy().getClass().getName().contains("Embed");
        if (logger.isDetailEnabled()) {
            logger.detail("field: " + this.name + " strategy: " + fieldMapping.getStrategy().getClass().getName() + " with " + this.columns.length + " columns.");
        }
        if (!(this.isRelation | this.isEmbedded)) {
            if (this.columns.length == 1) {
                this.column = this.columns[0];
                this.columnName = this.column.getName();
                table = domainTypeHandler.getTable();
                if (table == null) {
                    message = local.message("ERR_No_Mapped_Table", (Object)domainTypeHandler.getName());
                    this.setUnsupported(message);
                    return;
                }
                this.storeColumn = table.getColumn(this.columnName);
                if (this.storeColumn == null) {
                    message = local.message("ERR_No_Column", this.name, table.getName(), this.columnName);
                    this.setUnsupported(message);
                    return;
                }
                this.storeColumns = new com.mysql.clusterj.core.store.Column[]{this.storeColumn};
                this.charsetName = this.storeColumn.getCharsetName();
                this.javaType = this.column.getJavaType();
                this.objectOperationHandlerDelegate = this.getObjectOperationHandler(this.javaType);
                if (objectOperationHandlerUnsupportedType.equals(this.objectOperationHandlerDelegate)) {
                    message = local.message("ERR_Unsupported_Meta_Type", this.javaType);
                    this.setUnsupported(message);
                    return;
                }
                this.javaTypeName = NdbOpenJPAUtility.getJavaTypeName(this.javaType);
                if (this.storeColumn.isPrimaryKey()) {
                    domainTypeHandler.registerPrimaryKeyColumn(this, this.storeColumn.getName());
                }
            } else {
                if (this.columns.length > 1) {
                    StringBuffer buffer = new StringBuffer();
                    String separator = "";
                    for (Column errorColumn : this.columns) {
                        buffer.append(separator);
                        buffer.append(errorColumn.getName());
                        separator = ", ";
                    }
                    message = local.message("ERR_More_Than_One_Column_Mapped_To_A_Field", domainTypeHandler.getName(), this.name, buffer);
                    logger.info(message);
                    this.setUnsupported(message);
                    return;
                }
                if (this.columns.length == 0) {
                    message = local.message("ERR_No_Column_Mapped_To_A_Field", domainTypeHandler.getName(), this.name, fieldMapping.getTable(), fieldMapping.getStrategy().getClass().getName());
                    logger.info(message);
                    this.setUnsupported(message);
                    return;
                }
            }
            if (this.primaryKey) {
                this.oidField = NdbOpenJPADomainFieldHandlerImpl.getFieldForOidClass(this, domainTypeHandler.getOidClass(), this.name);
                this.indexNames.add("PRIMARY");
                switch (this.javaType) {
                    case 5: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyInt;
                        break;
                    }
                    case 21: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyObjectInteger;
                        break;
                    }
                    case 6: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyLong;
                        break;
                    }
                    case 22: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyObjectLong;
                        break;
                    }
                    case 9: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyString;
                        break;
                    }
                    default: {
                        message = local.message("ERR_Illegal_Primary_Key_Type", domainTypeHandler.getName(), this.name, this.columnName, this.javaTypeName);
                        logger.info(message);
                        this.setUnsupported(message);
                        break;
                    }
                }
            }
        } else if (this.isRelation) {
            if (this.columns.length == 1) {
                this.column = this.columns[0];
                this.columnName = this.column.getName();
                this.columnNames = new String[]{this.columnName};
                table = domainTypeHandler.getTable();
                this.storeColumn = table.getColumn(this.columnName);
                if (this.storeColumn == null) {
                    message = local.message("ERR_No_Column", this.name, table.getName(), this.columnName);
                    this.setUnsupported(message);
                    return;
                }
                this.storeColumns = new com.mysql.clusterj.core.store.Column[]{this.storeColumn};
                this.javaType = this.column.getJavaType();
                this.javaTypeName = NdbOpenJPAUtility.getJavaTypeName(this.javaType);
                this.objectOperationHandlerDelegate = this.getObjectOperationHandlerRelationDelegate(this.javaType);
                if (this.objectOperationHandlerDelegate == null) {
                    return;
                }
            } else if (this.columns.length == 0) {
                if (this.isMappedBy) {
                    this.objectOperationHandlerDelegate = objectOperationHandlerVirtualType;
                } else {
                    message = local.message("ERR_No_Columns_And_Not_Mapped_By", (Object)this.domainTypeHandler.getName(), (Object)this.name);
                    logger.info(message);
                    this.setUnsupported(message);
                }
            } else if (this.isMappedBy) {
                this.objectOperationHandlerDelegate = objectOperationHandlerVirtualType;
            } else {
                this.relatedTypeMapping = fieldMapping.getDeclaredTypeMapping();
                this.relatedType = this.relatedTypeMapping.getDescribedType();
                Class oid = this.relatedTypeMapping.getObjectIdType();
                if (logger.isDetailEnabled()) {
                    logger.detail("For class: " + domainTypeHandler.getName() + " field: " + this.name + " related type is: " + this.relatedType.getName() + " objectid type: " + oid.getName());
                }
                this.compositeDomainFieldHandlers = new NdbOpenJPADomainFieldHandlerImpl[this.columns.length];
                this.columnNames = new String[this.columns.length];
                this.storeColumns = new com.mysql.clusterj.core.store.Column[this.columns.length];
                for (int i = 0; i < this.columns.length; ++i) {
                    NdbOpenJPADomainFieldHandlerImpl relatedFieldHandler;
                    StringBuffer detailMessage = new StringBuffer();
                    Column localColumn = this.columns[i];
                    String localColumnName = localColumn.getName();
                    Table table2 = domainTypeHandler.getTable();
                    com.mysql.clusterj.core.store.Column localStoreColumn = table2.getColumn(localColumnName);
                    if (localStoreColumn == null) {
                        message = local.message("ERR_No_Column", this.name, table2.getName(), localColumnName);
                        logger.info(message);
                        this.setUnsupported(message);
                        return;
                    }
                    this.storeColumns[i] = localStoreColumn;
                    this.columnNames[i] = localColumnName;
                    ForeignKey foreignKey = fieldMapping.getForeignKey();
                    Column pkColumn = foreignKey.getPrimaryKeyColumn(localColumn);
                    if (logger.isDetailEnabled()) {
                        detailMessage.append(" column: " + localColumnName);
                        detailMessage.append(" fk-> " + foreignKey);
                        detailMessage.append(" pkColumn-> " + pkColumn);
                        logger.detail(detailMessage.toString());
                    }
                    if (!(relatedFieldHandler = new NdbOpenJPADomainFieldHandlerImpl(this, localColumn, pkColumn)).isSupported()) {
                        message = relatedFieldHandler.getReason();
                        this.setUnsupported(message);
                        return;
                    }
                    this.compositeDomainFieldHandlers[i] = relatedFieldHandler;
                }
                this.objectOperationHandlerDelegate = objectOperationHandlerRelationCompositeField;
            }
        } else {
            message = local.message("ERR_Embedded_Fields_Not_Supported", (Object)this.domainTypeHandler.getName(), (Object)this.name);
            logger.info(message);
            this.setUnsupported(message);
            return;
        }
        if ((index = fieldMapping.getJoinIndex()) != null) {
            String indexName = index.getName();
            Column[] indexColumns = index.getColumns();
            if (logger.isDetailEnabled()) {
                StringBuilder buffer = new StringBuilder("Found index name ");
                buffer.append(indexName);
                buffer.append(" [");
                for (Column indexColumn : indexColumns) {
                    if (!logger.isDetailEnabled()) continue;
                    buffer.append(indexColumn.getName());
                    buffer.append(" ");
                }
                buffer.append("]");
                logger.detail(buffer.toString());
            }
        }
        if ((index = fieldMapping.getValueIndex()) != null) {
            Column[] indexColumns;
            StringBuffer buffer = null;
            if (logger.isDetailEnabled()) {
                buffer = new StringBuffer("Found index ");
            }
            String indexName = index.getName();
            if (logger.isDetailEnabled()) {
                buffer.append(indexName + " [ ");
            }
            for (Column indexColumn : indexColumns = index.getColumns()) {
                if (!logger.isDetailEnabled()) continue;
                buffer.append(indexColumn.getName() + " ");
            }
            if (logger.isDetailEnabled()) {
                buffer.append("]");
            }
            if (logger.isDetailEnabled()) {
                logger.detail(buffer.toString());
            }
            this.indices = domainTypeHandler.createIndexHandler(this, dictionary, indexName);
        }
        this.type = fieldMapping.getType();
        if (logger.isTraceEnabled()) {
            logger.trace(" number: " + this.fieldNumber + " name: " + this.name + " column: " + this.columnName + " Java type: " + this.javaType + " strategy: " + this.toString(fieldMapping.getStrategy()) + " ObjectOperationHandler: " + this.objectOperationHandlerDelegate.handler());
        }
    }

    public void initializeRelations() {
        if (this.isRelation) {
            if (this.isMappedBy && this.isToOne) {
                this.relatedDomainTypeHandler = ((NdbOpenJPADomainTypeHandlerImpl)this.domainTypeHandler).registerDependency(this.relatedTypeMapping);
                this.relatedFieldName = this.relatedFieldMapping.getName();
                this.relatedFieldLoadManager = new RelatedFieldLoadManager(){

                    @Override
                    public void load(OpenJPAStateManager sm, NdbOpenJPAStoreManager store, JDBCFetchConfiguration fetch) throws SQLException {
                        SessionSPI session = store.getSession();
                        session.startAutoTransaction();
                        NdbOpenJPAResult queryResult = NdbOpenJPADomainFieldHandlerImpl.this.queryRelated(sm, store);
                        Object related = null;
                        try {
                            if (queryResult.next()) {
                                related = store.load(NdbOpenJPADomainFieldHandlerImpl.this.relatedTypeMapping, fetch, null, queryResult);
                            }
                            if (logger.isDetailEnabled()) {
                                logger.detail("related object is: " + related);
                            }
                            sm.storeObjectField(NdbOpenJPADomainFieldHandlerImpl.this.fieldNumber, related);
                            session.endAutoTransaction();
                        }
                        catch (Exception e) {
                            session.failAutoTransaction();
                        }
                    }
                };
                if (logger.isDetailEnabled()) {
                    logger.detail("Single-valued relationship field " + this.name + " is mapped by " + this.relatedTypeName + " field " + this.relatedFieldName + " with relatedDomainTypeHandler " + this.relatedDomainTypeHandler.getName());
                }
            } else if (this.isMappedBy && !this.isToOne) {
                this.relatedTypeMapping = this.mappedByMapping.getDeclaringMapping();
                this.relatedDomainTypeHandler = ((NdbOpenJPADomainTypeHandlerImpl)this.domainTypeHandler).registerDependency(this.relatedTypeMapping);
                this.relatedFieldName = this.mappedByMapping.getName();
                this.relatedTypeName = this.relatedDomainTypeHandler.getName();
                if (logger.isDetailEnabled()) {
                    logger.detail("Multi-valued relationship field " + this.name + " is mapped by " + this.relatedTypeName + " field " + this.relatedFieldName);
                }
                this.relatedFieldLoadManager = new RelatedFieldLoadManager(){

                    @Override
                    public void load(OpenJPAStateManager sm, NdbOpenJPAStoreManager store, JDBCFetchConfiguration fetch) throws SQLException {
                        SessionSPI session = store.getSession();
                        session.startAutoTransaction();
                        try {
                            NdbOpenJPAResult queryResult = NdbOpenJPADomainFieldHandlerImpl.this.queryRelated(sm, store);
                            while (queryResult.next()) {
                                if (logger.isDetailEnabled()) {
                                    logger.detail("loading related instance of type: " + NdbOpenJPADomainFieldHandlerImpl.this.relatedTypeMapping.getDescribedType().getName());
                                }
                                store.load(NdbOpenJPADomainFieldHandlerImpl.this.relatedTypeMapping, fetch, null, queryResult);
                            }
                            NdbOpenJPADomainFieldHandlerImpl.this.fieldMapping.load(sm, (JDBCStore)store, fetch);
                            session.endAutoTransaction();
                        }
                        catch (Exception e) {
                            session.failAutoTransaction();
                            throw new ClusterJException(local.message("ERR_Exception_While_Loading"), e);
                        }
                    }
                };
            } else {
                if (logger.isDetailEnabled()) {
                    logger.detail("NdbOpenJPADomainFieldHandlerImpl.initializeRelations for " + this.fieldMapping.getName() + " column " + (this.column == null ? "null" : this.column.getName()) + " relatedFieldName " + this.relatedFieldName + " relatedFieldMapping " + this.relatedFieldMapping + " relatedTypeMapping " + this.relatedTypeMapping);
                }
                if (this.relatedTypeMapping != null) {
                    this.relatedDomainTypeHandler = ((NdbOpenJPADomainTypeHandlerImpl)this.domainTypeHandler).registerDependency(this.relatedTypeMapping);
                    this.relatedFieldLoadManager = new RelatedFieldLoadManager(){

                        @Override
                        public void load(OpenJPAStateManager sm, NdbOpenJPAStoreManager store, JDBCFetchConfiguration fetch) throws SQLException {
                            if (logger.isDetailEnabled()) {
                                logger.detail("Loading field " + NdbOpenJPADomainFieldHandlerImpl.this.name + "from stored key");
                            }
                            NdbOpenJPADomainFieldHandlerImpl.this.fieldMapping.load(sm, (JDBCStore)store, fetch);
                        }
                    };
                }
            }
        }
    }

    private AbstractDomainFieldHandlerImpl.ObjectOperationHandler getObjectOperationHandler(int javaType) {
        AbstractDomainFieldHandlerImpl.ObjectOperationHandler result = objectOperationHandlerUnsupportedType;
        if (javaType < this.objectOperationHandlers.length) {
            result = this.objectOperationHandlers[javaType];
        }
        switch (javaType) {
            case 1007: {
                return objectOperationHandlerJavaSqlDate;
            }
            case 1010: {
                return objectOperationHandlerJavaSqlTime;
            }
            case 1011: {
                return objectOperationHandlerJavaSqlTimestamp;
            }
            case 1004: {
                switch (this.storeColumn.getType()) {
                    case Blob: 
                    case Longvarbinary: {
                        return objectOperationHandlerBytesLob;
                    }
                    case Binary: 
                    case Varbinary: {
                        return objectOperationHandlerBytes;
                    }
                }
            }
            case 9: {
                switch (this.storeColumn.getType()) {
                    case Text: {
                        return objectOperationHandlerStringLob;
                    }
                    case Char: 
                    case Varchar: 
                    case Longvarchar: {
                        return objectOperationHandlerString;
                    }
                }
            }
        }
        return result;
    }

    public NdbOpenJPADomainFieldHandlerImpl(NdbOpenJPADomainFieldHandlerImpl parent, Column localColumn, Column pkColumn) {
        FieldMapping[] relatedFieldMappings;
        String message = null;
        if (logger.isDetailEnabled()) {
            logger.detail("NdbOpenJPADomainFieldHandlerImpl<init> for localColumn: " + localColumn + " pkColumn: " + pkColumn);
        }
        this.column = localColumn;
        Table table = parent.domainTypeHandler.getStoreTable();
        this.storeColumn = table.getColumn(localColumn.getName());
        if (this.storeColumn == null) {
            message = local.message("ERR_No_Column", parent.getName(), table.getName(), this.columnName);
            this.setUnsupported(message);
            logger.info(message);
            return;
        }
        this.javaType = this.column.getJavaType();
        this.objectOperationHandlerDelegate = this.getObjectOperationHandlerRelationDelegate(this.javaType);
        if (this.objectOperationHandlerDelegate == null) {
            return;
        }
        this.columnName = this.column.getName();
        this.fieldNumber = parent.fieldNumber;
        this.domainTypeHandler = parent.domainTypeHandler;
        this.relatedTypeMapping = parent.relatedTypeMapping;
        if (this.relatedTypeMapping != null) {
            this.relatedType = this.relatedTypeMapping.getDescribedType();
            if (this.relatedType != null) {
                this.relatedTypeName = this.relatedType.getName();
            }
        }
        for (FieldMapping rfm : relatedFieldMappings = this.relatedTypeMapping.getPrimaryKeyFieldMappings()) {
            Column[] rcs = rfm.getColumns();
            if (logger.isDetailEnabled()) {
                logger.detail("NdbOpenJPADomainFieldHandlerImpl<init> trying primary key column: " + rcs[0]);
            }
            if (rcs.length != 1 || !rcs[0].equals(pkColumn)) continue;
            String pkFieldName = rfm.getName();
            this.oidField = NdbOpenJPADomainFieldHandlerImpl.getFieldForOidClass(this, this.relatedTypeMapping.getObjectIdType(), pkFieldName);
            if (!logger.isDetailEnabled()) break;
            logger.detail("NdbOpenJPADomainFieldHandlerImpl<init> found primary key column: " + rcs[0] + " for field: " + pkFieldName);
            break;
        }
        if (this.oidField == null) {
            message = local.message("ERR_No_Oid_Field", (Object)pkColumn);
            this.setUnsupported(message);
            logger.info(message);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(" Relation Field Handler for column: " + this.columnName + " number: " + this.fieldNumber + " name: " + this.name + " column: " + this.columnName + " Java type: " + this.javaType + " ObjectOperationHandler: " + this.objectOperationHandlerDelegate.handler());
        }
    }

    public void load(OpenJPAStateManager sm, NdbOpenJPAStoreManager store, JDBCFetchConfiguration fetch) throws SQLException {
        if (!this.isRelation) {
            throw new ClusterJFatalInternalException("load called for non-relationship field " + this.getName() + " mapped to column " + this.columnName);
        }
        this.relatedFieldLoadManager.load(sm, store, fetch);
    }

    private NdbOpenJPAResult queryRelated(OpenJPAStateManager sm, NdbOpenJPAStoreManager store) {
        OpenJPAId openJPAId = (OpenJPAId)sm.getObjectId();
        Object thisOid = openJPAId.getIdObject();
        QueryDomainType<?> queryDomainType = store.createQueryDomainType(this.relatedType);
        if (logger.isDetailEnabled()) {
            logger.detail("created query for " + queryDomainType.getType().getName());
        }
        Predicate predicate = queryDomainType.get(this.relatedFieldName).equal(queryDomainType.param(this.relatedFieldName));
        queryDomainType.where(predicate);
        HashMap<String, Object> parameterList = new HashMap<String, Object>();
        parameterList.put(this.relatedFieldName, thisOid);
        if (logger.isDetailEnabled()) {
            logger.detail(((Object)parameterList).toString());
        }
        NdbOpenJPAResult queryResult = store.executeQuery(this.relatedDomainTypeHandler, queryDomainType, parameterList);
        if (logger.isDetailEnabled()) {
            DomainTypeHandler<?> handler = queryResult.domainTypeHandler;
            Set<String> columnNames = queryResult.getColumnNames();
            StringBuffer buffer = new StringBuffer("Executed query for ");
            buffer.append(handler.getName());
            buffer.append(" returned columns: ");
            buffer.append(Arrays.toString(columnNames.toArray()));
            logger.detail(buffer.toString());
        }
        return queryResult;
    }

    public void load(OpenJPAStateManager sm, NdbOpenJPAStoreManager store, JDBCFetchConfiguration fetch, NdbOpenJPAResult result) throws SQLException {
        this.fieldMapping.load(sm, (JDBCStore)store, fetch, (Result)result);
    }

    public Map<String, Object> createParameterMap(QueryDomainType<?> queryDomainType, Object thisOid) {
        return ((ObjectOperationHandlerRelationField)this.objectOperationHandlerDelegate).createParameterMap(this, queryDomainType, thisOid);
    }

    public int compareTo(Object o) {
        return this.compareTo((NdbOpenJPADomainFieldHandlerImpl)o);
    }

    protected String toString(Object o) {
        return o.getClass().getSimpleName();
    }

    Column[] getColumns() {
        return this.fieldMapping.getColumns();
    }

    protected Object getKeyValue(Object keys) {
        Object key = keys;
        if (keys instanceof ObjectId) {
            key = ((ObjectId)keys).getId();
        }
        return NdbOpenJPADomainFieldHandlerImpl.getKeyValue(this.oidField, key);
    }

    protected static Object getKeyValue(Field field, Object keys) {
        try {
            Object result;
            String fieldName = "none";
            if (field != null) {
                result = field.get(keys);
                fieldName = field.getName();
            } else {
                result = keys;
            }
            if (logger.isDetailEnabled()) {
                logger.detail("For field " + fieldName + " keys: " + keys + " value returned is " + result);
            }
            return result;
        }
        catch (IllegalArgumentException ex) {
            String message = "IllegalArgumentException, field " + field.getDeclaringClass().getName() + ":" + field.getName() + " keys: " + keys;
            logger.error(message);
            throw new ClusterJUserException(message, ex);
        }
        catch (IllegalAccessException ex) {
            String message = "IllegalAccessException, field " + field.getDeclaringClass().getName() + ":" + field.getName() + " keys: " + keys;
            throw new ClusterJUserException(message, ex);
        }
    }

    public Field getOidField() {
        return this.oidField;
    }

    protected static Field getFieldForOidClass(NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl, Class<?> oidClass, String fieldName) {
        String message = null;
        Field result = null;
        if (logger.isDetailEnabled()) {
            logger.detail("Oid class: " + oidClass.getName());
        }
        if (OpenJPAId.class.isAssignableFrom(oidClass)) {
            return null;
        }
        try {
            result = oidClass.getField(fieldName);
            if (logger.isDetailEnabled()) {
                logger.detail("OidField: " + result);
            }
            return result;
        }
        catch (NoSuchFieldException ex) {
            message = local.message("ERR_No_Field_In_Oid_Class", (Object)oidClass.getName(), (Object)fieldName);
            logger.info(message);
            ndbOpenJPADomainFieldHandlerImpl.setUnsupported(message);
            return null;
        }
        catch (SecurityException ex) {
            message = local.message("ERR_Security_Violation_For_Oid_Class", (Object)oidClass.getName());
            logger.info(message);
            ndbOpenJPADomainFieldHandlerImpl.setUnsupported(message);
            return null;
        }
    }

    protected AbstractDomainFieldHandlerImpl.ObjectOperationHandler getObjectOperationHandlerRelationDelegate(int javaType) {
        switch (javaType) {
            case 5: 
            case 21: {
                return objectOperationHandlerRelationIntField;
            }
            case 6: 
            case 22: {
                return objectOperationHandlerRelationLongField;
            }
            case 9: {
                return objectOperationHandlerRelationStringField;
            }
        }
        String message = local.message("ERR_Illegal_Foreign_Key_Type", this.domainTypeHandler.getName(), this.name, this.columnName, javaType);
        this.setUnsupported(message);
        return null;
    }

    public com.mysql.clusterj.core.store.Column[] getStoreColumns() {
        return this.storeColumns;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public boolean isRelation() {
        return this.isRelation;
    }

    public String getReason() {
        return this.reason;
    }

    private void setUnsupported(String reason) {
        this.supported = false;
        this.reason = reason;
    }

    static abstract class ObjectOperationHandlerRelationField
    implements AbstractDomainFieldHandlerImpl.ObjectOperationHandler {
        ObjectOperationHandlerRelationField() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        public Map<String, Object> createParameterMap(NdbOpenJPADomainFieldHandlerImpl domainFieldHandler, QueryDomainType<?> queryDomainObject, Object oid) {
            String name = domainFieldHandler.name;
            PredicateOperand parameter = queryDomainObject.get(name);
            Predicate predicate = parameter.equal(parameter);
            queryDomainObject.where(predicate);
            HashMap<String, Object> result = new HashMap<String, Object>();
            Object value = domainFieldHandler.getKeyValue(oid);
            result.put(name, value);
            if (logger.isDetailEnabled()) {
                logger.detail("Map.Entry key: " + name + ", value: " + value);
            }
            return result;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.getStoreColumn());
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        protected int getInt(Object objectId) {
            if (objectId instanceof IntId) {
                return ((IntId)objectId).getId();
            }
            if (objectId instanceof OpenJPAId) {
                OpenJPAId openJPAId = (OpenJPAId)objectId;
                Object id = openJPAId.getIdObject();
                if (id instanceof Integer) {
                    return (Integer)id;
                }
                throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"int key", (Object)"OpenJPAId"));
            }
            String message = objectId == null ? "<null>" : objectId.getClass().getName();
            throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"int key", (Object)message));
        }

        protected long getLong(Object objectId) {
            if (objectId instanceof LongId) {
                return ((LongId)objectId).getId();
            }
            if (objectId instanceof OpenJPAId) {
                OpenJPAId openJPAId = (OpenJPAId)objectId;
                Object id = openJPAId.getIdObject();
                if (id instanceof Long) {
                    return (Long)id;
                }
                throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"long key", (Object)"OpenJPAId"));
            }
            String message = objectId == null ? "<null>" : objectId.getClass().getName();
            throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"long key", (Object)message));
        }

        protected String getString(Object objectId) {
            if (objectId instanceof StringId) {
                return ((StringId)objectId).getId();
            }
            if (objectId instanceof OpenJPAId) {
                OpenJPAId openJPAId = (OpenJPAId)objectId;
                Object id = openJPAId.getIdObject();
                if (id instanceof String) {
                    return (String)id;
                }
                throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"String key", (Object)"OpenJPAId"));
            }
            String message = objectId == null ? "<null>" : objectId.getClass().getName();
            throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"String key", (Object)message));
        }

        protected OpenJPAStateManager getRelatedStateManager(ValueHandler handler, AbstractDomainFieldHandlerImpl fmd) {
            OpenJPAStateManager sm = ((NdbOpenJPAValueHandler)handler).getStateManager();
            NdbOpenJPAStoreManager store = ((NdbOpenJPAValueHandler)handler).getStoreManager();
            OpenJPAStateManager rel = RelationStrategies.getStateManager((Object)sm.fetchObjectField(fmd.getFieldNumber()), (StoreContext)store.getContext());
            return rel;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getObject(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler handler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Unsupported_Method", (Object)"objectGetValue", (Object)"ObjectOperationHandlerRelationField"));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Unsupported_Method", (Object)"objectSetValue", (Object)"ObjectOperationHandlerRelationField"));
        }
    }

    static interface RelatedFieldLoadManager {
        public void load(OpenJPAStateManager var1, NdbOpenJPAStoreManager var2, JDBCFetchConfiguration var3) throws SQLException;
    }
}

