/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DictionaryImpl;
import com.mysql.clusterj.tie.KeyPart;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbInterpretedCode;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.List;

class DbImpl
implements Db {
    static final I18NHelper local = I18NHelper.getInstance(DbImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DbImpl.class);
    private Ndb ndb;
    private int errorBufferSize = 300;
    private ByteBuffer errorBuffer = ByteBuffer.allocateDirect(this.errorBufferSize);
    private static final int COORDINATED_TRANSACTION_ID_SIZE = 44;
    private ByteBuffer coordinatedTransactionIdBuffer = ByteBuffer.allocateDirect(44);
    private ByteBuffer partitionKeyScratchBuffer = ByteBuffer.allocateDirect(10000);
    private BufferManager bufferManager = new BufferManager();
    private NdbDictionary.Dictionary ndbDictionary;
    private DictionaryImpl dictionary;
    private ClusterConnectionImpl clusterConnection;
    private int numberOfIndexBoundCreated;
    private int numberOfIndexBoundDeleted;
    private int numberOfInterpretedCodeCreated;
    private int numberOfInterpretedCodeDeleted;
    private int numberOfNdbScanFilterCreated;
    private int numberOfNdbScanFilterDeleted;
    private int numberOfScanOptionsCreated;
    private int numberOfScanOptionsDeleted;

    public DbImpl(ClusterConnectionImpl clusterConnection, Ndb ndb, int maxTransactions) {
        this.clusterConnection = clusterConnection;
        this.ndb = ndb;
        int returnCode = ndb.init(maxTransactions);
        this.handleError(returnCode, ndb);
        this.ndbDictionary = ndb.getDictionary();
        this.handleError(this.ndbDictionary, ndb);
        this.dictionary = new DictionaryImpl(this.ndbDictionary, clusterConnection);
    }

    @Override
    public void close() {
        if (this.numberOfIndexBoundCreated != this.numberOfIndexBoundDeleted) {
            logger.warn("numberOfIndexBoundCreated " + this.numberOfIndexBoundCreated + " != numberOfIndexBoundDeleted " + this.numberOfIndexBoundDeleted);
        }
        if (this.numberOfInterpretedCodeCreated != this.numberOfInterpretedCodeDeleted) {
            logger.warn("numberOfInterpretedCodeCreated " + this.numberOfInterpretedCodeCreated + " != numberOfInterpretedCodeDeleted " + this.numberOfInterpretedCodeDeleted);
        }
        if (this.numberOfNdbScanFilterCreated != this.numberOfNdbScanFilterDeleted) {
            logger.warn("numberOfNdbScanFilterCreated " + this.numberOfNdbScanFilterCreated + " != numberOfNdbScanFilterDeleted " + this.numberOfNdbScanFilterDeleted);
        }
        if (this.numberOfScanOptionsCreated != this.numberOfScanOptionsDeleted) {
            logger.warn("numberOfScanOptionsCreated " + this.numberOfScanOptionsCreated + " != numberOfScanOptionsDeleted " + this.numberOfScanOptionsDeleted);
        }
        if (this.ndb != null) {
            Ndb.delete(this.ndb);
            this.ndb = null;
        }
        this.clusterConnection.close(this);
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public NdbDictionary.Dictionary getNdbDictionary() {
        return this.ndbDictionary;
    }

    @Override
    public ClusterTransaction startTransaction(String joinTransactionId) {
        return new ClusterTransactionImpl(this.clusterConnection, this, this.ndbDictionary, joinTransactionId);
    }

    protected void handleError(int returnCode, Ndb ndb) {
        if (returnCode == 0) {
            return;
        }
        NdbErrorConst ndbError = ndb.getNdbError();
        String detail = this.getNdbErrorDetail(ndbError);
        Utility.throwError(returnCode, ndbError, detail);
    }

    protected void handleError(Object object, Ndb ndb) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbError = ndb.getNdbError();
        String detail = this.getNdbErrorDetail(ndbError);
        Utility.throwError(null, ndbError, detail);
    }

    @Override
    public boolean isRetriable(ClusterJDatastoreException ex) {
        return Utility.isRetriable(ex);
    }

    public String getNdbErrorDetail(NdbErrorConst ndbError) {
        return this.ndb.getNdbErrorDetail(ndbError, this.errorBuffer, this.errorBuffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdbTransaction enlist(String tableName, List<KeyPart> keyParts) {
        if (keyParts == null || keyParts.size() <= 0) {
            throw new ClusterJFatalInternalException(local.message("ERR_Key_Parts_Must_Not_Be_Null_Or_Zero_Length", (Object)tableName));
        }
        int keyPartsSize = keyParts.size();
        NdbTransaction ndbTransaction = null;
        NdbDictionary.TableConst table = this.ndbDictionary.getTable(tableName);
        this.handleError(table, this.ndb);
        Ndb.Key_part_ptrArray key_part_ptrArray = null;
        if (keyPartsSize == 1) {
            ByteBuffer buffer = keyParts.get((int)0).buffer;
            int length = keyParts.get((int)0).length;
            ndbTransaction = this.ndb.startTransaction(table, buffer, length);
            if (ndbTransaction == null) {
                logger.warn(local.message("ERR_Transaction_Start_Failed", tableName, buffer.position(), buffer.limit(), buffer.capacity(), length));
            }
            this.handleError(ndbTransaction, this.ndb);
            return ndbTransaction;
        }
        key_part_ptrArray = Ndb.Key_part_ptrArray.create(keyPartsSize + 1);
        try {
            Ndb.Key_part_ptr key_part_ptr;
            for (int i = 0; i < keyPartsSize; ++i) {
                key_part_ptr = key_part_ptrArray.at(i);
                key_part_ptr.ptr(keyParts.get((int)i).buffer);
                key_part_ptr.len(keyParts.get((int)i).length);
            }
            key_part_ptr = key_part_ptrArray.at(keyPartsSize);
            key_part_ptr.ptr(null);
            key_part_ptr.len(0);
            ndbTransaction = this.ndb.startTransaction(table, key_part_ptrArray, this.partitionKeyScratchBuffer, this.partitionKeyScratchBuffer.capacity());
            this.handleError(ndbTransaction, this.ndb);
            NdbTransaction ndbTransaction2 = ndbTransaction;
            return ndbTransaction2;
        }
        finally {
            Ndb.Key_part_ptrArray.delete(key_part_ptrArray);
        }
    }

    public NdbTransaction enlist(String tableName, int partitionId) {
        NdbTransaction result = null;
        if (tableName == null) {
            result = this.ndb.startTransaction(null, null, 0);
        } else {
            NdbDictionary.TableConst table = this.ndbDictionary.getTable(tableName);
            result = this.ndb.startTransaction(table, partitionId);
        }
        this.handleError(result, this.ndb);
        return result;
    }

    public ByteBuffer getCoordinatedTransactionIdBuffer() {
        return this.coordinatedTransactionIdBuffer;
    }

    public NdbTransaction joinTransaction(String coordinatedTransactionId) {
        if (logger.isDetailEnabled()) {
            logger.detail("CoordinatedTransactionId: " + coordinatedTransactionId);
        }
        throw new ClusterJFatalInternalException("Not Implemented");
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public NdbRecordOperationImpl newNdbRecordOperationImpl(Table storeTable) {
        return this.clusterConnection.newNdbRecordOperationImpl(this, storeTable);
    }

    public NdbIndexScanOperation.IndexBound createIndexBound() {
        ++this.numberOfIndexBoundCreated;
        return NdbIndexScanOperation.IndexBound.create();
    }

    public void delete(NdbIndexScanOperation.IndexBound ndbIndexBound) {
        ++this.numberOfIndexBoundDeleted;
        NdbIndexScanOperation.IndexBound.delete(ndbIndexBound);
    }

    public NdbInterpretedCode createInterpretedCode(NdbDictionary.TableConst ndbTable, int i) {
        ++this.numberOfInterpretedCodeCreated;
        return NdbInterpretedCode.create(ndbTable, null, i);
    }

    public void delete(NdbInterpretedCode ndbInterpretedCode) {
        ++this.numberOfInterpretedCodeDeleted;
        NdbInterpretedCode.delete(ndbInterpretedCode);
    }

    public NdbScanFilter createScanFilter(NdbInterpretedCode ndbInterpretedCode) {
        ++this.numberOfNdbScanFilterCreated;
        return NdbScanFilter.create(ndbInterpretedCode);
    }

    public void delete(NdbScanFilter ndbScanFilter) {
        ++this.numberOfNdbScanFilterDeleted;
        NdbScanFilter.delete(ndbScanFilter);
    }

    public NdbScanOperation.ScanOptions createScanOptions() {
        ++this.numberOfScanOptionsCreated;
        return NdbScanOperation.ScanOptions.create();
    }

    public void delete(NdbScanOperation.ScanOptions scanOptions) {
        ++this.numberOfScanOptionsDeleted;
        NdbScanOperation.ScanOptions.delete(scanOptions);
    }

    public class BufferManager {
        public static final int STRING_BYTE_BUFFER_INITIAL_SIZE = 1000;
        private int stringByteBufferCurrentSize = 1000;
        ByteBuffer stringByteBuffer = null;
        CharBuffer stringCharBuffer = null;
        public static final int STRING_STORAGE_BUFFER_INITIAL_SIZE = 500;
        private ByteBuffer stringStorageBuffer = ByteBuffer.allocateDirect(500);
        private static final int RESULT_DATA_BUFFER_INITIAL_SIZE = 8000;
        private ByteBuffer resultDataBuffer = ByteBuffer.allocateDirect(8000);

        public void guaranteeStringStorageBufferSize(int sizeNeeded) {
            if (sizeNeeded > this.stringStorageBuffer.capacity()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(local.message("MSG_Reallocated_Byte_Buffer", "string storage", this.stringStorageBuffer.capacity(), sizeNeeded));
                }
                this.stringStorageBuffer = ByteBuffer.allocateDirect(sizeNeeded);
            }
            this.stringStorageBuffer.limit(this.stringStorageBuffer.capacity());
        }

        public ByteBuffer copyStringToByteBuffer(CharSequence value) {
            if (value == null) {
                this.stringByteBuffer.limit(0);
                return this.stringByteBuffer;
            }
            int sizeNeeded = value.length() * 2;
            this.guaranteeStringByteBufferSize(sizeNeeded);
            this.stringCharBuffer.append(value);
            this.stringByteBuffer.limit(this.stringCharBuffer.position() * 2);
            return this.stringByteBuffer;
        }

        public void clearStringStorageBuffer() {
            this.stringStorageBuffer.clear();
        }

        public ByteBuffer getStringStorageBuffer(int sizeNeeded) {
            this.guaranteeStringStorageBufferSize(sizeNeeded);
            return this.stringStorageBuffer;
        }

        public ByteBuffer getStringByteBuffer(int sizeNeeded) {
            this.guaranteeStringByteBufferSize(sizeNeeded);
            return this.stringByteBuffer;
        }

        protected void guaranteeStringByteBufferSize(int sizeNeeded) {
            if (sizeNeeded > this.stringByteBufferCurrentSize) {
                this.stringByteBufferCurrentSize = sizeNeeded;
                this.stringByteBuffer = ByteBuffer.allocateDirect(this.stringByteBufferCurrentSize);
                this.stringCharBuffer = this.stringByteBuffer.asCharBuffer();
            }
            if (this.stringByteBuffer == null) {
                this.stringByteBuffer = ByteBuffer.allocateDirect(this.stringByteBufferCurrentSize);
                this.stringCharBuffer = this.stringByteBuffer.asCharBuffer();
            } else {
                this.stringByteBuffer.clear();
                this.stringCharBuffer.clear();
            }
        }

        public CharBuffer getStringCharBuffer() {
            return this.stringCharBuffer;
        }

        public ByteBuffer getResultDataBuffer(int sizeNeeded) {
            if (sizeNeeded > this.resultDataBuffer.capacity()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(local.message("MSG_Reallocated_Byte_Buffer", "result data", this.resultDataBuffer.capacity(), sizeNeeded));
                }
                this.resultDataBuffer = ByteBuffer.allocateDirect(sizeNeeded);
            }
            this.resultDataBuffer.clear();
            return this.resultDataBuffer;
        }
    }
}

