/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJUserException;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.NullValues;

public class NullValuesTest
extends AbstractClusterJModelTest {
    protected static final String tablename = "nullvalues";
    protected static final int numberOfPropertyTypes = 7;
    protected static final int numberOfFieldsPerProperty = 12;
    protected static final int DATABASE_NOT_NULL = 0;
    protected static final int DATABASE_NULL = 1;
    protected static final String[] databaseNull = new String[]{"DATABASE_NOT_NULL", "DATABASE_NULL"};
    protected static final int DATABASE_NO_DEFAULT = 0;
    protected static final int DATABASE_DEFAULT = 2;
    protected static final String[] databaseDefault = new String[]{"DATABASE_NO_DEFAULT", "DATABASE_DEFAULT"};
    protected static final int NULLVALUE_NONE = 0;
    protected static final int NULLVALUE_EXCEPTION = 4;
    protected static final int NULLVALUE_DEFAULT = 8;
    protected static final String[] nullValue = new String[]{"NULL_VALUE_NONE", "NULL_VALUE_EXCEPTION", "NULL_VALUE_DEFAULT"};
    protected static final String[] propertyTypes = new String[]{"Integer", "Long", "Short", "Byte", "String", "Float", "Double"};

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.session.deletePersistentAll(NullValues.class);
        this.addTearDownClasses(NullValues.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        NullValues instance = this.createValidInstance();
        int id = 0;
        instance.setId(id);
        this.session.makePersistent((Object)instance);
        this.tx.commit();
        this.tx.begin();
        instance = (NullValues)this.session.find(NullValues.class, (Object)id);
        this.session.deletePersistent((Object)instance);
        this.tx.commit();
        for (int propertyType = 0; propertyType < 7; ++propertyType) {
            for (int fieldIndex = 0; fieldIndex < 12; ++fieldIndex) {
                NullValues instance2 = this.createValidInstance();
                int id2 = propertyType * 12 + fieldIndex;
                instance2.setId(id2);
                try {
                    this.tx.begin();
                    this.setValue(instance2, propertyType, fieldIndex, true);
                    this.session.makePersistent((Object)instance2);
                    this.tx.commit();
                    if (this.expectedException(id2, null)) {
                        this.error("Expected exception not thrown for case " + this.decodeType(propertyType) + ": " + this.decodeValues(id2));
                    }
                }
                catch (Exception e) {
                    if (this.expectedException(id2, e)) continue;
                    this.error("Unexpected exception from commit for case " + this.decodeType(propertyType) + ": " + this.decodeValues(id2) + " " + e.toString());
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                }
                try {
                    this.tx.begin();
                    instance2 = (NullValues)this.session.find(NullValues.class, (Object)id2);
                    this.verifyNullValues(propertyType, fieldIndex, id2, instance2);
                    this.tx.commit();
                    continue;
                }
                catch (Exception e) {
                    this.error("Unexpected exception from find for case" + this.decodeType(propertyType) + ": " + this.decodeValues(id2) + " " + e.toString());
                    e.printStackTrace();
                }
            }
        }
        this.failOnError();
    }

    protected NullValues createValidInstance() {
        NullValues instance = (NullValues)this.session.newInstance(NullValues.class);
        for (int propertyType = 0; propertyType < 7; ++propertyType) {
            for (int fieldIndex = 0; fieldIndex < 12; ++fieldIndex) {
                this.setValue(instance, propertyType, fieldIndex, false);
            }
        }
        return instance;
    }

    protected int whatDatabaseDefault(int id) {
        return (id % 12 & 2) >> 1;
    }

    protected int whatDatabaseNull(int id) {
        return id % 12 & 1;
    }

    protected int whatNullValue(int id) {
        return (id % 12 & 0xC) >> 2;
    }

    private String decodeValues(int id) {
        String databaseNullResult = databaseNull[this.whatDatabaseNull(id)];
        String databaseDefaultResult = databaseDefault[this.whatDatabaseDefault(id)];
        String nullValueResult = nullValue[this.whatNullValue(id)];
        return databaseNullResult + " " + databaseDefaultResult + " " + nullValueResult;
    }

    private String decodeType(int type) {
        return propertyTypes[type];
    }

    private boolean expectedException(int id, Exception e) {
        Throwable t;
        Throwable throwable = t = e == null ? null : e.getCause();
        if (this.whatDatabaseNull(id) == 0 && this.whatNullValue(id) == 0) {
            if (e != null && e instanceof ClusterJDatastoreException) {
                return true;
            }
            if (t instanceof Exception) {
                return this.expectedException(id, (Exception)t);
            }
            return false;
        }
        if (this.whatNullValue(id) == 1) {
            return e != null && e instanceof ClusterJUserException;
        }
        return false;
    }

    private void verifyNullValues(int propertyType, int fieldIndex, int id, NullValues instance) {
        Object value = this.getValue(instance, propertyType, fieldIndex);
        if (this.whatDatabaseNull(id) == 1 && this.whatDatabaseDefault(id) == 0 && this.whatNullValue(id) == 0) {
            this.errorIfNotEqual("For id " + id + " propertyType " + propertyType + " fieldIndex " + fieldIndex + " instance was " + (instance == null ? "null" : instance.toString() + " value was " + (value == null ? "null " : value + " of type " + value.getClass().getName() + " ") + this.decodeValues(id)), null, value);
        }
    }

    private void setValue(NullValues instance, int propertyType, int fieldIndex, boolean nullValue) {
        block0 : switch (propertyType) {
            case 0: {
                switch (fieldIndex) {
                    case 0: {
                        instance.setIntNotNullNoDefaultNullValueNone(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 1: {
                        instance.setIntNullNoDefaultNullValueNone(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 2: {
                        instance.setIntNotNullDefaultNullValueNone(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 3: {
                        instance.setIntNullDefaultNullValueNone(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 4: {
                        instance.setIntNotNullNoDefaultNullValueException(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 5: {
                        instance.setIntNullNoDefaultNullValueException(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 6: {
                        instance.setIntNotNullDefaultNullValueException(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 7: {
                        instance.setIntNullDefaultNullValueException(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 8: {
                        instance.setIntNotNullNoDefaultNullValueDefault(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 9: {
                        instance.setIntNullNoDefaultNullValueDefault(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 10: {
                        instance.setIntNotNullDefaultNullValueDefault(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 11: {
                        instance.setIntNullDefaultNullValueDefault(nullValue ? null : Integer.valueOf(0));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 1: {
                switch (fieldIndex) {
                    case 0: {
                        instance.setLongNotNullNoDefaultNullValueNone(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 1: {
                        instance.setLongNullNoDefaultNullValueNone(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 2: {
                        instance.setLongNotNullDefaultNullValueNone(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 3: {
                        instance.setLongNullDefaultNullValueNone(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 4: {
                        instance.setLongNotNullNoDefaultNullValueException(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 5: {
                        instance.setLongNullNoDefaultNullValueException(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 6: {
                        instance.setLongNotNullDefaultNullValueException(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 7: {
                        instance.setLongNullDefaultNullValueException(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 8: {
                        instance.setLongNotNullNoDefaultNullValueDefault(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 9: {
                        instance.setLongNullNoDefaultNullValueDefault(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 10: {
                        instance.setLongNotNullDefaultNullValueDefault(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    case 11: {
                        instance.setLongNullDefaultNullValueDefault(nullValue ? null : Long.valueOf(0L));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal field index " + fieldIndex);
                    }
                }
            }
            case 2: {
                switch (fieldIndex) {
                    case 0: {
                        instance.setShortNotNullNoDefaultNullValueNone(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 1: {
                        instance.setShortNullNoDefaultNullValueNone(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 2: {
                        instance.setShortNotNullDefaultNullValueNone(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 3: {
                        instance.setShortNullDefaultNullValueNone(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 4: {
                        instance.setShortNotNullNoDefaultNullValueException(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 5: {
                        instance.setShortNullNoDefaultNullValueException(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 6: {
                        instance.setShortNotNullDefaultNullValueException(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 7: {
                        instance.setShortNullDefaultNullValueException(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 8: {
                        instance.setShortNotNullNoDefaultNullValueDefault(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 9: {
                        instance.setShortNullNoDefaultNullValueDefault(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 10: {
                        instance.setShortNotNullDefaultNullValueDefault(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 11: {
                        instance.setShortNullDefaultNullValueDefault(nullValue ? null : Short.valueOf((short)0));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal field index " + fieldIndex);
                    }
                }
            }
            case 3: {
                switch (fieldIndex) {
                    case 0: {
                        instance.setByteNotNullNoDefaultNullValueNone(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 1: {
                        instance.setByteNullNoDefaultNullValueNone(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 2: {
                        instance.setByteNotNullDefaultNullValueNone(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 3: {
                        instance.setByteNullDefaultNullValueNone(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 4: {
                        instance.setByteNotNullNoDefaultNullValueException(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 5: {
                        instance.setByteNullNoDefaultNullValueException(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 6: {
                        instance.setByteNotNullDefaultNullValueException(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 7: {
                        instance.setByteNullDefaultNullValueException(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 8: {
                        instance.setByteNotNullNoDefaultNullValueDefault(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 9: {
                        instance.setByteNullNoDefaultNullValueDefault(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 10: {
                        instance.setByteNotNullDefaultNullValueDefault(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 11: {
                        instance.setByteNullDefaultNullValueDefault(nullValue ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal field index " + fieldIndex);
                    }
                }
            }
            case 4: {
                switch (fieldIndex) {
                    case 0: {
                        instance.setStringNotNullNoDefaultNullValueNone(nullValue ? null : "0");
                        break block0;
                    }
                    case 1: {
                        instance.setStringNullNoDefaultNullValueNone(nullValue ? null : "0");
                        break block0;
                    }
                    case 2: {
                        instance.setStringNotNullDefaultNullValueNone(nullValue ? null : "0");
                        break block0;
                    }
                    case 3: {
                        instance.setStringNullDefaultNullValueNone(nullValue ? null : "0");
                        break block0;
                    }
                    case 4: {
                        instance.setStringNotNullNoDefaultNullValueException(nullValue ? null : "0");
                        break block0;
                    }
                    case 5: {
                        instance.setStringNullNoDefaultNullValueException(nullValue ? null : "0");
                        break block0;
                    }
                    case 6: {
                        instance.setStringNotNullDefaultNullValueException(nullValue ? null : "0");
                        break block0;
                    }
                    case 7: {
                        instance.setStringNullDefaultNullValueException(nullValue ? null : "0");
                        break block0;
                    }
                    case 8: {
                        instance.setStringNotNullNoDefaultNullValueDefault(nullValue ? null : "0");
                        break block0;
                    }
                    case 9: {
                        instance.setStringNullNoDefaultNullValueDefault(nullValue ? null : "0");
                        break block0;
                    }
                    case 10: {
                        instance.setStringNotNullDefaultNullValueDefault(nullValue ? null : "0");
                        break block0;
                    }
                    case 11: {
                        instance.setStringNullDefaultNullValueDefault(nullValue ? null : "0");
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 5: {
                switch (fieldIndex) {
                    case 0: {
                        instance.setFloatNotNullNoDefaultNullValueNone(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 1: {
                        instance.setFloatNullNoDefaultNullValueNone(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 2: {
                        instance.setFloatNotNullDefaultNullValueNone(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 3: {
                        instance.setFloatNullDefaultNullValueNone(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 4: {
                        instance.setFloatNotNullNoDefaultNullValueException(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 5: {
                        instance.setFloatNullNoDefaultNullValueException(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 6: {
                        instance.setFloatNotNullDefaultNullValueException(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 7: {
                        instance.setFloatNullDefaultNullValueException(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 8: {
                        instance.setFloatNotNullNoDefaultNullValueDefault(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 9: {
                        instance.setFloatNullNoDefaultNullValueDefault(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 10: {
                        instance.setFloatNotNullDefaultNullValueDefault(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 11: {
                        instance.setFloatNullDefaultNullValueDefault(nullValue ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 6: {
                switch (fieldIndex) {
                    case 0: {
                        instance.setDoubleNotNullNoDefaultNullValueNone(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 1: {
                        instance.setDoubleNullNoDefaultNullValueNone(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 2: {
                        instance.setDoubleNotNullDefaultNullValueNone(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 3: {
                        instance.setDoubleNullDefaultNullValueNone(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 4: {
                        instance.setDoubleNotNullNoDefaultNullValueException(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 5: {
                        instance.setDoubleNullNoDefaultNullValueException(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 6: {
                        instance.setDoubleNotNullDefaultNullValueException(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 7: {
                        instance.setDoubleNullDefaultNullValueException(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 8: {
                        instance.setDoubleNotNullNoDefaultNullValueDefault(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 9: {
                        instance.setDoubleNullNoDefaultNullValueDefault(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 10: {
                        instance.setDoubleNotNullDefaultNullValueDefault(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 11: {
                        instance.setDoubleNullDefaultNullValueDefault(nullValue ? null : Double.valueOf(0.0));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            default: {
                throw new IllegalArgumentException("Illegal property type " + propertyType);
            }
        }
    }

    private Object getValue(NullValues instance, int propertyType, int fieldIndex) {
        if (instance == null) {
            return null;
        }
        switch (propertyType) {
            case 0: {
                switch (fieldIndex) {
                    case 0: {
                        return instance.getIntNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return instance.getIntNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return instance.getIntNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return instance.getIntNullDefaultNullValueNone();
                    }
                    case 4: {
                        return instance.getIntNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return instance.getIntNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return instance.getIntNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return instance.getIntNullDefaultNullValueException();
                    }
                    case 8: {
                        return instance.getIntNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return instance.getIntNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return instance.getIntNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return instance.getIntNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 1: {
                switch (fieldIndex) {
                    case 0: {
                        return instance.getLongNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return instance.getLongNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return instance.getLongNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return instance.getLongNullDefaultNullValueNone();
                    }
                    case 4: {
                        return instance.getLongNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return instance.getLongNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return instance.getLongNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return instance.getLongNullDefaultNullValueException();
                    }
                    case 8: {
                        return instance.getLongNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return instance.getLongNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return instance.getLongNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return instance.getLongNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 2: {
                switch (fieldIndex) {
                    case 0: {
                        return instance.getShortNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return instance.getShortNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return instance.getShortNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return instance.getShortNullDefaultNullValueNone();
                    }
                    case 4: {
                        return instance.getShortNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return instance.getShortNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return instance.getShortNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return instance.getShortNullDefaultNullValueException();
                    }
                    case 8: {
                        return instance.getShortNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return instance.getShortNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return instance.getShortNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return instance.getShortNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 3: {
                switch (fieldIndex) {
                    case 0: {
                        return instance.getByteNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return instance.getByteNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return instance.getByteNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return instance.getByteNullDefaultNullValueNone();
                    }
                    case 4: {
                        return instance.getByteNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return instance.getByteNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return instance.getByteNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return instance.getByteNullDefaultNullValueException();
                    }
                    case 8: {
                        return instance.getByteNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return instance.getByteNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return instance.getByteNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return instance.getByteNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 4: {
                switch (fieldIndex) {
                    case 0: {
                        return instance.getStringNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return instance.getStringNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return instance.getStringNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return instance.getStringNullDefaultNullValueNone();
                    }
                    case 4: {
                        return instance.getStringNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return instance.getStringNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return instance.getStringNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return instance.getStringNullDefaultNullValueException();
                    }
                    case 8: {
                        return instance.getStringNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return instance.getStringNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return instance.getStringNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return instance.getStringNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 5: {
                switch (fieldIndex) {
                    case 0: {
                        return instance.getFloatNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return instance.getFloatNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return instance.getFloatNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return instance.getFloatNullDefaultNullValueNone();
                    }
                    case 4: {
                        return instance.getFloatNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return instance.getFloatNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return instance.getFloatNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return instance.getFloatNullDefaultNullValueException();
                    }
                    case 8: {
                        return instance.getFloatNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return instance.getFloatNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return instance.getFloatNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return instance.getFloatNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
            case 6: {
                switch (fieldIndex) {
                    case 0: {
                        return instance.getDoubleNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return instance.getDoubleNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return instance.getDoubleNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return instance.getDoubleNullDefaultNullValueNone();
                    }
                    case 4: {
                        return instance.getDoubleNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return instance.getDoubleNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return instance.getDoubleNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return instance.getDoubleNullDefaultNullValueException();
                    }
                    case 8: {
                        return instance.getDoubleNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return instance.getDoubleNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return instance.getDoubleNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return instance.getDoubleNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + fieldIndex);
            }
        }
        throw new IllegalArgumentException("Illegal property type " + propertyType);
    }
}

