/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.ByteArrayTypes;
import testsuite.clusterj.model.IdBase;

public class QueryLikeByteArrayTypesTest
extends AbstractQueryTest {
    static byte[][] bytes = new byte[][]{{97, 97, 97, 97}, {97, 97, 97, 98}, {97, 97, 98, 97}, {97, 97, 98, 98}, {97, 98, 97, 97}, {97, 98, 97, 98}, {97, 98, 98, 97}, {97, 98, 98, 98}, {98, 97, 97, 97}, {98, 97, 97, 98}};

    @Override
    public Class<?> getInstanceType() {
        return ByteArrayTypes.class;
    }

    @Override
    void createInstances(int number) {
        this.createAllByteArrayTypesInstances(number);
    }

    public void test() {
        this.btreeIndexScanString();
        this.hashIndexScanString();
        this.bothIndexScanString();
        this.noneIndexScanString();
        this.failOnError();
    }

    public void btreeIndexScanString() {
        this.likeQuery("bytes_null_btree", "none", new byte[]{37}, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.likeQuery("bytes_null_btree", "none", new byte[]{95}, new int[0]);
        this.likeQuery("bytes_null_btree", "none", new byte[]{95, 95, 95, 95}, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.likeQuery("bytes_null_btree", "none", new byte[]{95, 97, 97, 97}, 0, 8);
        this.likeQuery("bytes_null_btree", "none", new byte[]{97, 98, 97, 97}, 4);
        this.likeQuery("bytes_null_btree", "none", new byte[]{97, 98, 97, 37}, 4, 5);
        this.likeQuery("bytes_null_btree", "none", new byte[]{97, 98, 37}, 4, 5, 6, 7);
        this.greaterEqualAndLikeQuery("bytes_null_btree", "idx_bytes_null_btree", this.getBytes(4), new byte[]{37}, 4, 5, 6, 7, 8, 9);
        this.greaterEqualAndLikeQuery("bytes_null_btree", "idx_bytes_null_btree", this.getBytes(4), new byte[]{97, 37, 98}, 5, 7);
        this.greaterThanAndLikeQuery("bytes_null_btree", "idx_bytes_null_btree", this.getBytes(4), new byte[]{37, 98, 98, 37}, 6, 7);
    }

    public void hashIndexScanString() {
        this.greaterEqualAndLikeQuery("bytes_null_hash", "none", this.getBytes(3), new byte[]{37, 98, 98, 37}, 3, 6, 7);
        this.greaterThanAndLikeQuery("bytes_null_hash", "none", this.getBytes(3), new byte[]{37, 98, 98, 37}, 6, 7);
    }

    public void bothIndexScanString() {
        this.greaterEqualAndLikeQuery("bytes_null_both", "idx_bytes_null_both", this.getBytes(3), new byte[]{37, 98, 98, 37}, 3, 6, 7);
        this.greaterThanAndLikeQuery("bytes_null_both", "idx_bytes_null_both", this.getBytes(3), new byte[]{37, 98, 98, 37}, 6, 7);
    }

    public void noneIndexScanString() {
        this.greaterEqualAndLikeQuery("bytes_null_none", "none", this.getBytes(3), new byte[]{37, 98, 98, 37}, 3, 6, 7);
        this.greaterThanAndLikeQuery("bytes_null_none", "none", this.getBytes(3), new byte[]{37, 98, 98, 37}, 6, 7);
    }

    private void createAllByteArrayTypesInstances(int number) {
        for (int i = 0; i < number; ++i) {
            ByteArrayTypes instance = (ByteArrayTypes)this.session.newInstance(ByteArrayTypes.class);
            instance.setId(i);
            instance.setBytes_null_hash(this.getBytes(i));
            instance.setBytes_null_btree(this.getBytes(i));
            instance.setBytes_null_both(this.getBytes(i));
            instance.setBytes_null_none(this.getBytes(i));
            this.instances.add(instance);
        }
    }

    protected byte[] getBytes(int number) {
        return bytes[number];
    }

    @Override
    protected void printResultInstance(IdBase instance) {
        if (instance instanceof ByteArrayTypes) {
            ByteArrayTypes byteArrayTypes = (ByteArrayTypes)instance;
        }
    }
}

