/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.util;

import com.mysql.clusterj.core.util.JDK14LoggerImpl;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;

public class JDK14LoggerFactoryImpl
implements LoggerFactory {
    public static final String CLUSTERJ_LOGGER = "com.mysql.clusterj.core";
    public static final String CLUSTERJ_METADATA_LOGGER = "com.mysql.clusterj.core.metadata";
    public static final String CLUSTERJ_UTIL_LOGGER = "com.mysql.clusterj.core.util";
    public static final String CLUSTERJ_QUERY_LOGGER = "com.mysql.clusterj.core.query";
    static final LogManager logManager = LogManager.getLogManager();
    static final Map<String, Logger> loggerMap = new HashMap<String, Logger>();

    public JDK14LoggerFactoryImpl() {
        this.registerLogger(CLUSTERJ_LOGGER);
        this.registerLogger(CLUSTERJ_METADATA_LOGGER);
        this.registerLogger(CLUSTERJ_QUERY_LOGGER);
        this.registerLogger(CLUSTERJ_UTIL_LOGGER);
    }

    @Override
    public Logger registerLogger(String loggerName) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(loggerName);
        JDK14LoggerImpl result = new JDK14LoggerImpl(logger);
        loggerMap.put(loggerName, result);
        return result;
    }

    public Logger getInstance(Class cls) {
        String loggerName = JDK14LoggerFactoryImpl.getPackageName(cls);
        return this.getInstance(loggerName);
    }

    @Override
    public synchronized Logger getInstance(String loggerName) {
        Logger result = loggerMap.get(loggerName);
        if (result == null) {
            result = this.registerLogger(loggerName);
        }
        return result;
    }

    private static final String getPackageName(Class<?> cls) {
        String className = cls.getName();
        int index = className.lastIndexOf(46);
        return index != -1 ? className.substring(0, index) : "";
    }
}

