/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.query.BetweenPredicateImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.QueryDomainType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryExecutionContextImpl
implements QueryExecutionContext {
    static final I18NHelper local = I18NHelper.getInstance(BetweenPredicateImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(BetweenPredicateImpl.class);
    protected Map<String, Object> boundParameters = new HashMap<String, Object>();
    protected SessionSPI session;
    private List<ScanFilter> filters = new ArrayList<ScanFilter>();
    protected Map<String, Object> explain = null;

    public QueryExecutionContextImpl(SessionSPI sessionSPI) {
        if (sessionSPI == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Session_Must_Not_Be_Null"));
        }
        this.session = sessionSPI;
    }

    protected QueryExecutionContextImpl(QueryExecutionContextImpl queryExecutionContextImpl) {
        this.session = queryExecutionContextImpl.getSession();
        this.explain = queryExecutionContextImpl.getExplain();
        this.boundParameters = new HashMap<String, Object>(queryExecutionContextImpl.boundParameters);
    }

    public QueryExecutionContextImpl(SessionSPI sessionSPI, Map<String, Object> map) {
        this.session = sessionSPI;
        this.boundParameters = map;
    }

    public void bindParameterValue(String string, Object object) {
        if (string == null) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Null"));
        }
        this.boundParameters.put(string, object);
        this.explain = null;
    }

    @Override
    public Object getParameterValue(String string) {
        if (!this.isBound(string)) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Not_Bound", (Object)string));
        }
        return this.boundParameters.get(string);
    }

    @Override
    public boolean isBound(String string) {
        return this.boundParameters.containsKey(string);
    }

    @Override
    public SessionSPI getSession() {
        return this.session;
    }

    public ResultData getResultData(QueryDomainType<?> queryDomainType) {
        return ((QueryDomainTypeImpl)queryDomainType).getResultData(this, 0L, Long.MAX_VALUE, null, null);
    }

    @Override
    public void addFilter(ScanFilter scanFilter) {
        this.filters.add(scanFilter);
    }

    @Override
    public void deleteFilters() {
        for (ScanFilter scanFilter : this.filters) {
            scanFilter.delete();
        }
        this.filters.clear();
    }

    @Override
    public void setExplain(Map<String, Object> map) {
        this.explain = map;
    }

    public Map<String, Object> getExplain() {
        return this.explain;
    }

    @Override
    public Byte getByte(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "Byte"));
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "BigDecimal"));
    }

    @Override
    public BigInteger getBigInteger(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "BigInteger"));
    }

    @Override
    public Boolean getBoolean(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "Boolean"));
    }

    @Override
    public byte[] getBytes(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "byte[]"));
    }

    @Override
    public Double getDouble(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "Double"));
    }

    @Override
    public Float getFloat(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "Float"));
    }

    @Override
    public Integer getInt(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "Integer"));
    }

    @Override
    public Date getJavaSqlDate(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "java.sql.Date"));
    }

    @Override
    public Time getJavaSqlTime(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "java.sql.Time"));
    }

    @Override
    public Timestamp getJavaSqlTimestamp(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "java.sql.Timestamp"));
    }

    @Override
    public java.util.Date getJavaUtilDate(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return (java.util.Date)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "java.util.Date"));
    }

    @Override
    public Long getLong(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "Long"));
    }

    @Override
    public Short getShort(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "Short"));
    }

    @Override
    public String getString(String string) {
        Object object = this.boundParameters.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", string, object.getClass(), "String"));
    }

    @Override
    public Object getObject(String string) {
        return this.boundParameters.get(string);
    }

    @Override
    public boolean hasNoNullParameters() {
        for (Object object : this.boundParameters.values()) {
            if (object != null) continue;
            return false;
        }
        return true;
    }
}

