/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.BlobImpl;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.ResultDataImpl;
import com.mysql.clusterj.tie.TableImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class OperationImpl
implements Operation {
    static final I18NHelper local = I18NHelper.getInstance(OperationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(OperationImpl.class);
    private NdbOperation ndbOperation;
    protected List<Column> storeColumns = new ArrayList<Column>();
    protected ClusterTransactionImpl clusterTransaction;
    protected int bufferSize;
    protected int maximumColumnId;
    protected int[] offsets;
    protected int[] lengths;
    protected int maximumColumnLength;
    protected DbImpl.BufferManager bufferManager;

    public OperationImpl(NdbOperation ndbOperation, ClusterTransactionImpl clusterTransactionImpl) {
        this.ndbOperation = ndbOperation;
        this.clusterTransaction = clusterTransactionImpl;
        this.bufferManager = this.clusterTransaction.getBufferManager();
    }

    public OperationImpl(Table table, NdbOperation ndbOperation, ClusterTransactionImpl clusterTransactionImpl) {
        this(ndbOperation, clusterTransactionImpl);
        TableImpl tableImpl = (TableImpl)table;
        this.maximumColumnId = tableImpl.getMaximumColumnId();
        this.bufferSize = tableImpl.getBufferSize();
        this.offsets = tableImpl.getOffsets();
        this.lengths = tableImpl.getLengths();
        this.maximumColumnLength = tableImpl.getMaximumColumnLength();
    }

    @Override
    public void equalBigInteger(Column column, BigInteger bigInteger) {
        ByteBuffer byteBuffer = Utility.convertValue(column, bigInteger);
        int n = this.ndbOperation.equal(column.getName(), byteBuffer);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void equalBoolean(Column column, boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = this.ndbOperation.equal(column.getName(), n);
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public void equalByte(Column column, byte by) {
        int n = Utility.convertByteValueForStorage(column, by);
        int n2 = this.ndbOperation.equal(column.getName(), n);
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public void equalBytes(Column column, byte[] byArray) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + column.getName() + " columnId: " + column.getColumnId() + " data length: " + byArray.length);
        }
        ByteBuffer byteBuffer = Utility.convertValue(column, byArray);
        int n = this.ndbOperation.equal(column.getName(), byteBuffer);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void equalDecimal(Column column, BigDecimal bigDecimal) {
        ByteBuffer byteBuffer = Utility.convertValue(column, bigDecimal);
        int n = this.ndbOperation.equal(column.getName(), byteBuffer);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void equalDouble(Column column, double d) {
        ByteBuffer byteBuffer = Utility.convertValue(column, d);
        int n = this.ndbOperation.equal(column.getName(), byteBuffer);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void equalFloat(Column column, float f) {
        ByteBuffer byteBuffer = Utility.convertValue(column, f);
        int n = this.ndbOperation.equal(column.getName(), byteBuffer);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void equalInt(Column column, int n) {
        int n2 = this.ndbOperation.equal(column.getName(), n);
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public void equalShort(Column column, short s) {
        int n = Utility.convertShortValueForStorage(column, s);
        int n2 = this.ndbOperation.equal(column.getName(), n);
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public void equalLong(Column column, long l) {
        long l2 = Utility.convertLongValueForStorage(column, l);
        int n = this.ndbOperation.equal(column.getName(), l2);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void equalString(Column column, String string) {
        ByteBuffer byteBuffer = Utility.encode(string, column, this.bufferManager);
        int n = this.ndbOperation.equal(column.getName(), byteBuffer);
        this.bufferManager.clearStringStorageBuffer();
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void getBlob(Column column) {
        NdbBlob ndbBlob = this.ndbOperation.getBlobHandleM(column.getColumnId());
        OperationImpl.handleError(ndbBlob, this.ndbOperation);
    }

    @Override
    public Blob getBlobHandle(Column column) {
        NdbBlob ndbBlob = this.ndbOperation.getBlobHandleM(column.getColumnId());
        OperationImpl.handleError(ndbBlob, this.ndbOperation);
        return new BlobImpl(ndbBlob);
    }

    @Override
    public void getValue(Column column) {
        this.storeColumns.add(column);
    }

    @Override
    public void postExecuteCallback(Runnable runnable) {
        this.clusterTransaction.postExecuteCallback(runnable);
    }

    @Override
    public ResultData resultData() {
        return this.resultData(true);
    }

    @Override
    public ResultData resultData(boolean bl) {
        ResultDataImpl resultDataImpl;
        if (logger.isDetailEnabled()) {
            logger.detail("storeColumns: " + Arrays.toString(this.storeColumns.toArray()));
        }
        if (bl) {
            resultDataImpl = new ResultDataImpl(this.ndbOperation, this.storeColumns, this.maximumColumnId, this.bufferSize, this.offsets, this.lengths, this.bufferManager, false);
            this.clusterTransaction.executeNoCommit(false, true);
        } else {
            resultDataImpl = new ResultDataImpl(this.ndbOperation, this.storeColumns, this.maximumColumnId, this.bufferSize, this.offsets, this.lengths, this.bufferManager, true);
        }
        return resultDataImpl;
    }

    @Override
    public void setBigInteger(Column column, BigInteger bigInteger) {
        ByteBuffer byteBuffer = Utility.convertValue(column, bigInteger);
        int n = this.ndbOperation.setValue(column.getColumnId(), byteBuffer);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void setBoolean(Column column, Boolean bl) {
        byte by = bl != false ? (byte)1 : 0;
        this.setByte(column, by);
    }

    @Override
    public void setByte(Column column, byte by) {
        int n = Utility.convertByteValueForStorage(column, by);
        int n2 = this.ndbOperation.setValue(column.getColumnId(), n);
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public void setBytes(Column column, byte[] byArray) {
        int n = byArray.length;
        if (n > column.getLength()) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", column.getName(), column.getLength(), n));
        }
        ByteBuffer byteBuffer = Utility.convertValue(column, byArray);
        int n2 = this.ndbOperation.setValue(column.getColumnId(), byteBuffer);
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public void setDecimal(Column column, BigDecimal bigDecimal) {
        ByteBuffer byteBuffer = Utility.convertValue(column, bigDecimal);
        int n = this.ndbOperation.setValue(column.getColumnId(), byteBuffer);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void setDouble(Column column, Double d) {
        int n = this.ndbOperation.setValue(column.getColumnId(), (double)d);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void setFloat(Column column, Float f) {
        int n = this.ndbOperation.setValue(column.getColumnId(), f.floatValue());
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void setInt(Column column, Integer n) {
        int n2 = this.ndbOperation.setValue(column.getColumnId(), (int)n);
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public void setLong(Column column, long l) {
        long l2 = Utility.convertLongValueForStorage(column, l);
        int n = this.ndbOperation.setValue(column.getColumnId(), l2);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void setNull(Column column) {
        int n = this.ndbOperation.setValue(column.getColumnId(), null);
        this.handleError(n, this.ndbOperation);
    }

    @Override
    public void setShort(Column column, Short s) {
        int n = Utility.convertShortValueForStorage(column, s);
        int n2 = this.ndbOperation.setValue(column.getName(), n);
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public void setString(Column column, String string) {
        ByteBuffer byteBuffer = Utility.encode(string, column, this.bufferManager);
        int n = byteBuffer.remaining() - column.getPrefixLength();
        if (n > column.getLength()) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", column.getName(), column.getLength(), n));
        }
        int n2 = this.ndbOperation.setValue(column.getColumnId(), byteBuffer);
        this.bufferManager.clearStringStorageBuffer();
        this.handleError(n2, this.ndbOperation);
    }

    @Override
    public int errorCode() {
        return this.ndbOperation.getNdbError().code();
    }

    protected void handleError(int n, NdbOperation ndbOperation) {
        if (n == 0) {
            return;
        }
        Utility.throwError(n, ndbOperation.getNdbError());
    }

    protected static void handleError(Object object, NdbOperation ndbOperation) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbOperation.getNdbError());
    }

    @Override
    public void beginDefinition() {
    }

    @Override
    public void endDefinition() {
    }

    @Override
    public int getErrorCode() {
        return this.ndbOperation.getNdbError().code();
    }

    @Override
    public int getClassification() {
        return this.ndbOperation.getNdbError().classification();
    }

    @Override
    public int getMysqlCode() {
        return this.ndbOperation.getNdbError().mysql_code();
    }

    @Override
    public int getStatus() {
        return this.ndbOperation.getNdbError().status();
    }

    @Override
    public void freeResourcesAfterExecute() {
    }
}

