/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.IdBase;
import testsuite.clusterj.model.StringTypes;

public class QueryLikeTest
extends AbstractQueryTest {
    static String[] strings = new String[]{"Alabama", "Arkansas", "Delaware", "New Jersey", "New York", "Pennsylvania", "Rhode Island", "Texax", "Virginia", "Wyoming"};

    @Override
    public Class<?> getInstanceType() {
        return StringTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllStringTypesInstances(n);
    }

    public void test() {
        this.btreeIndexScanString();
        this.hashIndexScanString();
        this.bothIndexScanString();
        this.noneIndexScanString();
        this.failOnError();
    }

    public void btreeIndexScanString() {
        this.likeQuery("string_not_null_btree", "none", "%", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.likeQuery("string_not_null_btree", "none", "_", new int[0]);
        this.likeQuery("string_not_null_btree", "none", "_____", 7);
        this.likeQuery("string_not_null_btree", "none", "%York", 4);
        this.likeQuery("string_not_null_btree", "none", "New York", 4);
        this.likeQuery("string_not_null_btree", "none", "New Yor_", 4);
        this.likeQuery("string_not_null_btree", "none", "New%", 3, 4);
        this.greaterEqualAndLikeQuery("string_not_null_btree", "idx_string_not_null_btree", this.getString(4), "%", 4, 5, 6, 7, 8, 9);
        this.greaterEqualAndLikeQuery("string_not_null_btree", "idx_string_not_null_btree", this.getString(4), "%enns%", 5);
        this.greaterThanAndLikeQuery("string_not_null_btree", "idx_string_not_null_btree", this.getString(4), "%e%", 5, 6, 7);
    }

    public void hashIndexScanString() {
        this.greaterEqualAndLikeQuery("string_not_null_hash", "none", this.getString(4), "%enns%", 5);
        this.greaterThanAndLikeQuery("string_not_null_hash", "none", this.getString(4), "%e%", 5, 6, 7);
    }

    public void bothIndexScanString() {
        this.greaterEqualAndLikeQuery("string_not_null_both", "idx_string_not_null_both", this.getString(4), "%enns%", 5);
        this.greaterThanAndLikeQuery("string_not_null_both", "idx_string_not_null_both", this.getString(4), "%e%", 5, 6, 7);
    }

    public void noneIndexScanString() {
        this.greaterEqualAndLikeQuery("string_not_null_none", "none", this.getString(4), "%enns%", 5);
        this.greaterThanAndLikeQuery("string_not_null_none", "none", this.getString(4), "%e%", 5, 6, 7);
    }

    private void createAllStringTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            StringTypes stringTypes = (StringTypes)this.session.newInstance(StringTypes.class);
            stringTypes.setId(i);
            stringTypes.setString_not_null_hash(this.getString(i));
            stringTypes.setString_not_null_btree(this.getString(i));
            stringTypes.setString_not_null_both(this.getString(i));
            stringTypes.setString_not_null_none(this.getString(i));
            stringTypes.setString_null_hash(this.getString(i));
            stringTypes.setString_null_btree(this.getString(i));
            stringTypes.setString_null_both(this.getString(i));
            stringTypes.setString_null_none(this.getString(i));
            this.instances.add(stringTypes);
        }
    }

    protected String getString(int n) {
        return strings[n];
    }

    @Override
    protected void printResultInstance(IdBase idBase) {
        if (idBase instanceof StringTypes) {
            StringTypes stringTypes = (StringTypes)idBase;
        }
    }

    public static String toString(IdBase idBase) {
        StringTypes stringTypes = (StringTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("StringTypes id: ");
        stringBuffer.append(stringTypes.getId());
        stringBuffer.append("; string_not_null_both: ");
        stringBuffer.append(stringTypes.getString_not_null_both());
        stringBuffer.append("; string_not_null_btree: ");
        stringBuffer.append(stringTypes.getString_not_null_btree());
        stringBuffer.append("; string_not_null_hash: ");
        stringBuffer.append(stringTypes.getString_not_null_hash());
        stringBuffer.append("; string_not_null_none: ");
        stringBuffer.append(stringTypes.getString_not_null_none());
        stringBuffer.append("; string_null_both: ");
        stringBuffer.append(stringTypes.getString_null_both().toString());
        stringBuffer.append("; string_null_btree: ");
        stringBuffer.append(stringTypes.getString_null_btree().toString());
        stringBuffer.append("; string_null_hash: ");
        stringBuffer.append(stringTypes.getString_null_hash().toString());
        stringBuffer.append("; string_null_none: ");
        stringBuffer.append(stringTypes.getString_null_none().toString());
        return stringBuffer.toString();
    }
}

