/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import java.nio.ByteBuffer;

class BlobImpl
implements Blob {
    static final I18NHelper local = I18NHelper.getInstance(BlobImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(BlobImpl.class);
    protected NdbBlob ndbBlob;

    public BlobImpl() {
    }

    public BlobImpl(NdbBlob ndbBlob) {
        this.ndbBlob = ndbBlob;
    }

    @Override
    public Long getLength() {
        long[] lArray = new long[1];
        int n = this.ndbBlob.getLength(lArray);
        BlobImpl.handleError(n, this.ndbBlob);
        return lArray[0];
    }

    @Override
    public void readData(byte[] byArray, int n) {
        int[] nArray = new int[]{n};
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        int n2 = this.ndbBlob.readData(byteBuffer, nArray);
        BlobImpl.handleError(n2, this.ndbBlob);
        if (nArray[0] != n) {
            throw new ClusterJFatalInternalException(local.message("ERR_Blob_Read_Data", (Object)n, (Object)nArray[0]));
        }
        byteBuffer.get(byArray);
    }

    @Override
    public void writeData(byte[] byArray) {
        if (byArray == null) {
            this.setNull();
            return;
        }
        if (byArray.length == 0) {
            return;
        }
        ByteBuffer byteBuffer = null;
        if (byArray.length > 0) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.flip();
        }
        int n = this.ndbBlob.writeData(byteBuffer, byArray.length);
        BlobImpl.handleError(n, this.ndbBlob);
    }

    @Override
    public void setValue(byte[] byArray) {
        if (byArray == null) {
            this.setNull();
            return;
        }
        if (byArray.length == 0) {
            return;
        }
        ByteBuffer byteBuffer = null;
        if (byArray.length > 0) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.flip();
        }
        int n = this.ndbBlob.setValue(byteBuffer, byArray.length);
        BlobImpl.handleError(n, this.ndbBlob);
    }

    @Override
    public void setNull() {
        int n = this.ndbBlob.setNull();
        BlobImpl.handleError(n, this.ndbBlob);
    }

    @Override
    public void close() {
        int n = this.ndbBlob.close(true);
        BlobImpl.handleError(n, this.ndbBlob);
    }

    protected static void handleError(int n, NdbBlob ndbBlob) {
        if (n == 0) {
            return;
        }
        Utility.throwError(n, ndbBlob.getNdbError());
    }
}

