/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.AbstractJPABaseTest;
import com.mysql.clusterj.jpatest.model.ClobTypes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClobTest
extends AbstractJPABaseTest {
    private static final int NUMBER_TO_INSERT = 16;
    protected List<ClobTypes> clobs = new ArrayList<ClobTypes>();
    private char[] chars = this.getChars(Charset.forName("latin1"));

    @Override
    protected boolean getDebug() {
        return false;
    }

    private char[] getChars(Charset charset) {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        char[] cArray = new char[128];
        char c = '\u0000';
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c = this.nextChar(charsetEncoder, c);
        }
        return cArray;
    }

    char nextChar(CharsetEncoder charsetEncoder, char c) {
        if (charsetEncoder.canEncode(c = (char)(c + '\u0001'))) {
            return c;
        }
        return this.nextChar(charsetEncoder, c);
    }

    public void test() {
        this.createClobInstances(16);
        this.remove();
        this.insert();
        this.update();
        this.failOnError();
    }

    protected void remove() {
        this.removeAll(ClobTypes.class);
    }

    protected void insert() {
        this.tx = this.em.getTransaction();
        this.tx.begin();
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            this.em.persist((Object)this.clobs.get(i));
            ++n;
        }
        this.tx.commit();
    }

    protected void update() {
        String string;
        int n;
        ClobTypes clobTypes;
        int n2;
        this.tx.begin();
        for (n2 = 1; n2 < 16; ++n2) {
            clobTypes = (ClobTypes)this.em.find(ClobTypes.class, (Object)n2);
            n = clobTypes.getId();
            if (n != n2) {
                this.error("Expected ClobTypes.id " + n2 + " but got " + n);
            }
            string = clobTypes.getLarge10000();
            this.checkString("before update", string, n2, false);
            int n3 = this.getClobSizeFor(n2) / 2;
            if (string.length() == n3 * 2) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.replace(n3, n3 + 1, "!");
                string = stringBuilder.toString();
                this.checkString("after update", string, n2, true);
            }
            clobTypes.setLarge10000(string);
        }
        this.tx.commit();
        this.tx.begin();
        for (n2 = 1; n2 < 16; ++n2) {
            clobTypes = (ClobTypes)this.em.find(ClobTypes.class, (Object)n2);
            n = clobTypes.getId();
            if (n != n2) {
                this.error("Expected ClobTypes.id " + n2 + " but got " + n);
            }
            string = clobTypes.getLarge10000();
            this.checkString("after commit", string, n2, true);
        }
        this.tx.commit();
    }

    protected void createClobInstances(int n) {
        for (int i = 0; i < n; ++i) {
            ClobTypes clobTypes = new ClobTypes();
            clobTypes.setId(i);
            int n2 = this.getClobSizeFor(i);
            clobTypes.setLarge10000(this.getString(n2));
            this.clobs.add(clobTypes);
        }
    }

    protected String getString(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.chars[i % 128];
        }
        return new String(cArray);
    }

    protected void checkString(String string, String string2, int n, boolean bl) {
        int n2;
        int n3;
        if (this.getDebug()) {
            this.dumpClob(string, string2);
        }
        if ((n3 = this.getClobSizeFor(n)) != (n2 = string2.length())) {
            this.error("In " + string + " wrong size of string; " + "expected: " + n3 + " actual: " + n2);
        }
        for (int i = 0; i < n2; ++i) {
            char c;
            int n4 = n3 / 2;
            char c2 = bl && i == n4 ? (char)'!' : this.chars[i % 128];
            if (c2 == (c = string2.charAt(i))) continue;
            this.error("In " + string + " for size: " + n2 + " mismatch in string at position " + i + " expected: " + c2 + " actual: " + c);
        }
    }

    protected InputStream getClobStream(final int n) {
        return new InputStream(){
            int size;
            int counter;
            {
                this.size = n;
                this.counter = 0;
            }

            @Override
            public int read() throws IOException {
                if (this.counter >= n) {
                    return -1;
                }
                return this.counter++ % 256;
            }
        };
    }

    protected void dumpClob(String string, String string2) {
        System.out.println("In " + string + " dumpClob of size: " + string2.length() + " " + Arrays.toString(string2.getBytes()));
    }

    protected int getClobSizeFor(int n) {
        int n2 = (int)Math.pow(2.0, n);
        return n2;
    }
}

