/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.NdbRecordBlobImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.NdbRecordScanResultDataImpl;
import com.mysql.clusterj.tie.ScanFilterImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbInterpretedCode;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;

public abstract class NdbRecordScanOperationImpl
extends NdbRecordOperationImpl
implements ScanOperation {
    NdbScanOperation.ScanOptions scanOptions = null;
    NdbScanFilter ndbScanFilter = null;
    NdbInterpretedCode ndbInterpretedCode = null;
    protected boolean multiRange = false;
    int lockMode;
    Query.Ordering ordering = null;

    public NdbRecordScanOperationImpl(ClusterTransactionImpl clusterTransactionImpl, Table table, int n) {
        super(clusterTransactionImpl, table);
        this.ndbRecordKeys = clusterTransactionImpl.getCachedNdbRecordImpl(table);
        this.keyBufferSize = this.ndbRecordKeys.getBufferSize();
        this.ndbRecordValues = clusterTransactionImpl.getCachedNdbRecordImpl(table);
        this.valueBufferSize = this.ndbRecordValues.getBufferSize();
        this.numberOfColumns = this.ndbRecordValues.getNumberOfColumns();
        this.blobs = new NdbRecordBlobImpl[this.numberOfColumns];
        this.lockMode = n;
        this.resetMask();
    }

    @Override
    public ResultData resultData(boolean bl) {
        return this.resultData(bl, 0L, Long.MAX_VALUE);
    }

    @Override
    public ResultData resultData(boolean bl, long l, long l2) {
        NdbRecordScanResultDataImpl ndbRecordScanResultDataImpl = new NdbRecordScanResultDataImpl(this.clusterTransaction, this, l, l2);
        if (bl) {
            this.clusterTransaction.executeNoCommit(false, true);
        }
        return ndbRecordScanResultDataImpl;
    }

    @Override
    public String toString() {
        return " scan " + this.tableName;
    }

    @Override
    public void close() {
        ((NdbScanOperation)this.ndbOperation).close(true, true);
    }

    @Override
    public void freeResourcesAfterExecute() {
        super.freeResourcesAfterExecute();
        if (this.ndbInterpretedCode != null) {
            this.db.delete(this.ndbInterpretedCode);
        }
        if (this.ndbScanFilter != null) {
            this.db.delete(this.ndbScanFilter);
        }
        if (this.scanOptions != null) {
            this.db.delete(this.scanOptions);
        }
    }

    @Override
    public void deleteCurrentTuple() {
        int n = ((NdbScanOperation)this.ndbOperation).deleteCurrentTuple();
        NdbRecordScanOperationImpl.handleError(n, this.ndbOperation);
    }

    protected void getScanOptions() {
        long l = 0L;
        int n = 0;
        if (this.ordering != null || this.multiRange || this.lockMode != 2 || this.ndbScanFilter != null) {
            this.scanOptions = this.db.createScanOptions();
            if (this.ordering != null) {
                l |= 1L;
                switch (this.ordering) {
                    case ASCENDING: {
                        n |= 0x1000000;
                        break;
                    }
                    case DESCENDING: {
                        n |= 0x2000000;
                        n |= 0x1000000;
                        break;
                    }
                    default: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Ordering", (Object)this.ordering));
                    }
                }
            }
            if (this.multiRange) {
                l |= 1L;
                n |= 0x8000000;
                n |= 0x4000000;
            }
            if (this.lockMode != 2) {
                l |= 1L;
                n |= 1;
            }
            if (this.ndbScanFilter != null) {
                l |= 0x20L;
                this.scanOptions.interpretedCode(this.ndbScanFilter.getInterpretedCode());
            }
            if (n != 0) {
                this.scanOptions.scan_flags(n);
            }
            this.scanOptions.optionsPresent(l);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ScanOptions: " + this.dumpScanOptions(l, n));
        }
    }

    protected String dumpScanOptions(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (0L != (l & 4L)) {
            stringBuilder.append("SO_BATCH ");
        }
        if (0L != (l & 8L)) {
            stringBuilder.append("SO_GETVALUE ");
        }
        if (0L != (l & 2L)) {
            stringBuilder.append("SO_PARALLEL ");
        }
        if (0L != (l & 0x40L)) {
            stringBuilder.append("SO_CUSTOMDATA ");
        }
        if (0L != (l & 0x20L)) {
            stringBuilder.append("SO_INTERPRETED ");
        }
        if (0L != (l & 0x10L)) {
            stringBuilder.append("SO_PARTITION_ID ");
        }
        if (0L != (l & 1L)) {
            stringBuilder.append("SO_SCANFLAGS(");
            if (0 != (n & 1)) {
                stringBuilder.append("SF_KeyInfo ");
            }
            if (0 != (n & 0x2000000)) {
                stringBuilder.append("SF_Descending ");
            }
            if (0 != (n & 0x20000)) {
                stringBuilder.append("SF_DiskScan ");
            }
            if (0 != (n & 0x8000000)) {
                stringBuilder.append("SF_MultiRange ");
            }
            if (0 != (n & 0x1000000)) {
                stringBuilder.append("SF_OrderBy ");
            }
            if (0 != (n & 0x4000000)) {
                stringBuilder.append("SF_ReadRangeNo ");
            }
            if (0 != (n & 0x10000)) {
                stringBuilder.append("SF_TupScan ");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public ScanFilter getScanFilter(QueryExecutionContext queryExecutionContext) {
        this.ndbInterpretedCode = this.db.createInterpretedCode(this.ndbRecordValues.getNdbTable(), 0);
        NdbRecordScanOperationImpl.handleError((Object)this.ndbInterpretedCode, this.ndbOperation);
        this.ndbScanFilter = this.db.createScanFilter(this.ndbInterpretedCode);
        NdbRecordScanOperationImpl.handleError((Object)this.ndbScanFilter, this.ndbOperation);
        ScanFilterImpl scanFilterImpl = new ScanFilterImpl(this.ndbScanFilter);
        queryExecutionContext.addFilter(scanFilterImpl);
        return scanFilterImpl;
    }

    @Override
    public int nextResult(boolean bl) {
        int n = ((NdbScanOperation)this.ndbOperation).nextResult(bl, false);
        this.clusterTransaction.handleError(n);
        return n;
    }

    public int nextResultCopyOut(boolean bl, boolean bl2) {
        this.allocateValueBuffer();
        int n = ((NdbScanOperation)this.ndbOperation).nextResultCopyOut(this.valueBuffer, bl, bl2);
        return n;
    }

    public NdbOperationConst lockCurrentTuple() {
        NdbOperationConst ndbOperationConst = null;
        if (this.lockMode != 2 && (ndbOperationConst = ((NdbScanOperation)this.ndbOperation).lockCurrentTuple(this.clusterTransaction.ndbTransaction, this.ndbRecordValues.getNdbRecord(), null, null, null, 0)) == null) {
            Utility.throwError(ndbOperationConst, this.ndbOperation.getNdbError());
        }
        return ndbOperationConst;
    }

    @Override
    public NdbRecordOperationImpl transformNdbRecordOperationImpl() {
        NdbRecordOperationImpl ndbRecordOperationImpl = new NdbRecordOperationImpl(this);
        this.keyBuffer = this.valueBuffer = this.ndbRecordValues.newBuffer();
        return ndbRecordOperationImpl;
    }

    @Override
    public void setOrdering(Query.Ordering ordering) {
        this.ordering = ordering;
    }
}

