/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.AbstractJPABaseTest;
import com.mysql.clusterj.jpatest.model.BlobTypes;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class BlobTest
extends AbstractJPABaseTest {
    private static final int NUMBER_TO_INSERT = 16;
    protected List<BlobTypes> blobs = new ArrayList<BlobTypes>();

    @Override
    protected boolean getDebug() {
        return false;
    }

    public void test() {
        this.createBlobInstances(16);
        this.remove();
        this.insert();
        this.update();
        this.failOnError();
    }

    protected void remove() {
        this.removeAll(BlobTypes.class);
    }

    protected void insert() {
        this.tx = this.em.getTransaction();
        this.tx.begin();
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            this.em.persist((Object)this.blobs.get(i));
            ++n;
        }
        this.tx.commit();
    }

    protected void update() {
        byte[] byArray;
        int n;
        BlobTypes blobTypes;
        int n2;
        this.tx.begin();
        for (n2 = 1; n2 < 16; ++n2) {
            blobTypes = (BlobTypes)this.em.find(BlobTypes.class, (Object)n2);
            n = blobTypes.getId();
            if (n != n2) {
                this.error("Expected BlobTypes.id " + n2 + " but got " + n);
            }
            byArray = blobTypes.getBlobbytes();
            this.checkBlobbytes("before update", byArray, n2, false);
            int n3 = this.getBlobSizeFor(n2) / 2;
            if (byArray.length != n3 * 2) continue;
            byArray[n3] = (byte)(n3 % 128);
            this.checkBlobbytes("after update", byArray, n2, true);
        }
        this.tx.commit();
        this.tx.begin();
        for (n2 = 1; n2 < 16; ++n2) {
            blobTypes = (BlobTypes)this.em.find(BlobTypes.class, (Object)n2);
            n = blobTypes.getId();
            if (n != n2) {
                this.error("Expected BlobTypes.id " + n2 + " but got " + n);
            }
            byArray = blobTypes.getBlobbytes();
            this.checkBlobbytes("after commit", byArray, n2, true);
        }
        this.tx.commit();
    }

    protected void createBlobInstances(int n) {
        for (int i = 0; i < n; ++i) {
            BlobTypes blobTypes = new BlobTypes();
            blobTypes.setId(i);
            int n2 = this.getBlobSizeFor(i);
            blobTypes.setBlobbytes(this.getBlobbytes(n2));
            this.blobs.add(blobTypes);
        }
    }

    protected byte[] getBlobbytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(i % 256 - 128);
        }
        return byArray;
    }

    protected void checkBlobbytes(String string, byte[] byArray, int n, boolean bl) {
        int n2;
        int n3;
        if (this.getDebug()) {
            this.dumpBlob(string, byArray);
        }
        if ((n3 = this.getBlobSizeFor(n)) != (n2 = byArray.length)) {
            this.error("In " + string + " wrong size of byte[]; " + "expected: " + n3 + " actual: " + n2);
        }
        for (int i = 0; i < n2; ++i) {
            byte by;
            int n4 = n3 / 2;
            byte by2 = bl && i == n4 ? (byte)(n4 % 128) : (byte)(i % 256 - 128);
            if (by2 == (by = byArray[i])) continue;
            this.error("In " + string + " for size: " + n2 + " mismatch in byte[] at position " + i + " expected: " + by2 + " actual: " + by);
        }
    }

    protected InputStream getBlobStream(final int n) {
        return new InputStream(){
            int size;
            int counter;
            {
                this.size = n;
                this.counter = 0;
            }

            @Override
            public int read() throws IOException {
                if (this.counter >= n) {
                    return -1;
                }
                return this.counter++ % 256;
            }
        };
    }

    protected void dumpBlob(String string, byte[] byArray) {
        System.out.println("In " + string + " dumpBlob of size: " + byArray.length);
        for (byte by : byArray) {
            System.out.print("[" + by + "]");
        }
        System.out.println();
    }

    protected int getBlobSizeFor(int n) {
        int n2 = (int)Math.pow(2.0, n);
        return n2;
    }
}

