/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.AbstractJPABaseTest;
import com.mysql.clusterj.jpatest.model.ShortPK;
import java.util.ArrayList;
import java.util.List;

public class ShortPKTest
extends AbstractJPABaseTest {
    protected short NUMBER_TO_INSERT = (short)10;
    protected List<ShortPK> instances = new ArrayList<ShortPK>();

    @Override
    protected boolean getDebug() {
        return false;
    }

    public void test() {
        this.createInstances(this.NUMBER_TO_INSERT);
        this.remove();
        this.insert();
        this.update();
        this.failOnError();
    }

    protected void remove() {
        this.removeAll(ShortPK.class);
    }

    protected void insert() {
        this.tx = this.em.getTransaction();
        this.tx.begin();
        int n = 0;
        for (short s = 0; s < this.NUMBER_TO_INSERT; s = (short)(s + 1)) {
            this.em.persist((Object)this.instances.get(s));
            ++n;
        }
        this.tx.commit();
    }

    protected void update() {
        short s;
        ShortPK shortPK;
        short s2;
        this.tx.begin();
        for (s2 = 0; s2 < 10; s2 = (short)(s2 + 1)) {
            shortPK = (ShortPK)this.em.find(ShortPK.class, (Object)s2);
            s = shortPK.getId();
            if (s != s2) {
                this.error("Expected ShortPK.id " + s2 + " but got " + s);
            }
            shortPK.setShort_null_none((short)(s2 + 10));
            shortPK.setShort_null_btree((short)(s2 + 10));
            shortPK.setShort_null_hash((short)(s2 + 10));
            shortPK.setShort_null_both((short)(s2 + 10));
        }
        this.tx.commit();
        this.tx.begin();
        for (s2 = 0; s2 < this.NUMBER_TO_INSERT; s2 = (short)(s2 + 1)) {
            shortPK = (ShortPK)this.em.find(ShortPK.class, (Object)s2);
            s = shortPK.getId();
            if (s != s2) {
                this.error("Expected BlobTypes.id " + s2 + " but got " + s);
            }
            this.errorIfNotEqual("Mismatch in short_null_none", (short)(s2 + 10), shortPK.getShort_null_none());
            this.errorIfNotEqual("Mismatch in short_null_btree", (short)(s2 + 10), shortPK.getShort_null_btree());
            this.errorIfNotEqual("Mismatch in short_null_hash", (short)(s2 + 10), shortPK.getShort_null_hash());
            this.errorIfNotEqual("Mismatch in short_null_both", (short)(s2 + 10), shortPK.getShort_null_both());
        }
        this.tx.commit();
    }

    protected void createInstances(int n) {
        for (short s = 0; s < n; s = (short)(s + 1)) {
            ShortPK shortPK = new ShortPK();
            shortPK.setId(s);
            shortPK.setShort_null_none(s);
            shortPK.setShort_null_btree(s);
            shortPK.setShort_null_hash(s);
            shortPK.setShort_null_both(s);
            this.instances.add(shortPK);
        }
    }
}

