/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.AutoPKBigint;
import testsuite.clusterj.model.AutoPKInt;
import testsuite.clusterj.model.AutoPKSmallint;
import testsuite.clusterj.model.AutoPKTinyint;
import testsuite.clusterj.model.BinaryPK;

public class AutoPKTest
extends AbstractClusterJTest {
    protected Helper<Integer> intHelper = new Helper<Integer>(){

        @Override
        public Integer valueOf(int n) {
            return new Integer(n);
        }

        @Override
        public Integer valueOf(Number number) {
            return new Integer(number.intValue());
        }

        @Override
        public Class<Integer> keyType() {
            return Integer.class;
        }
    };
    protected Helper<Long> bigintHelper = new Helper<Long>(){

        @Override
        public Long valueOf(int n) {
            return new Long(n);
        }

        @Override
        public Long valueOf(Number number) {
            return new Long(number.intValue());
        }

        @Override
        public Class<Long> keyType() {
            return Long.class;
        }
    };
    protected Helper<Short> smallintHelper = new Helper<Short>(){

        @Override
        public Short valueOf(int n) {
            return new Short((short)n);
        }

        @Override
        public Short valueOf(Number number) {
            return new Short((short)number.intValue());
        }

        @Override
        public Class<Short> keyType() {
            return Short.class;
        }
    };
    protected Helper<Byte> tinyintHelper = new Helper<Byte>(){

        @Override
        public Byte valueOf(int n) {
            return new Byte((byte)n);
        }

        @Override
        public Byte valueOf(Number number) {
            return new Byte((byte)number.intValue());
        }

        @Override
        public Class<Byte> keyType() {
            return Byte.class;
        }
    };
    protected int NUMBER_OF_INSTANCES = 12;
    protected List<BinaryPK> instances = new ArrayList<BinaryPK>();
    protected Tester<Integer, AutoPKInt> intTester = new Tester<Integer, AutoPKInt>(this.intHelper, AutoPKInt.class);
    protected Tester<Long, AutoPKBigint> bigintTester = new Tester<Long, AutoPKBigint>(this.bigintHelper, AutoPKBigint.class);
    protected Tester<Short, AutoPKSmallint> smallintTester = new Tester<Short, AutoPKSmallint>(this.smallintHelper, AutoPKSmallint.class);
    protected Tester<Byte, AutoPKTinyint> tinyintTester = new Tester<Byte, AutoPKTinyint>(this.tinyintHelper, AutoPKTinyint.class);

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        try {
            this.intTester.deleteAll();
            this.bigintTester.deleteAll();
            this.smallintTester.deleteAll();
            this.tinyintTester.deleteAll();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this.intTester.createAll();
            this.bigintTester.createAll();
            this.smallintTester.createAll();
            this.tinyintTester.createAll();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.addTearDownClasses(AutoPKInt.class, AutoPKBigint.class, AutoPKSmallint.class, AutoPKTinyint.class);
    }

    public void test() {
        this.find();
        this.delete();
        this.failOnError();
    }

    protected void find() {
        this.intTester.findAll();
        this.bigintTester.findAll();
        this.smallintTester.findAll();
        this.tinyintTester.findAll();
    }

    protected void delete() {
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            this.intTester.deleteByKey(n);
            this.bigintTester.deleteByKey(n);
            this.smallintTester.deleteByKey(n);
            this.tinyintTester.deleteByKey(n);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            Object object = null;
            if (0 != n % 5) continue;
            object = this.intTester.findByKey(n);
            if (object != null) {
                this.error("failed to delete AutoPKInt for " + n);
            }
            if ((object = this.bigintTester.findByKey(n)) != null) {
                this.error("failed to delete AutoPKBigint for " + n);
            }
            if ((object = this.smallintTester.findByKey(n)) != null) {
                this.error("failed to delete AutoPKSmallint for " + n);
            }
            if ((object = this.tinyintTester.findByKey(n)) == null) continue;
            this.error("failed to delete AutoPKTinyint for " + n);
        }
    }

    protected class Tester<KeyType extends Number, InstanceType> {
        Helper<KeyType> helper;
        Class<InstanceType> theInstanceType;
        Class<KeyType> theKeyType;
        List<InstanceType> instances = new ArrayList<InstanceType>();
        List<KeyType> ids = new ArrayList<KeyType>();
        Method setVal = null;
        Method getVal = null;
        Method getId = null;

        Tester(Helper<KeyType> helper, Class<InstanceType> clazz) {
            this.helper = helper;
            this.theKeyType = helper.keyType();
            this.theInstanceType = clazz;
            try {
                this.setVal = this.theInstanceType.getMethod("setVal", this.theKeyType);
            }
            catch (Exception exception) {
                AutoPKTest.this.error("Failed to get Method instance for " + this.theInstanceType.getName() + ".setVal.");
            }
            try {
                this.getVal = this.theInstanceType.getMethod("getVal", new Class[0]);
            }
            catch (Exception exception) {
                AutoPKTest.this.error("Failed to get Method instance for " + this.theInstanceType.getName() + ".getVal.");
            }
            try {
                this.getId = this.theInstanceType.getMethod("getId", new Class[0]);
            }
            catch (Exception exception) {
                AutoPKTest.this.error("Failed to get Method instance for " + this.theInstanceType.getName() + ".getId.");
            }
        }

        InstanceType newInstance() {
            return (InstanceType)AutoPKTest.this.session.newInstance(this.theInstanceType);
        }

        void deleteAll() {
            try {
                AutoPKTest.this.session.deletePersistentAll(this.theInstanceType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void deleteByKey(int n) {
            if (this.ids.size() < n + 1) {
                AutoPKTest.this.error("deleteByKey: no instance was created for " + this.theInstanceType.getName() + " for " + n);
            } else {
                try {
                    AutoPKTest.this.session.deletePersistent(this.theInstanceType, this.ids.get(n));
                }
                catch (Exception exception) {
                    AutoPKTest.this.error("deleteByKey: caught " + exception.getMessage() + " for " + this.theInstanceType.getName() + "  " + n);
                }
            }
        }

        void createAll() {
            for (int i = 0; i < AutoPKTest.this.NUMBER_OF_INSTANCES; ++i) {
                InstanceType InstanceType = this.newInstance();
                if (InstanceType == null) {
                    AutoPKTest.this.error("createAll: instance was null for session.newInstance(" + this.theInstanceType.getName() + ".class)  " + i);
                    continue;
                }
                try {
                    this.setVal.invoke(InstanceType, this.helper.valueOf(i));
                }
                catch (Exception exception) {
                    AutoPKTest.this.error("createAll: setVal.invoke caught " + exception.getMessage() + " for " + this.theInstanceType.getName() + "  " + i);
                }
                try {
                    this.instances.add(InstanceType);
                }
                catch (Exception exception) {
                    AutoPKTest.this.error("createAll: instances.add caught " + exception.getMessage() + " for " + this.theInstanceType.getName() + "  " + i);
                }
                try {
                    AutoPKTest.this.session.makePersistent(InstanceType);
                }
                catch (Exception exception) {
                    AutoPKTest.this.error("createAll: caught exception " + exception.getMessage() + " for " + this.theInstanceType.getName() + "  " + i);
                }
                try {
                    Number number = (Number)this.helper.valueOf((Number)this.getId.invoke(InstanceType, new Object[0]));
                    if (this.ids.contains(number)) {
                        AutoPKTest.this.error("createAll: duplicate key for " + this.theInstanceType.getName() + "  " + i);
                        continue;
                    }
                    this.ids.add(number);
                    continue;
                }
                catch (Exception exception) {
                    AutoPKTest.this.error("createAll: getId.invoke caught " + exception.getMessage() + " for " + this.theInstanceType.getName() + "  " + i);
                }
            }
        }

        void findAll() {
            for (int i = 0; i < AutoPKTest.this.NUMBER_OF_INSTANCES; ++i) {
                if (this.ids.size() < i + 1) {
                    AutoPKTest.this.error("findAll: no instance was created for " + this.theInstanceType.getName() + " for " + i);
                    continue;
                }
                Object object = AutoPKTest.this.session.find(this.theInstanceType, this.ids.get(i));
                if (object == null) {
                    AutoPKTest.this.error("findAll: instance is null for session.find(" + this.theInstanceType.getName() + ".class,  " + i + ")");
                    continue;
                }
                try {
                    Object object2 = this.getVal.invoke(object, new Object[0]);
                    Object object3 = this.getId.invoke(object, new Object[0]);
                    AutoPKTest.this.errorIfNotEqual("Error comparing key for " + this.theInstanceType.getName() + " for " + i, this.ids.get(i), object3);
                    AutoPKTest.this.errorIfNotEqual("Error comparing val for " + i, this.helper.valueOf(i), object2);
                    continue;
                }
                catch (Exception exception) {
                    AutoPKTest.this.error("findAll: caught exception " + exception.getMessage() + " for " + this.theInstanceType.getName() + ".");
                }
            }
        }

        InstanceType findByKey(int n) {
            if (this.ids.size() < n + 1) {
                AutoPKTest.this.error("findByKey: no instance was created for " + this.theInstanceType.getName() + " for " + n);
                return null;
            }
            Object object = AutoPKTest.this.session.find(this.theInstanceType, this.ids.get(n));
            return (InstanceType)object;
        }
    }

    protected static interface Helper<KeyType> {
        public KeyType valueOf(int var1);

        public KeyType valueOf(Number var1);

        public Class<KeyType> keyType();
    }
}

