/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Constants;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.core.SessionImpl;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerFactoryImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandlerFactory;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.ClusterConnection;
import com.mysql.clusterj.core.store.ClusterConnectionService;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SessionFactoryImpl
implements SessionFactory,
Constants {
    static final I18NHelper local = I18NHelper.getInstance(SessionFactoryImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(SessionFactoryImpl.class);
    static final ClassLoader SESSION_FACTORY_IMPL_CLASS_LOADER = SessionFactoryImpl.class.getClassLoader();
    protected SessionFactory.State state;
    protected Map<?, ?> props;
    String CLUSTER_CONNECTION_SERVICE;
    String CLUSTER_CONNECT_STRING;
    int CLUSTER_CONNECT_TIMEOUT_MGM;
    int CLUSTER_CONNECT_RETRIES;
    int CLUSTER_CONNECT_DELAY;
    int CLUSTER_CONNECT_VERBOSE;
    int CLUSTER_CONNECT_TIMEOUT_BEFORE;
    int CLUSTER_CONNECT_TIMEOUT_AFTER;
    String CLUSTER_DATABASE;
    int CLUSTER_MAX_TRANSACTIONS;
    int CLUSTER_CONNECT_AUTO_INCREMENT_BATCH_SIZE;
    long CLUSTER_CONNECT_AUTO_INCREMENT_STEP;
    long CLUSTER_CONNECT_AUTO_INCREMENT_START;
    int[] CLUSTER_BYTE_BUFFER_POOL_SIZES;
    int CLUSTER_RECONNECT_TIMEOUT;
    int CLUSTER_RECV_THREAD_ACTIVATION_THRESHOLD;
    List<Integer> nodeIds = new ArrayList<Integer>();
    int connectionPoolSize;
    private static Map<String, Class<?>> proxyInterfacesToDomainClass = new HashMap();
    protected static final Map<Class<?>, DomainTypeHandler<?>> typeToHandlerMap = new HashMap();
    DomainTypeHandlerFactory domainTypeHandlerFactory = new DomainTypeHandlerFactoryImpl();
    protected static final Map<String, SessionFactoryImpl> sessionFactoryMap = new HashMap<String, SessionFactoryImpl>();
    final String key;
    private List<ClusterConnection> pooledConnections = new ArrayList<ClusterConnection>();
    protected ValueHandlerFactory smartValueHandlerFactory;
    short[] recvThreadCPUids;
    protected ThreadGroup threadGroup = new ThreadGroup("Reconnect");
    protected Thread reconnectThread;

    protected ClusterConnectionService getClusterConnectionService() {
        return ClusterJHelper.getServiceInstance(ClusterConnectionService.class, this.CLUSTER_CONNECTION_SERVICE, SESSION_FACTORY_IMPL_CLASS_LOADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionFactoryImpl getSessionFactory(Map<?, ?> map) {
        int n = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connection.pool.size", 1);
        String string = SessionFactoryImpl.getSessionFactoryKey(map);
        SessionFactoryImpl sessionFactoryImpl = null;
        if (n != 0) {
            Map<String, SessionFactoryImpl> map2 = sessionFactoryMap;
            synchronized (map2) {
                sessionFactoryImpl = sessionFactoryMap.get(string);
                if (sessionFactoryImpl == null) {
                    sessionFactoryImpl = new SessionFactoryImpl(map);
                    sessionFactoryMap.put(string, sessionFactoryImpl);
                }
            }
        } else {
            sessionFactoryImpl = new SessionFactoryImpl(map);
        }
        return sessionFactoryImpl;
    }

    private static String getSessionFactoryKey(Map<?, ?> map) {
        String string = SessionFactoryImpl.getRequiredStringProperty(map, "com.mysql.clusterj.connectstring");
        String string2 = SessionFactoryImpl.getStringProperty(map, "com.mysql.clusterj.database", "test");
        return string + "+" + string2;
    }

    protected SessionFactoryImpl(Map<?, ?> map) {
        this.props = map;
        this.key = SessionFactoryImpl.getSessionFactoryKey(map);
        this.connectionPoolSize = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connection.pool.size", 1);
        this.CLUSTER_RECONNECT_TIMEOUT = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connection.reconnect.timeout", 0);
        this.CLUSTER_CONNECT_STRING = SessionFactoryImpl.getRequiredStringProperty(map, "com.mysql.clusterj.connectstring");
        this.CLUSTER_CONNECT_RETRIES = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.retries", 4);
        this.CLUSTER_CONNECT_TIMEOUT_MGM = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.timeout.mgm", 30000);
        this.CLUSTER_CONNECT_DELAY = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.delay", 5);
        this.CLUSTER_CONNECT_VERBOSE = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.verbose", 0);
        this.CLUSTER_CONNECT_TIMEOUT_BEFORE = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.timeout.before", 30);
        this.CLUSTER_CONNECT_TIMEOUT_AFTER = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.timeout.after", 20);
        this.CLUSTER_DATABASE = SessionFactoryImpl.getStringProperty(map, "com.mysql.clusterj.database", "test");
        this.CLUSTER_MAX_TRANSACTIONS = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.max.transactions", 4);
        this.CLUSTER_CONNECT_AUTO_INCREMENT_BATCH_SIZE = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.autoincrement.batchsize", 10);
        this.CLUSTER_CONNECT_AUTO_INCREMENT_STEP = SessionFactoryImpl.getLongProperty(map, "com.mysql.clusterj.connect.autoincrement.increment", 1L);
        this.CLUSTER_CONNECT_AUTO_INCREMENT_START = SessionFactoryImpl.getLongProperty(map, "com.mysql.clusterj.connect.autoincrement.offset", 1L);
        this.CLUSTER_CONNECTION_SERVICE = SessionFactoryImpl.getStringProperty(map, "com.mysql.clusterj.connection.service");
        this.CLUSTER_BYTE_BUFFER_POOL_SIZES = this.getByteBufferPoolSizes(map);
        this.CLUSTER_RECV_THREAD_ACTIVATION_THRESHOLD = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connection.pool.recv.thread.activation.threshold", 8);
        if (this.CLUSTER_RECV_THREAD_ACTIVATION_THRESHOLD < 0) {
            String string = local.message("ERR_Invalid_Activation_Threshold", this.CLUSTER_RECV_THREAD_ACTIVATION_THRESHOLD);
            logger.warn(string);
            throw new ClusterJFatalUserException(string);
        }
        this.createClusterConnectionPool();
        this.verifyConnectionPool();
        this.state = SessionFactory.State.Open;
    }

    protected void createClusterConnectionPool() {
        int n;
        String[] stringArray;
        Object object;
        String string = SessionFactoryImpl.getStringProperty(this.props, "com.mysql.clusterj.connection.pool.nodeids");
        if (string != null) {
            object = string.split("[,; \t\n\r]+", 48);
            stringArray = object;
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                try {
                    int n2 = Integer.parseInt(string2);
                    this.nodeIds.add(n2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = local.message("ERR_Node_Ids_Format", (Object)string);
                    logger.warn(string3);
                    throw new ClusterJFatalUserException(string3, numberFormatException);
                }
            }
            if (this.connectionPoolSize != 1) {
                if (this.nodeIds.size() == 1) {
                    for (int i = 1; i < this.connectionPoolSize; ++i) {
                        this.nodeIds.add(this.nodeIds.get(i - 1) + 1);
                    }
                }
                if (this.connectionPoolSize != this.nodeIds.size()) {
                    String string4 = local.message("ERR_Node_Ids_Must_Match_Connection_Pool_Size", (Object)string, (Object)this.connectionPoolSize);
                    logger.warn(string4);
                    throw new ClusterJFatalUserException(string4);
                }
            } else {
                this.connectionPoolSize = this.nodeIds.size();
            }
        }
        this.recvThreadCPUids = new short[this.connectionPoolSize];
        object = SessionFactoryImpl.getStringProperty(this.props, "com.mysql.clusterj.connection.pool.recv.thread.cpuids");
        if (object != null) {
            stringArray = ((String)object).split("[,; \t\n\r]+", 64);
            if (stringArray.length != this.connectionPoolSize) {
                String string5 = local.message("ERR_CPU_Ids_Must_Match_Connection_Pool_Size", object, (Object)this.connectionPoolSize);
                logger.warn(string5);
                throw new ClusterJFatalUserException(string5);
            }
            n = 0;
            for (String string6 : stringArray) {
                try {
                    this.recvThreadCPUids[n++] = Short.parseShort(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = local.message("ERR_CPU_Ids_Format", object);
                    logger.warn(string7);
                    throw new ClusterJFatalUserException(string7, numberFormatException);
                }
            }
        } else {
            for (int i = 0; i < this.connectionPoolSize; ++i) {
                this.recvThreadCPUids[i] = -1;
            }
        }
        ClusterConnectionService clusterConnectionService = this.getClusterConnectionService();
        if (this.nodeIds.size() == 0) {
            for (n = 0; n < this.connectionPoolSize; ++n) {
                this.createClusterConnection(clusterConnectionService, this.props, 0, n);
            }
        } else {
            for (n = 0; n < this.connectionPoolSize; ++n) {
                this.createClusterConnection(clusterConnectionService, this.props, this.nodeIds.get(n), n);
            }
        }
        if (this.pooledConnections.size() != 0) {
            this.smartValueHandlerFactory = this.pooledConnections.get(0).getSmartValueHandlerFactory();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void verifyConnectionPool() {
        List<Integer> list = null;
        try {
            void object;
            ArrayList<Session> arrayList = new ArrayList<Session>(this.pooledConnections.size());
            boolean i = false;
            while (object < this.pooledConnections.size()) {
                arrayList.add(this.getSession(null, true));
                ++object;
            }
            list = this.getConnectionPoolSessionCounts();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Session session = (Session)iterator.next();
                session.currentTransaction().begin();
                session.currentTransaction().commit();
                session.close();
            }
        }
        catch (RuntimeException runtimeException) {
            String string = local.message("ERR_Session_Factory_Impl_Failed_To_Complete_Transaction");
            logger.warn(string);
            throw runtimeException;
        }
        for (Integer n : list) {
            if (n == 1) continue;
            String string = local.message("ERR_Session_Counts_Wrong_Creating_Factory", (Object)list.toString());
            logger.warn(string);
            throw new ClusterJFatalInternalException(string);
        }
    }

    protected ClusterConnection createClusterConnection(ClusterConnectionService clusterConnectionService, Map<?, ?> map, int n, int n2) {
        ClusterConnection clusterConnection = null;
        boolean bl = false;
        try {
            clusterConnection = clusterConnectionService.create(this.CLUSTER_CONNECT_STRING, n, this.CLUSTER_CONNECT_TIMEOUT_MGM);
            clusterConnection.setByteBufferPoolSizes(this.CLUSTER_BYTE_BUFFER_POOL_SIZES);
            clusterConnection.connect(this.CLUSTER_CONNECT_RETRIES, this.CLUSTER_CONNECT_DELAY, true);
            clusterConnection.waitUntilReady(this.CLUSTER_CONNECT_TIMEOUT_BEFORE, this.CLUSTER_CONNECT_TIMEOUT_AFTER);
            bl = true;
            if (this.CLUSTER_RECV_THREAD_ACTIVATION_THRESHOLD != 8) {
                clusterConnection.setRecvThreadActivationThreshold(this.CLUSTER_RECV_THREAD_ACTIVATION_THRESHOLD);
            }
            if (this.recvThreadCPUids[n2] != -1) {
                clusterConnection.setRecvThreadCPUid(this.recvThreadCPUids[n2]);
            }
        }
        catch (Exception exception) {
            if (bl) {
                clusterConnection.closing();
                clusterConnection.close();
            }
            for (ClusterConnection clusterConnection2 : this.pooledConnections) {
                clusterConnection2.close();
            }
            this.pooledConnections.clear();
            throw new ClusterJFatalUserException(local.message("ERR_Connecting", (Object)map), exception);
        }
        this.pooledConnections.add(clusterConnection);
        clusterConnection.initializeAutoIncrement(new long[]{this.CLUSTER_CONNECT_AUTO_INCREMENT_BATCH_SIZE, this.CLUSTER_CONNECT_AUTO_INCREMENT_STEP, this.CLUSTER_CONNECT_AUTO_INCREMENT_START});
        return clusterConnection;
    }

    int[] getByteBufferPoolSizes(Map<?, ?> map) {
        String string = SessionFactoryImpl.getStringProperty(map, "com.mysql.clusterj.byte.buffer.pool.sizes", "256, 10240, 102400, 1048576");
        String[] stringArray = string.split("[,; \t\n\r]+", 48);
        int n = stringArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ClusterJFatalUserException(local.message("ERR_Byte_Buffer_Pool_Sizes_Format", (Object)string), numberFormatException);
            }
        }
        return nArray;
    }

    @Override
    public Session getSession() {
        return this.getSession(null, false);
    }

    @Override
    public Session getSession(Map map) {
        return this.getSession(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(Map map, boolean bl) {
        try {
            Db db = null;
            Object object = this;
            synchronized (object) {
                if (!SessionFactory.State.Open.equals((Object)this.state) && !bl) {
                    throw new ClusterJUserException(local.message("ERR_SessionFactory_not_open"));
                }
                ClusterConnection clusterConnection = this.getClusterConnectionFromPool();
                this.checkConnection(clusterConnection);
                db = clusterConnection.createDb(this.CLUSTER_DATABASE, this.CLUSTER_MAX_TRANSACTIONS);
            }
            object = db.getDictionary();
            return new SessionImpl(this, map, db, (Dictionary)object);
        }
        catch (ClusterJException clusterJException) {
            throw clusterJException;
        }
        catch (Exception exception) {
            throw new ClusterJFatalException(local.message("ERR_Create_Ndb"), exception);
        }
    }

    private ClusterConnection getClusterConnectionFromPool() {
        if (this.connectionPoolSize <= 1) {
            return this.pooledConnections.get(0);
        }
        ClusterConnection clusterConnection = null;
        int n = Integer.MAX_VALUE;
        for (ClusterConnection clusterConnection2 : this.pooledConnections) {
            int n2 = clusterConnection2.dbCount();
            if (n2 >= n) continue;
            n = n2;
            clusterConnection = clusterConnection2;
        }
        return clusterConnection;
    }

    private void checkConnection(ClusterConnection clusterConnection) {
        if (clusterConnection == null) {
            throw new ClusterJUserException(local.message("ERR_Session_Factory_Closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> DomainTypeHandler<T> getDomainTypeHandler(Class<T> clazz) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            DomainTypeHandler<?> domainTypeHandler = typeToHandlerMap.get(clazz);
            return domainTypeHandler;
        }
    }

    private static String generateProxyInterfacesKey(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> clazz : classArray) {
            stringBuilder.append(clazz.getCanonicalName()).append(';');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DomainTypeHandler<T> getDomainTypeHandler(Class<T> clazz, Dictionary dictionary) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            DomainTypeHandler<Object> domainTypeHandler = typeToHandlerMap.get(clazz);
            if (logger.isDetailEnabled()) {
                logger.detail("DomainTypeToHandler for " + clazz.getName() + "(" + clazz + ") returned " + domainTypeHandler);
            }
            if (domainTypeHandler == null) {
                domainTypeHandler = this.domainTypeHandlerFactory.createDomainTypeHandler(clazz, dictionary, this.smartValueHandlerFactory);
                if (logger.isDetailEnabled()) {
                    logger.detail("createDomainTypeHandler for " + clazz.getName() + "(" + clazz + ") returned " + domainTypeHandler);
                }
                typeToHandlerMap.put(clazz, domainTypeHandler);
                Class<?>[] classArray = domainTypeHandler.getProxyInterfaces();
                if (classArray != null) {
                    String string = SessionFactoryImpl.generateProxyInterfacesKey(classArray);
                    proxyInterfacesToDomainClass.put(string, clazz);
                }
            }
            return domainTypeHandler;
        }
    }

    public <T> DomainTypeHandler<T> getDomainTypeHandler(T t, Dictionary dictionary) {
        Class<T> clazz = SessionFactoryImpl.getClassForProxy(t);
        DomainTypeHandler<Class<T>> domainTypeHandler = this.getDomainTypeHandler((T)clazz, dictionary);
        return domainTypeHandler;
    }

    protected static <T> Class<T> getClassForProxy(T t) {
        Class<?> clazz = t.getClass();
        if (Proxy.isProxyClass(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            String string = SessionFactoryImpl.generateProxyInterfacesKey(classArray);
            clazz = proxyInterfacesToDomainClass.get(string);
        }
        return clazz;
    }

    public <T> T newInstance(Class<T> clazz, Dictionary dictionary, Db db) {
        DomainTypeHandler<Class<T>> domainTypeHandler = this.getDomainTypeHandler((T)clazz, dictionary);
        return (T)domainTypeHandler.newInstance(db);
    }

    public Table getTable(String string, Dictionary dictionary) {
        Table table;
        try {
            table = dictionary.getTable(string);
        }
        catch (Exception exception) {
            throw new ClusterJFatalInternalException(local.message("ERR_Get_Table"), exception);
        }
        return table;
    }

    protected static String getStringProperty(Map<?, ?> map, String string) {
        return (String)map.get(string);
    }

    protected static String getStringProperty(Map<?, ?> map, String string, String string2) {
        String string3 = (String)map.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    protected static String getRequiredStringProperty(Map<?, ?> map, String string) {
        String string2 = (String)map.get(string);
        if (string2 == null) {
            throw new ClusterJFatalUserException(local.message("ERR_NullProperty", (Object)string));
        }
        return string2;
    }

    protected static int getIntProperty(Map<?, ?> map, String string, int n) {
        Object obj = map.get(string);
        if (obj == null) {
            return n;
        }
        if (Number.class.isAssignableFrom(obj.getClass())) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                int n2 = Integer.parseInt((String)obj);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ClusterJFatalUserException(local.message("ERR_NumericFormat", (Object)string, obj));
            }
        }
        throw new ClusterJUserException(local.message("ERR_NumericFormat", (Object)string, obj));
    }

    protected static long getLongProperty(Map<?, ?> map, String string, long l) {
        Object obj = map.get(string);
        if (obj == null) {
            return l;
        }
        if (Number.class.isAssignableFrom(obj.getClass())) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                long l2 = Long.parseLong((String)obj);
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ClusterJFatalUserException(local.message("ERR_NumericFormat", (Object)string, obj));
            }
        }
        throw new ClusterJUserException(local.message("ERR_NumericFormat", (Object)string, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        for (ClusterConnection clusterConnection : this.pooledConnections) {
            clusterConnection.close();
        }
        this.pooledConnections.clear();
        Map<String, SessionFactoryImpl> map = sessionFactoryMap;
        synchronized (map) {
            sessionFactoryMap.remove(this.key);
        }
        this.state = SessionFactory.State.Closed;
    }

    public void setDomainTypeHandlerFactory(DomainTypeHandlerFactory domainTypeHandlerFactory) {
        this.domainTypeHandlerFactory = domainTypeHandlerFactory;
    }

    public DomainTypeHandlerFactory getDomainTypeHandlerFactory() {
        return this.domainTypeHandlerFactory;
    }

    @Override
    public List<Integer> getConnectionPoolSessionCounts() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (ClusterConnection clusterConnection : this.pooledConnections) {
            arrayList.add(clusterConnection.dbCount());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unloadSchema(Class<?> clazz, Dictionary dictionary) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            String string = null;
            DomainTypeHandler<?> domainTypeHandler = typeToHandlerMap.remove(clazz);
            if (domainTypeHandler != null && (string = domainTypeHandler.getTableName()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing dictionary entry for table " + string + " for class " + clazz.getName());
                }
                dictionary.removeCachedTable(string);
                for (ClusterConnection clusterConnection : this.pooledConnections) {
                    clusterConnection.unloadSchema(string);
                }
            }
            return string;
        }
    }

    public void checkConnection(ClusterJDatastoreException clusterJDatastoreException) {
        if (this.CLUSTER_RECONNECT_TIMEOUT == 0) {
            return;
        }
        this.reconnect(this.CLUSTER_RECONNECT_TIMEOUT);
    }

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public SessionFactory.State currentState() {
        return this.state;
    }

    @Override
    public void reconnect() {
        this.reconnect(this.CLUSTER_RECONNECT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect(int n) {
        logger.warn(local.message("WARN_Reconnect", (Object)this.getConnectionPoolSessionCounts().toString()));
        SessionFactoryImpl sessionFactoryImpl = this;
        synchronized (sessionFactoryImpl) {
            if (SessionFactory.State.Reconnecting.equals((Object)this.state)) {
                logger.warn(local.message("WARN_Reconnect_already"));
                return;
            }
            this.CLUSTER_RECONNECT_TIMEOUT = n;
            if (n == 0) {
                logger.warn(local.message("WARN_Reconnect_timeout0"));
                return;
            }
            this.state = SessionFactory.State.Reconnecting;
            this.threadGroup = new ThreadGroup("Stuff");
            this.reconnectThread = new Thread(this.threadGroup, new ReconnectThread(this));
            this.reconnectThread.start();
            logger.warn(local.message("WARN_Reconnect_started"));
        }
    }

    protected static int countSessions(SessionFactoryImpl sessionFactoryImpl) {
        return SessionFactoryImpl.countSessions(sessionFactoryImpl.getConnectionPoolSessionCounts());
    }

    protected static int countSessions(List<Integer> list) {
        int n = 0;
        for (int n2 : list) {
            n += n2;
        }
        return n;
    }

    @Override
    public void setRecvThreadCPUids(short[] sArray) {
        if (this.connectionPoolSize != sArray.length) {
            throw new ClusterJUserException(local.message("ERR_CPU_Ids_Must_Match_Connection_Pool_Size", (Object)Arrays.toString(sArray), (Object)this.connectionPoolSize));
        }
        short[] sArray2 = new short[sArray.length];
        try {
            int n = 0;
            for (ClusterConnection clusterConnection : this.pooledConnections) {
                if (sArray[n] != this.recvThreadCPUids[n]) {
                    if (sArray[n] != -1) {
                        clusterConnection.setRecvThreadCPUid(sArray[n]);
                    } else {
                        clusterConnection.unsetRecvThreadCPUid();
                    }
                }
                sArray2[n] = sArray[n];
                ++n;
            }
            this.recvThreadCPUids = sArray2;
        }
        catch (Exception exception) {
            for (int i = 0; sArray2[i] != 0 && i < sArray2.length; ++i) {
                ClusterConnection clusterConnection = this.pooledConnections.get(i);
                if (this.recvThreadCPUids[i] == sArray2[i]) continue;
                if (this.recvThreadCPUids[i] == -1) {
                    clusterConnection.unsetRecvThreadCPUid();
                    continue;
                }
                clusterConnection.setRecvThreadCPUid(this.recvThreadCPUids[i]);
            }
            throw exception;
        }
    }

    @Override
    public short[] getRecvThreadCPUids() {
        return this.recvThreadCPUids;
    }

    @Override
    public void setRecvThreadActivationThreshold(int n) {
        if (n < 0) {
            throw new ClusterJUserException(local.message("ERR_Invalid_Activation_Threshold", n));
        }
        this.CLUSTER_RECV_THREAD_ACTIVATION_THRESHOLD = n >= 16 ? 256 : n;
        for (ClusterConnection clusterConnection : this.pooledConnections) {
            clusterConnection.setRecvThreadActivationThreshold(n);
        }
    }

    @Override
    public int getRecvThreadActivationThreshold() {
        return this.CLUSTER_RECV_THREAD_ACTIVATION_THRESHOLD;
    }

    protected static class ReconnectThread
    implements Runnable {
        SessionFactoryImpl factory;

        ReconnectThread(SessionFactoryImpl sessionFactoryImpl) {
            this.factory = sessionFactoryImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<Integer> list = this.factory.getConnectionPoolSessionCounts();
            boolean bl = false;
            int n = this.factory.CLUSTER_RECONNECT_TIMEOUT;
            while (!bl && n-- > 0) {
                bl = SessionFactoryImpl.countSessions(list) == 0;
                if (bl) continue;
                logger.info(local.message("INFO_Reconnect_wait", (Object)list.toString()));
                SessionFactoryImpl.sleep(1000L);
                list = this.factory.getConnectionPoolSessionCounts();
            }
            if (!bl) {
                logger.warn(local.message("WARN_Reconnect_timeout", (Object)list.toString()));
            }
            logger.warn(local.message("WARN_Reconnect_closing"));
            for (ClusterConnection clusterConnection : this.factory.pooledConnections) {
                clusterConnection.closing();
            }
            SessionFactoryImpl.sleep(1000L);
            for (ClusterConnection clusterConnection : this.factory.pooledConnections) {
                clusterConnection.close();
            }
            this.factory.pooledConnections.clear();
            typeToHandlerMap.clear();
            logger.warn(local.message("WARN_Reconnect_creating"));
            this.factory.createClusterConnectionPool();
            this.factory.verifyConnectionPool();
            logger.warn(local.message("WARN_Reconnect_reopening"));
            SessionFactoryImpl sessionFactoryImpl = this.factory;
            synchronized (sessionFactoryImpl) {
                this.factory.state = SessionFactory.State.Open;
            }
        }
    }
}

